/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.service;

import java.util.List;
import java.util.stream.Collectors;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrListItem;
import ru.bitel.oss.kernel.entity.common.bean.dto.EntitySpecDTO;
import ru.bitel.oss.kernel.entity.common.service.EntityService;
import ru.bitel.oss.kernel.entity.server.bean.EntitySpecAttrDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductSpecDao;

@WebService(endpointInterface="ru.bitel.oss.kernel.entity.common.service.EntityService")
public class EntityServiceImpl
extends AbstractService
implements EntityService {
    public EntitySpec entitySpecGet(int id) throws BGException {
        return this.context.getDirectory(EntitySpec.class, 0).get(id);
    }

    public List<EntitySpec> entitySpecList() throws BGException {
        return this.context.getDirectory(EntitySpec.class, 0).list();
    }

    public List<EntitySpecDTO> entitySpecDtoList() throws BGException, BGMessageException {
        return this.context.getDirectory(EntitySpec.class, 0).list().stream().map(EntitySpec::toEntitySpecDTO).collect(Collectors.toList());
    }

    public int entitySpecUpdate(EntitySpec e) throws BGException {
        this.context.getDirectory(EntitySpec.class, 0).update(e);
        return e.getId();
    }

    public EntitySpecAttr entitySpecAttrGet(int id) throws BGException {
        return this.context.getDirectory(EntitySpecAttr.class, 0).get(id);
    }

    public List<EntitySpecAttr> entitySpecAttrList() throws BGException {
        try (EntitySpecAttrDao dao = new EntitySpecAttrDao(this.getConnection());){
            List<EntitySpecAttr> list = dao.list();
            return list;
        }
    }

    public List<EntitySpecAttr> entitySpecAttrListByType(int type) throws BGException {
        try (EntitySpecAttrDao dao = new EntitySpecAttrDao(this.getConnection());){
            List<EntitySpecAttr> list = dao.listByType(type);
            return list;
        }
    }

    public int entitySpecAttrUpdate(EntitySpecAttr e) throws BGException {
        this.context.newDirectory(EntitySpecAttr.class, 0).update(e);
        return e.getId();
    }

    public List<EntitySpecAttrListItem> entitySpecAttrListItemList(int entitySpecId) throws BGException {
        return this.context.getDirectory(EntitySpecAttrListItem.class, entitySpecId).list();
    }

    public int entitySpecAttrListItemUpdate(int entitySpecId, EntitySpecAttrListItem item) throws BGException {
        this.context.getDirectory(EntitySpecAttrListItem.class, entitySpecId).update(item);
        return item.getId();
    }

    public void entitySpecAttrListItemDelete(int entitySpecId, int id) throws BGException {
        this.context.getDirectory(EntitySpecAttrListItem.class, entitySpecId).delete(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entitySpecAttrDelete(int id) throws BGException {
        for (EntitySpec s : this.entitySpecList()) {
            for (EntitySpecAttr a : s.getAttributeList()) {
                if (a.getId() != id) continue;
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0442.\u043a. \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u043a \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438.");
            }
        }
        try (ProductSpecDao productSpecDao = new ProductSpecDao(this.getConnection());){
            if (!productSpecDao.checkEntitySpecAttrDelete(id)) {
                throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0442.\u043a. \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0442 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f.");
            }
            this.context.getDirectory(EntitySpecAttr.class, 0).delete(id);
        }
    }
}

