/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.integration.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.integration.common.bean.RegisterItem;
import ru.bitel.bgbilling.kernel.integration.server.bean.Register;
import ru.bitel.bgbilling.kernel.integration.server.bean.RegisterItemManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class RegisterManager {
    private Connection con;

    public RegisterManager(Connection con) {
        this.con = con;
    }

    public Register getRegisterById(int id) throws BGException {
        Register result = null;
        String query = "SELECT * FROM payment_register WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = new Register();
                    this.loadRegisterFromRS(result, rs);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updateRegister(Register register) throws BGException {
        boolean update = register.getId() > 0;
        String query = (update ? "UPDATE" : "INSERT INTO") + " payment_register SET date=?, title=?, load_time=?, count=?, errorCount=?, summa=?, processed=?, process_time=?, load_log=?, ptitle=?, regtype=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)register.getDate()));
            ps.setString(2, register.getTitle());
            ps.setTimestamp(3, TimeUtils.convertCalendarToTimestamp((Calendar)register.getLoadTime()));
            ps.setInt(4, register.getStringsCount());
            ps.setInt(5, register.getErrorCount());
            ps.setBigDecimal(6, register.getSumm());
            ps.setInt(7, register.isProcessed() ? 1 : 0);
            ps.setTimestamp(8, TimeUtils.convertCalendarToTimestamp((Calendar)register.getProcessTime()));
            ps.setString(9, register.getLoadLog());
            ps.setString(10, register.getPatternTitle());
            ps.setInt(11, register.getRegisterType());
            if (update) {
                ps.setInt(12, register.getId());
            }
            ps.executeUpdate();
            if (!update) {
                register.setId(ServerUtils.lastInsertId(ps));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteRegister(int id) {
        String query = "DELETE FROM payment_register WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<Register> getRegisterList(Period period, int limit) {
        return this.getRegisterList(period, limit, 0);
    }

    public List<Register> getRegisterList(Period period, int limit, int regType) {
        ArrayList<Register> result = new ArrayList<Register>();
        try {
            String query = "SELECT * FROM payment_register WHERE ( ISNULL(?) OR ?<=date ) AND ( ISNULL(?) OR ?>=date ) AND regtype=? ORDER BY date DESC LIMIT ?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            ps.setInt(5, regType);
            ps.setInt(6, limit);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Register pr = new Register();
                this.loadRegisterFromRS(pr, rs);
                result.add(pr);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private void loadRegisterFromRS(Register result, ResultSet rs) throws SQLException {
        result.setId(rs.getInt("id"));
        result.setDate(rs.getDate("date"));
        result.setRegisterType(rs.getInt("regtype"));
        result.setLoadTime(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp("load_time")));
        result.setStringsCount(rs.getInt("count"));
        result.setErrorCount(rs.getInt("errorCount"));
        result.setSumm(rs.getBigDecimal("summa"));
        result.setTitle(rs.getString("title"));
        result.setProcessed(rs.getInt("processed") > 0);
        result.setProcessTime(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp("process_time")));
        result.setLoadLog(rs.getString("load_log"));
        result.setPatternTitle(rs.getString("ptitle"));
    }

    public void processRegister(int userId, Register register) throws BGException {
        RegisterItemManager registerItemManager = new RegisterItemManager(this.con);
        if (register.getRegisterType() == 1) {
            try (ChargeDao chargeDao = new ChargeDao(this.con);
                 BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                for (RegisterItem item : registerItemManager.getRegisterItems(register)) {
                    if (item.getSumma().compareTo(BigDecimal.ZERO) == 0) continue;
                    Charge charge = new Charge();
                    charge.setDate(item.getDate());
                    charge.setContractId(item.getContractId());
                    charge.setComment(item.getBalanceItemComment());
                    charge.setTypeId(item.getBalanceItemTypeId());
                    charge.setSum(item.getSumma());
                    charge.setUserId(userId);
                    chargeDao.update(charge);
                    balanceUtils.updateBalance(charge.getDate(), charge.getContractId());
                    this.con.commit();
                    EventProcessor.getInstance().publish(new ChargeEvent(userId, charge));
                    EventProcessor.getInstance().publish(new ContractBalanceChangedEvent(charge.getContractId(), 4, charge.getSum()));
                    item.setBalanceItemId(charge.getId());
                    registerItemManager.updateRegisterItem(register, item);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            try (PaymentDao paymentDao = new PaymentDao(this.con);
                 BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                for (RegisterItem item : registerItemManager.getRegisterItems(register)) {
                    if (item.getSumma().compareTo(BigDecimal.ZERO) == 0) continue;
                    Payment payment = new Payment();
                    payment.setDate(item.getDate());
                    payment.setContractId(item.getContractId());
                    payment.setComment(item.getBalanceItemComment());
                    payment.setTypeId(item.getBalanceItemTypeId());
                    payment.setSum(item.getSumma());
                    payment.setUserId(userId);
                    paymentDao.update(payment);
                    balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
                    this.con.commit();
                    EventProcessor.getInstance().publish(new PaymentEvent(userId, payment));
                    EventProcessor.getInstance().publish(new ContractBalanceChangedEvent(payment.getContractId(), 3, payment.getSum()));
                    item.setBalanceItemId(payment.getId());
                    registerItemManager.updateRegisterItem(register, item);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        register.setProcessed(true);
        this.updateRegister(register);
    }
}

