/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.basic.server.action.web;

import java.util.Arrays;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPasswordLogItem;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractPasswordLogDao;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ActionPassword
extends AbstractAction {
    private final String moduleName = "contract";

    @Override
    public void execute() throws BGException {
        this.context.getRequest().setAttribute("pageTitle", (Object)this.getPageTitle(4, "contract"));
    }

    public void log() throws BGException {
        try (ContractPasswordLogDao contractPasswordLogDao = new ContractPasswordLogDao(this.con);){
            SearchResult searchResult = new SearchResult();
            searchResult.setPage(new Page(1, 15));
            contractPasswordLogDao.searchContractPasswordLogItemByContractId((SearchResult<ContractPasswordLogItem>)searchResult, this.contractId, Arrays.asList("dt:DESC"));
            this.context.getRequest().setAttribute("logList", (Object)searchResult.getList());
            this.context.getRequest().setAttribute("userMap", UserMap.getMap());
        }
        this.requestDispatcher("contract", "password_log");
    }

    public void password() throws BGException {
        String pswd1 = this.context.getRequest().getParameter("pswd1");
        String pswd2 = this.context.getRequest().getParameter("pswd2");
        if (pswd1 != null && pswd2 != null) {
            try (ContractDao contractDao = new ContractDao(this.con, this.userId);
                 ContractPasswordLogDao contractPasswordLogDao = new ContractPasswordLogDao(this.con);){
                if (contractDao.updatePassword(this.contractId, pswd1, pswd2, false)) {
                    ContractPasswordLogItem item = new ContractPasswordLogItem();
                    item.setDatetime(new Date());
                    item.setContractId(this.contractId);
                    item.setUserId(-1);
                    contractPasswordLogDao.addContractPasswordLogItem(item);
                    this.context.getRequest().setAttribute("status", (Object)"ok");
                }
            }
            catch (BGException e) {
                this.context.getRequest().setAttribute("error", (Object)e.getMessage());
            }
        }
        this.requestDispatcher("contract", "password_form");
    }
}

