/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.telnet.old;

import bitel.billing.server.util.telnet.old.OperationTimedoutException;
import bitel.billing.server.util.telnet.old.TelnetInputStream;
import bitel.billing.server.util.telnet.old.TimeInterval;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TelnetInputStreamConsumer
extends FilterInputStream {
    private long consumptionOperationsTimeout;
    private PrintStream debugStream;
    public static final long BASIC_CRITERIA_CHECK_TIME = 100L;

    public TelnetInputStreamConsumer(TelnetInputStream is) {
        super(is);
        this.debugStream = is.getDebugStream();
    }

    public void registerTelnetCommandListener(TelnetInputStream.TelnetCommandListener tcl) {
        ((TelnetInputStream)this.in).registerTelnetCommandListener(tcl);
    }

    public void removeTelnetCommandListener(TelnetInputStream.TelnetCommandListener tcl) {
        ((TelnetInputStream)this.in).removeTelnetCommandListener(tcl);
    }

    public String consumeInput(long timeout) throws IOException {
        boolean doContinue = true;
        long lastTime = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        while (doContinue) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return sb.toString();
            }
            int c = -1;
            while (this.in.available() > 0) {
                c = this.in.read();
                if (this.debugStream != null) {
                    this.debugStream.print((char)c);
                }
                sb.append((char)c);
            }
            long now = System.currentTimeMillis();
            if (now - lastTime > timeout) {
                doContinue = false;
            }
            if (c == -1) continue;
            lastTime = now;
        }
        return sb.toString();
    }

    public String consumeInput(Pattern toMatch, boolean onlyAtEnd) throws IOException, OperationTimedoutException {
        return this.consumeByCriteria(new PatternBasedCriterium(toMatch, onlyAtEnd));
    }

    public String consumeInput(Pattern toMatch) throws IOException, OperationTimedoutException {
        return this.consumeInput(toMatch, true);
    }

    public String consumeInputUntilStringFoundAtEnd(String s) throws IOException, OperationTimedoutException {
        return this.consumeByCriteria(new StringEndBasedCriterium(s));
    }

    public String consumeInputUntilStringFoundAtEnd(String[] s) throws IOException, OperationTimedoutException {
        Criterium[] c = new Criterium[s.length];
        for (int i = 0; i < s.length; ++i) {
            c[i] = new StringEndBasedCriterium(s[i]);
        }
        return this.consumeByCriteria(new OrCriterium(c));
    }

    public String consumeInputUntilStringFound(String s) throws IOException, OperationTimedoutException {
        return this.consumeByCriteria(new ContainsStringCriterium(s));
    }

    public String consumeInputUntilStringFound(String[] s) throws IOException, OperationTimedoutException {
        Criterium[] c = new Criterium[s.length];
        for (int i = 0; i < s.length; ++i) {
            c[i] = new ContainsStringCriterium(s[i]);
        }
        return this.consumeByCriteria(new OrCriterium(c));
    }

    public String consumeByCriteria(Criterium criteria) throws IOException, OperationTimedoutException {
        StringBuffer sb = new StringBuffer();
        boolean doContinue = true;
        long lastReceptionTime = System.currentTimeMillis();
        do {
            long now;
            String input;
            boolean bl = doContinue = !criteria.holds(input = this.consumeInput(100L));
            if (input.length() > 0) {
                sb.append(input);
                lastReceptionTime = System.currentTimeMillis();
                continue;
            }
            if (this.consumptionOperationsTimeout == 0L || (now = System.currentTimeMillis()) - lastReceptionTime <= this.consumptionOperationsTimeout) continue;
            throw new OperationTimedoutException("Consumption operation timed out: no input from telnet host in " + TimeInterval.describe(this.consumptionOperationsTimeout) + ". Received input follows:" + System.getProperty("line.separator") + sb.toString());
        } while (doContinue);
        return sb.toString();
    }

    public boolean consumeUntilResultOrFailure(String successString, String failureString, String[] result) throws IOException, OperationTimedoutException {
        if (result.length != 1) {
            throw new IllegalArgumentException("Invalid argument: the result array parameter is used to contain the string read from the telnet stream, so it must be of length 1. The passed array has length " + result.length);
        }
        ContainsStringCriterium successCriterium = new ContainsStringCriterium(successString);
        ContainsStringCriterium failureCriterium = new ContainsStringCriterium(failureString);
        OrCriterium c = new OrCriterium(successCriterium, failureCriterium);
        result[0] = this.consumeByCriteria(c);
        if (c.isVerifiedAndHolds(successCriterium)) {
            if (c.isVerifiedAndHolds(failureCriterium)) {
                throw new RuntimeException("Internal error: both failure and success criteria hold - i.e. both strings are found in the telnet result. Please adjust the strings so that they indicates either success or failure");
            }
            return true;
        }
        if (c.isVerifiedAndHolds(failureCriterium)) {
            return false;
        }
        throw new RuntimeException("Internal error: neither success nor failure criteria hold, but consumeByCriteria() has exited without an exception. This looks like a bug in consumeByCriteria()");
    }

    public long getConsumptionOperationsTimeout() {
        return this.consumptionOperationsTimeout;
    }

    public void setConsumptionOperationsTimeout(long consumptionOperationsTimeout) {
        this.consumptionOperationsTimeout = consumptionOperationsTimeout;
    }

    TelnetInputStream getTelnetInputStream() {
        return (TelnetInputStream)this.in;
    }

    public static class PatternBasedCriterium
    implements Criterium {
        private Pattern toMatch;
        private boolean onlyAtEnd;

        PatternBasedCriterium(Pattern toMatch, boolean onlyAtEnd) {
            this.toMatch = toMatch;
            this.onlyAtEnd = onlyAtEnd;
        }

        @Override
        public boolean holds(String input) {
            Matcher matcher = this.toMatch.matcher(input);
            if (matcher.lookingAt()) {
                if (this.onlyAtEnd) {
                    return matcher.end() == input.length();
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "input matches " + this.toMatch;
        }
    }

    public static interface Criterium {
        public boolean holds(String var1);
    }

    public static class StringEndBasedCriterium
    implements Criterium {
        private String endString;

        public StringEndBasedCriterium(String endString) {
            this.endString = endString;
        }

        @Override
        public boolean holds(String input) {
            return input.trim().endsWith(this.endString);
        }

        public String toString() {
            return "input ends with " + this.endString;
        }
    }

    public static class OrCriterium
    extends CompositeCriterium {
        public OrCriterium(Criterium c1, Criterium c2) {
            this(new Criterium[]{c1, c2});
        }

        public OrCriterium(Criterium[] criteria) {
            super(criteria);
        }

        @Override
        public boolean holdsMultiple(String input) {
            for (int i = 0; i < this.operands.length; ++i) {
                if (!this.operands[i].holds(input)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            for (int i = 0; i < this.operands.length; ++i) {
                pw.print(this.operands[i]);
                if (i >= this.operands.length - 1) continue;
                pw.print(" or ");
            }
            return sw.toString();
        }
    }

    public static class ContainsStringCriterium
    implements Criterium {
        private String s;

        public ContainsStringCriterium(String s) {
            this.s = s;
        }

        @Override
        public boolean holds(String input) {
            return input.indexOf(this.s) != -1;
        }

        public String toString() {
            return "input contains " + this.s;
        }
    }

    public static class NoMoreInputAvailableCriterium
    implements Criterium {
        private long timeout;
        private long lastInvocationTime = -1L;
        private boolean cumulative;

        public NoMoreInputAvailableCriterium(boolean cumulative, long waitingTime) {
            this.timeout = waitingTime;
            this.cumulative = cumulative;
        }

        public NoMoreInputAvailableCriterium(boolean cumulative) {
            this(cumulative, 200L);
        }

        @Override
        public boolean holds(String input) {
            if (this.lastInvocationTime == -1L) {
                this.lastInvocationTime = System.currentTimeMillis();
                return false;
            }
            if (input.length() > 0) {
                if (!this.cumulative) {
                    this.lastInvocationTime = System.currentTimeMillis();
                    return false;
                }
                long now = System.currentTimeMillis();
                return now - this.lastInvocationTime > this.timeout;
            }
            long now = System.currentTimeMillis();
            return now - this.lastInvocationTime > this.timeout;
        }

        public String toString() {
            return "no more input is available";
        }
    }

    public static class AndCriterium
    extends CompositeCriterium {
        public AndCriterium(Criterium c1, Criterium c2) {
            this(new Criterium[]{c1, c2});
        }

        public AndCriterium(Criterium[] criteria) {
            super(criteria);
        }

        @Override
        public boolean holdsMultiple(String input) {
            for (int i = 0; i < this.operands.length; ++i) {
                if (this.operands[i].holds(input)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            for (int i = 0; i < this.operands.length; ++i) {
                pw.print(this.operands[i]);
                if (i >= this.operands.length - 1) continue;
                pw.print(" and ");
            }
            return sw.toString();
        }
    }

    public static abstract class CompositeCriterium
    implements Criterium {
        private static final int NOT_VERIFIED = 0;
        private static final int HOLDS = 1;
        private static final int DOES_NOT_HOLD = 2;
        protected OperandWrapper[] operands;
        protected boolean verifyAllRequested;
        private int[] checkedState;

        protected CompositeCriterium(Criterium[] criteria) {
            this(criteria, false);
        }

        protected CompositeCriterium(Criterium[] criteria, boolean verifyAllRequested) {
            this.verifyAllRequested = verifyAllRequested;
            this.operands = new OperandWrapper[criteria.length];
            for (int i = 0; i < criteria.length; ++i) {
                this.operands[i] = new OperandWrapper(criteria[i], i);
            }
            this.checkedState = new int[criteria.length];
            Arrays.fill(this.checkedState, 0);
        }

        @Override
        public final boolean holds(String input) {
            if (this.verifyAllRequested) {
                for (int i = 0; i < this.operands.length; ++i) {
                    this.operands[i].holds(input);
                }
            }
            return this.holdsMultiple(input);
        }

        protected abstract boolean holdsMultiple(String var1);

        private Criterium[] getCriteriaByState(int state) {
            ArrayList<Integer> l = new ArrayList<Integer>();
            for (int i = 0; i < this.checkedState.length; ++i) {
                if (this.checkedState[i] != state) continue;
                l.add(i);
            }
            Criterium[] c = new Criterium[l.size()];
            int count = 0;
            for (Integer index : l) {
                c[count++] = this.operands[index].getWrappedCriterium();
            }
            return c;
        }

        private Criterium getFirstCriteriaByState(int state) {
            Criterium[] c = this.getCriteriaByState(state);
            if (c.length == 0) {
                return null;
            }
            return c[0];
        }

        public Criterium[] getHoldingCriteria() {
            return this.getCriteriaByState(1);
        }

        public Criterium getHoldingCriterium() {
            return this.getFirstCriteriaByState(1);
        }

        public Criterium[] getNotHoldingCriteria() {
            return this.getCriteriaByState(2);
        }

        public Criterium[] getUndefinedCriteria() {
            return this.getCriteriaByState(0);
        }

        public boolean isVerifiedAndHolds(Criterium criteria) {
            return this.verifiedAndInAGivenState(criteria, 1);
        }

        public boolean isVerifiedAndDoesNotHold(Criterium criteria) {
            return this.verifiedAndInAGivenState(criteria, 2);
        }

        public boolean isVerified(Criterium criteria) {
            return !this.verifiedAndInAGivenState(criteria, 0);
        }

        private boolean verifiedAndInAGivenState(Criterium criteria, int state) {
            for (int i = 0; i < this.operands.length; ++i) {
                if (this.operands[i].getWrappedCriterium() != criteria) continue;
                return this.checkedState[i] == state;
            }
            throw new IllegalArgumentException(criteria + " is not a criteria of this " + CompositeCriterium.class.getName());
        }

        public boolean isVerifyAllRequested() {
            return this.verifyAllRequested;
        }

        public void setVerifyAllRequested(boolean verifyAllRequested) {
            this.verifyAllRequested = verifyAllRequested;
        }

        private class OperandWrapper
        implements Criterium {
            private Criterium c;
            private int position;

            OperandWrapper(Criterium c, int position) {
                this.c = c;
                this.position = position;
            }

            @Override
            public boolean holds(String input) {
                boolean result = this.c.holds(input);
                CompositeCriterium.this.checkedState[this.position] = result ? 1 : 2;
                return result;
            }

            Criterium getWrappedCriterium() {
                return this.c;
            }

            public String toString() {
                return this.c.toString();
            }
        }
    }
}

