/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.errorlog;

import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import bitel.billing.server.util.MailMsg;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.AlarmTask;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.DefaultAlarmTask;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.StopableThread;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class AlarmSender
extends StopableThread {
    private static final Logger alarmLogger = LogManager.getLogger((String)"ALARM");
    private static final Logger log = LogManager.getLogger();
    private static AlarmSender sender;
    private DefaultServerSetup setup;
    private String name;
    private String mail;
    private volatile Map<String, Long> minAlarmInterval = new HashMap<String, Long>();
    private Map<String, Long> lastAlarmTime = new ConcurrentHashMap<String, Long>();
    private BlockingQueue<AlarmErrorMessage> alarmQueue = new ArrayBlockingQueue<AlarmErrorMessage>(256);
    private Set<AlarmTask> taskSet = new HashSet<AlarmTask>();
    private Set<String> disabledAlarm = new HashSet<String>();
    private Set<String> toLogAlarm = new HashSet<String>();
    private float memoryCheckThreshold = 0.85f;
    private boolean oldMemoryCheck = true;
    private long lastSystemCheck = 0L;
    private static final long SYSTEM_CHECK_INTERVAL = 2000L;

    public static void initSender(DefaultServerSetup setup) {
        if (sender != null) {
            sender.shutdown();
        }
        sender = new AlarmSender(setup);
    }

    public static void registerAlarmTask(AlarmTask task) {
        if (sender == null) {
            return;
        }
        if (task instanceof DefaultAlarmTask) {
            ((DefaultAlarmTask)task).registerTask(AlarmSender.sender.setup, log);
        }
        AlarmSender.sender.taskSet.add(task);
    }

    public static boolean needAlarmSend(String key, long time, long defaultInterval) {
        return sender != null && sender.needAlarmSendNoStatic(key, time, defaultInterval);
    }

    public static void sendAlarm(AlarmErrorMessage message, long time) {
        if (sender != null) {
            sender.sendAlarmNoStatic(message, time);
        }
    }

    public static void sendAlarm(String key, long defaultInterval, String title, String message, Throwable ex) {
        long millis = System.currentTimeMillis();
        if (AlarmSender.needAlarmSend(key, millis, Math.min(TimeUnit.DAYS.toMillis(1L), defaultInterval))) {
            AlarmErrorMessage m = new AlarmErrorMessage(key, title, message, ex);
            AlarmSender.sendAlarm(m, millis);
        }
    }

    private AlarmSender(DefaultServerSetup setup) {
        this.setup = setup;
        this.name = SetupParam.getApplicationName();
        this.mail = setup.get("alarm.mail", null);
        this.disabledAlarm = Utils.toSet((String)setup.get("alarm.disabled", null));
        this.toLogAlarm = Utils.toSet((String)setup.get("alarm.send.to.log", null));
        try {
            for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
                long maxMemory = pool.getUsage().getMax();
                long warningThreshold = (long)((float)maxMemory * this.memoryCheckThreshold);
                pool.setCollectionUsageThreshold(warningThreshold);
                this.oldMemoryCheck = false;
            }
            MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
            NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
            emitter.addNotificationListener(new NotificationListener(){

                @Override
                public void handleNotification(Notification n, Object hb) {
                    if (n.getType().equals("java.management.memory.collection.threshold.exceeded")) {
                        Runtime r = Runtime.getRuntime();
                        log.warn("Low memory - used=" + (r.totalMemory() - r.freeMemory()) + ", max=" + r.maxMemory());
                        String key = "system.no.memory";
                        long now = System.currentTimeMillis();
                        if (AlarmSender.this.needAlarmSendNoStatic(key, now, 30000L)) {
                            String msg = "\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044e \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0434\u043b\u044f \u043d\u0435\u0433\u043e \u043f\u0430\u043c\u044f\u0442\u0438!\n\u0417\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043e " + r.totalMemory() + " \u0438\u0437 " + r.maxMemory() + " (\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c) \u0431\u0430\u0439\u0442\u043e\u0432 \u043f\u0430\u043c\u044f\u0442\u0438.\n\u0421\u0435\u0439\u0447\u0430\u0441 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u043e: " + r.freeMemory() + " \u0431\u0430\u0439\u0442\u043e\u0432.\n\n\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0434\u0435\u043b\u0438\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0430\u043c\u044f\u0442\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044e.";
                            AlarmSender.sendAlarm(new AlarmErrorMessage(key, "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u043a \u043f\u0430\u043c\u044f\u0442\u0438 \u0441\u0438\u0441\u0442\u0435\u043c\u044b", msg), now);
                        }
                    }
                }
            }, null, null);
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
        this.reloadMinAlarmIntervals();
        if (Utils.notBlankString((String)this.mail)) {
            this.start();
        }
    }

    private void reloadMinAlarmIntervals() {
        HashMap<String, Long> newMinIntervalMap = new HashMap<String, Long>();
        ParameterMap intervals = this.setup.sub("alarm.min.interval.");
        for (Map.Entry me : intervals.entrySet()) {
            String key = (String)me.getKey();
            int value = Utils.parseInt((String)((String)me.getValue()));
            if (value < 0) continue;
            newMinIntervalMap.put(key, (long)value * 1000L);
        }
        this.minAlarmInterval = newMinIntervalMap;
    }

    private boolean needAlarmSendNoStatic(String key, long time, long defaultInterval) {
        Long lastSendTime = this.lastAlarmTime.get(key);
        Long interval = this.minAlarmInterval.get(key);
        if (interval == null) {
            interval = defaultInterval;
        }
        return lastSendTime == null || time - lastSendTime > interval;
    }

    private void sendAlarmNoStatic(AlarmErrorMessage message, long time) {
        String key = message.getKey();
        if (this.disabledAlarm.contains(key)) {
            message.setSendToEmail(false);
        }
        if (this.toLogAlarm.contains(key) || this.toLogAlarm.contains("*")) {
            message.setSendToLog(true);
        }
        if (!message.isSendToEmail() && !message.isSendToLog()) {
            log.debug("disabled alarm ignored: " + message.getKey());
            return;
        }
        while (!this.alarmQueue.offer(message)) {
            this.alarmQueue.poll();
        }
        this.lastAlarmTime.put(message.getKey(), time);
    }

    private static String getLocalHostHame() {
        try {
            return InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            return "hostname not resolved: " + e.getMessage();
        }
    }

    public void run() {
        while (this.working) {
            try {
                for (int i = 0; i < 3 && this.tryProcessMessage(); ++i) {
                }
                if (this.oldMemoryCheck) {
                    this.checkSystemHealth();
                }
                for (AlarmTask task : this.taskSet) {
                    task.doTask();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        log.info("Stopping AlarmSender");
    }

    private boolean tryProcessMessage() throws InterruptedException, BGException {
        AlarmErrorMessage message = this.alarmQueue.poll(5L, TimeUnit.SECONDS);
        if (message == null) {
            return false;
        }
        StringBuilder stack = null;
        if (message.isDumpStackTrace()) {
            stack = new StringBuilder(500);
            AlarmSender.dumpStack(stack);
        }
        StringBuilder text = new StringBuilder(200);
        text.append("\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435: ").append(this.name).append("\n");
        text.append("ID \u0441\u043e\u0431\u044b\u0442\u0438\u044f: ").append(message.getKey()).append("\n");
        text.append("\u0412\u0440\u0435\u043c\u044f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438: ").append(TimeUtils.format((Date)message.getRegistrationTime(), (String)"dd.MM.yyyy HH:mm:ss")).append("\n");
        text.append("\u0425\u043e\u0441\u0442: ").append(AlarmSender.getLocalHostHame()).append("\n\n");
        text.append(message.getText());
        if (stack != null) {
            text.append("\nStack trace:\n\n");
            text.append((CharSequence)stack);
            stack = null;
        }
        if (message.isSendToEmail()) {
            new MailMsg(this.setup).sendMessage(this.mail, "[" + this.name + "] " + message.getSubject(), text.toString());
        }
        if (message.isSendToLog()) {
            alarmLogger.error("[" + this.name + "]  " + text.toString());
        }
        return true;
    }

    private void checkSystemHealth() {
        long now = System.currentTimeMillis();
        if (now - this.lastSystemCheck > 2000L) {
            Runtime r = Runtime.getRuntime();
            if ((float)r.maxMemory() * this.memoryCheckThreshold < (float)(r.totalMemory() - r.freeMemory())) {
                String key = "system.no.memory";
                String msg = "\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044e \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0434\u043b\u044f \u043d\u0435\u0433\u043e \u043f\u0430\u043c\u044f\u0442\u0438!\n\u0417\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043e " + r.totalMemory() + " \u0438\u0437 " + r.maxMemory() + " (\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c) \u0431\u0430\u0439\u0442\u043e\u0432 \u043f\u0430\u043c\u044f\u0442\u0438.\n\u0421\u0435\u0439\u0447\u0430\u0441 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u043e: " + r.freeMemory() + " \u0431\u0430\u0439\u0442\u043e\u0432.\n\n\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0434\u0435\u043b\u0438\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0430\u043c\u044f\u0442\u0438 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044e.";
                if (this.needAlarmSendNoStatic(key, now, 30000L)) {
                    this.sendAlarmNoStatic(new AlarmErrorMessage(key, "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u043a \u043f\u0430\u043c\u044f\u0442\u0438 \u0441\u0438\u0441\u0442\u0435\u043c\u044b", msg), now);
                }
                r.gc();
            }
            this.lastSystemCheck = now;
        }
    }

    public static synchronized void dumpStack(StringBuilder sb) {
        try {
            ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] dump = threadMxBean.dumpAllThreads(true, true);
            boolean cpuTime = threadMxBean.isThreadCpuTimeSupported() && threadMxBean.isThreadCpuTimeEnabled();
            for (ThreadInfo ti : dump) {
                AlarmSender.toString(threadMxBean, ti, sb, cpuTime);
            }
            long[] deadlocks = threadMxBean.findDeadlockedThreads();
            if (deadlocks != null && deadlocks.length > 0) {
                sb.append("Deadlocks found: ");
                for (long id : deadlocks) {
                    sb.append(id).append(' ');
                }
            }
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
        }
    }

    public static void toString(ThreadMXBean threadMxBean, ThreadInfo info, StringBuilder sb, boolean cpuTime) {
        LockInfo[] locks;
        int i;
        sb.append("\"").append(info.getThreadName()).append('\"');
        sb.append(" Id=").append(info.getThreadId()).append(' ').append((Object)info.getThreadState());
        if (info.getLockName() != null) {
            sb.append(" on " + info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"" + info.getLockOwnerName() + "\" Id=" + info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        if (cpuTime) {
            long cpu = threadMxBean.getThreadCpuTime(info.getThreadId());
            sb.append(", cpu=").append(AlarmSender.formatCpuTime(cpu / 1000000000L));
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = info.getStackTrace();
        for (i = 0; i < stackTrace.length && i < 24; ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat " + ste.toString());
            sb.append('\n');
            if (i == 0 && info.getLockInfo() != null) {
                Thread.State ts = info.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on " + info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : info.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + (MonitorInfo)lockInfo);
                sb.append('\n');
            }
        }
        if (i < stackTrace.length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = info.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- " + lockInfo);
                sb.append('\n');
            }
        }
        sb.append('\n');
    }

    private static String formatCpuTime(long seconds) {
        StringBuilder buf = new StringBuilder(24);
        long hour = seconds / 3600L;
        if (hour < 10L) {
            buf.append("0");
        }
        buf.append(hour);
        buf.append(":");
        long minute = seconds % 3600L / 60L;
        if (minute < 10L) {
            buf.append("0");
        }
        buf.append(minute);
        buf.append(":");
        long second = seconds % 60L;
        if (second < 10L) {
            buf.append("0");
        }
        buf.append(second);
        return buf.toString();
    }
}

