/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.bgsecure.bean;

import bitel.billing.server.admin.action.ActionMenuAndToolBar;
import bitel.billing.server.admin.bgsecure.bean.RestrictionMap;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.Setup;

public class MenuRestrictManager {
    private Connection con;

    public MenuRestrictManager(Connection con) {
        this.con = con;
    }

    public Map<String, Boolean> getUserMenuRestrictions(int uid) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            String query = "SELECT menu_id, hidden FROM user_menu WHERE uid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, uid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String key = rs.getString(1);
                Boolean value = rs.getBoolean(2);
                if (result.containsKey(key)) {
                    result.remove(key);
                }
                result.put(key, value);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Map<String, Boolean> getGroupMenuRestrictions(int groupId) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            String query = "SELECT menu_id, hidden FROM bgs_group_menu WHERE gid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, groupId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String key = rs.getString(1);
                Boolean value = rs.getBoolean(2);
                if (result.containsKey(key)) {
                    result.remove(key);
                }
                result.put(key, value);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void addGroupMenuRestriction(int gid, String menu, boolean hide) {
        try {
            String query = "INSERT INTO bgs_group_menu VALUES(?,?,?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, gid);
            ps.setString(2, menu);
            ps.setBoolean(3, hide);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteGroupMenuRestriction(int gid, String menu) {
        try {
            String query = "DELETE FROM bgs_group_menu WHERE gid=? AND menu_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, gid);
            ps.setString(2, menu);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addUserMenuRestriction(int uid, String menu, boolean hide) {
        try {
            String query = "INSERT INTO user_menu VALUES ( ?, ?, ? )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, uid);
            ps.setString(2, menu);
            ps.setBoolean(3, hide);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteUserMenuRestriction(int uid, String menu) {
        try {
            String query = "DELETE FROM user_menu WHERE uid=? AND menu_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, uid);
            ps.setString(2, menu);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public RestrictionMap getMenuAccessListForUser(int userID) {
        RestrictionMap result = new RestrictionMap();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT menu_id, hidden FROM user_menu WHERE uid=?");){
            ps.setInt(1, userID);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.put(rs.getString(1), rs.getBoolean(2));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<String[]> menuBarList() {
        ArrayList<String[]> idTitles = new ArrayList<String[]>();
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            File fileMenu = new File(Setup.getSetup().get("file.menu", "data/menu.xml"));
            URL url = fileMenu.toURI().toURL();
            Document doc = docBuilder.parse(url.toString());
            Element menuBar = doc.getDocumentElement();
            HashMap<String, String> menuMap = new HashMap<String, String>();
            this.buildMenuBarList(menuBar, null, null, idTitles, menuMap);
            this.addPluginMenu(idTitles, menuMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return idTitles;
    }

    private void buildMenuBarList(Element menuElement, String id, String title, List<String[]> idTitles, Map<String, String> menuMap) {
        NodeList nodeList = menuElement.getChildNodes();
        int len = nodeList.getLength();
        for (int index = 0; index < len; ++index) {
            Element element;
            String attrId;
            Node node = nodeList.item(index);
            if (node == null || node.getNodeType() != 1 || (attrId = (element = (Element)node).getAttribute("id")).length() == 0) continue;
            String attrTitle = element.getAttribute("title");
            if ("menu".equals(element.getNodeName())) {
                String menuId = (String)(id == null ? "" : id + ".") + attrId;
                String menuTitle = (String)(title == null ? "" : title + " => ") + attrTitle;
                menuMap.put(menuId, menuTitle);
                this.buildMenuBarList(element, menuId, menuTitle, idTitles, menuMap);
                continue;
            }
            if (!"menuItem".equals(element.getNodeName())) continue;
            String[] idTitle = new String[]{id + "." + attrId, title + " => " + attrTitle};
            idTitles.add(idTitle);
        }
        if ("modules".equals(id)) {
            this.addModules(id, title, idTitles);
        }
    }

    private void addModules(String id, String title, List<String[]> idTitles) {
        for (BGModule bgModule : ModuleCache.getInstance().getModulesList()) {
            String[] idTitle = new String[]{id + "." + bgModule.getId(), title + " => " + bgModule.getTitle()};
            idTitles.add(idTitle);
        }
    }

    private void addPluginMenu(List<String[]> idTitles, Map<String, String> menuMap) {
        HashMap<String, String[]> idElementMenu = new HashMap<String, String[]>();
        for (BGPlugInElement extension : BGPluginManagerServer.getManager().getExtensions(ActionMenuAndToolBar.class.getCanonicalName(), false)) {
            try {
                Element extensionElement = extension.getElement();
                BGPluginServer plugin = (BGPluginServer)extension.getPlugin();
                this.addPluginMenuItem(extensionElement, idTitles, menuMap);
                NodeList menuList = extensionElement.getElementsByTagName("menu");
                for (int index1 = 0; index1 < menuList.getLength(); ++index1) {
                    Element pluginMenuElement = (Element)menuList.item(index1);
                    String menuId = pluginMenuElement.getAttribute("id");
                    String menuTitle = plugin.getResourceString(pluginMenuElement.getAttribute("title"));
                    if (menuTitle.length() == 0) {
                        menuTitle = menuMap.get(menuId);
                    }
                    NodeList menuItemList = pluginMenuElement.getElementsByTagName("menuItem");
                    for (int index2 = 0; index2 < menuItemList.getLength(); ++index2) {
                        Element menuItemElement = (Element)menuItemList.item(index2);
                        String menuItemClassName = menuItemElement.getAttribute("className");
                        String menuItemTitle = plugin.getResourceString(menuItemElement.getAttribute("title"));
                        if (idElementMenu.containsKey(menuId)) continue;
                        String[] idTitle = new String[]{menuId + "." + menuItemElement.getAttribute("id"), menuTitle + " => " + menuItemTitle};
                        idTitles.add(idTitle);
                        idElementMenu.put(menuId, idTitle);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void addPluginMenuItem(Element menuElement, List<String[]> idTitles, Map<String, String> menuMap) {
        NodeList nodeList = menuElement.getChildNodes();
        int len = nodeList.getLength();
        for (int index = 0; index < len; ++index) {
            Element element;
            String attrId;
            Node node = nodeList.item(index);
            if (node == null || node.getNodeType() != 1 || (attrId = (element = (Element)node).getAttribute("id")).length() == 0) continue;
            String attrTitle = element.getAttribute("title");
            if (!"menu".equals(element.getNodeName())) continue;
        }
    }
}

