/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLink;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficTypeLinkRule;
import ru.bitel.bgbilling.modules.inet.server.runtime.TrafficTypeLinkRuleRuntime;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.util.Ranger;

public class TrafficTypeLinkRuntime {
    public final String title;
    public final TrafficTypeLinkRuleRuntime[] trafficTypeLinkRulesFlow;
    public final TrafficTypeLinkRuleRuntime[] trafficTypeLinkRulesCounter;
    public Set<Integer> counterTrafficTypes;
    public Integer[] trafficServiceIds;
    public Set<Integer> trafficServiceIdSet;
    private static final Ranger<TrafficTypeLinkRule, Date> ranger = new Ranger<TrafficTypeLinkRule, Date>(){

        public Date getMinValue(TrafficTypeLinkRule r) {
            return r.dateFrom;
        }

        public Date getMaxValue(TrafficTypeLinkRule r) {
            return r.dateTo;
        }
    };

    TrafficTypeLinkRuntime(TrafficTypeLink trafficTypeLink, Date dateFrom) {
        this.title = trafficTypeLink.getTitle();
        List ruleList = RangeUtils.subListContains((Collection)trafficTypeLink.getTrafficTypeLinkRuleList(), ranger, (Comparable)dateFrom, (Comparable)dateFrom);
        ArrayList<TrafficTypeLinkRuleRuntime> trafficTypeLinkRuleListCounter = new ArrayList<TrafficTypeLinkRuleRuntime>();
        ArrayList<TrafficTypeLinkRuleRuntime> trafficTypeLinkRuleListFlow = new ArrayList<TrafficTypeLinkRuleRuntime>();
        Set serviceIds = Collections.newSetFromMap(new LinkedHashMap());
        serviceIds.add(-TrafficType.TIME_ID.intValue() - 1);
        for (TrafficTypeLinkRule rule : ruleList) {
            if (rule.type == 1) {
                trafficTypeLinkRuleListCounter.add(TrafficTypeLinkRuleRuntime.newInstance(rule));
            } else {
                trafficTypeLinkRuleListFlow.add(TrafficTypeLinkRuleRuntime.newInstance(rule));
            }
            serviceIds.add(-rule.trafficTypeId.intValue() - 1);
        }
        this.trafficTypeLinkRulesCounter = trafficTypeLinkRuleListCounter.toArray(new TrafficTypeLinkRuleRuntime[trafficTypeLinkRuleListCounter.size()]);
        this.trafficTypeLinkRulesFlow = trafficTypeLinkRuleListFlow.toArray(new TrafficTypeLinkRuleRuntime[trafficTypeLinkRuleListFlow.size()]);
        this.trafficServiceIds = serviceIds.toArray(new Integer[serviceIds.size()]);
        this.trafficServiceIdSet = Collections.unmodifiableSet(serviceIds);
        this.counterTrafficTypes = new HashSet<Integer>();
        for (TrafficTypeLinkRuleRuntime rule : this.trafficTypeLinkRulesCounter) {
            this.counterTrafficTypes.add(rule.trafficTypeId);
        }
    }

    public TrafficTypeLinkRuleRuntime getRule(int sourceId, int direction, int iface, IpAddress address, int port, int diffServ, long millis, int inetServInterfaceId) {
        TrafficTypeLinkRuleRuntime[] rules = this.trafficTypeLinkRulesFlow;
        for (int i = 0; i < rules.length; ++i) {
            TrafficTypeLinkRuleRuntime rule = rules[i];
            if (rule.sourceId > 0 && rule.sourceId != sourceId || rule.direction != direction && rule.direction != 0 || (rule.interfaceId < 0 ? rule.interfaceId == -2 && inetServInterfaceId != iface : rule.interfaceId != iface)) continue;
            if (rule.diffServ != -1 && (diffServ & rule.diffServMask) != rule.diffServ || rule.timeFrom != 0L && rule.timeFrom > millis || rule.timeTo != 0L && rule.timeTo < millis || rule.addressFrom != null && rule.addressFrom.compareTo(address) > 0 || rule.addressTo != null && rule.addressTo.compareTo(address) < 0 || rule.portFrom != 0 && rule.portFrom > port || rule.portTo != 0 && rule.portTo < port) continue;
            return rule;
        }
        return null;
    }
}

