/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.task;

import com.linuxense.javadbf.DBFReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.plugins.fias.server.util.FiasUtil;
import ru.bitel.bgbilling.plugins.fias.server.util.tables.AddrTable;
import ru.bitel.bgbilling.plugins.fias.server.util.tables.HouseTable;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class RegionLoadTask
implements Callable<Integer> {
    private Logger logger = LogManager.getLogger();
    private String regionId = null;
    private Connection con = null;

    public RegionLoadTask(String regionId) {
        this.regionId = regionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        this.logger.info("Start loading FIAS region =" + this.regionId);
        long start = System.currentTimeMillis();
        try {
            this.con = FiasUtil.getFiasConnection();
            try {
                Path dirAddr = FiasUtil.getFiasPath("/ADDROB" + this.regionId + ".DBF");
                DBFReader readerAddr = new DBFReader(Files.newInputStream(dirAddr, new OpenOption[0]));
                readerAddr.setCharactersetName("cp866");
                AddrTable addrTable = new AddrTable("addrobj" + this.regionId);
                addrTable.loadTable(this.con, readerAddr);
                Path dirHouse = FiasUtil.getFiasPath("/HOUSE" + this.regionId + ".DBF");
                DBFReader readerHouse = new DBFReader(Files.newInputStream(dirHouse, new OpenOption[0]));
                readerHouse.setCharactersetName("cp866");
                HouseTable houseTable = new HouseTable("house" + this.regionId);
                houseTable.loadTable(this.con, readerHouse);
            }
            finally {
                ServerUtils.closeConnection((Connection)this.con);
            }
        }
        catch (Exception ex) {
            this.logger.error("Loading FIAS region =" + this.regionId + " is ERROR", (Throwable)ex);
            throw ex;
        }
        long delta = System.currentTimeMillis() - start;
        this.logger.info("Loading FIAS region =" + this.regionId + " is done.." + TimeUtils.formatDeltaTime((long)(delta / 1000L)));
        return 1;
    }
}

