/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebAgent;
import ru.bitel.bgbilling.modules.drwebn.common.bean.DrwebTariff;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebAgentDAO;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebApiManager;
import ru.bitel.bgbilling.modules.drwebn.server.bean.DrwebTariffDAO;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Result;

@Deprecated
public class ActionGetUrl
extends AbstractAction {
    private DrwebApiManager manager;
    private DrwebAgentDAO agentManager;

    public ActionGetUrl() {
        super("drwebn");
    }

    @PostConstruct
    protected void init() {
        this.manager = new DrwebApiManager(this.con, (ParameterMap)this.moduleSetup, this.moduleId);
        this.agentManager = new DrwebAgentDAO(this.con, this.moduleId);
    }

    public void execute() throws BGException {
        int step = this.req.getInt("step", 0);
        int tariffId = this.req.getInt("tariff", -1);
        Result result = new Result(new ArrayList());
        try {
            result.setList(this.agentManager.getAgentListByCid(this.contractId));
            if (step == 1) {
                this.manager.checkMaxAgentCount(this.contractId);
                DrwebAgent agent = this.manager.newAgent(this.contractId, tariffId);
                result.setAttribute("agent", (Object)agent);
                result.setAttribute("step", (Object)"1");
            } else {
                result.setAttribute("step", (Object)"0");
                result.setAttribute("tariffs", this.getTariffs(true));
            }
        }
        catch (BGException ex) {
            result.setAttribute("error", (Object)ex.getMessage());
        }
    }

    public Result<DrwebAgent> block() {
        Result result = new Result(new ArrayList());
        try {
            int monthCount = this.req.getInt("monthCount", -1);
            if (monthCount != -1) {
                // empty if block
            }
            this.execute();
            return result;
        }
        catch (Exception ex) {
            result.setAttribute("error", (Object)ex.getMessage());
            return result;
        }
    }

    public Result<DrwebAgent> delete() throws SQLException, BGException {
        this.execute();
        return new Result(new ArrayList());
    }

    public Result<DrwebAgent> changeTariff() {
        Result result = new Result(new ArrayList());
        try {
            int tariffId = this.req.getInt("tariff", -1);
            if (tariffId != -1) {
                // empty if block
            }
            this.execute();
            return result;
        }
        catch (Exception ex) {
            result.setAttribute("error", (Object)ex.getMessage());
            return result;
        }
    }

    public Result<DrwebAgent> change() {
        Result result = new Result(new ArrayList());
        try {
            DrwebAgent agent = (DrwebAgent)this.agentManager.get(this.req.getInt("agentId", -1));
            result.setAttribute("agent", (Object)agent);
            result.setAttribute("change", (Object)"1");
            result.setAttribute("tariffs", this.getTariffs(false));
        }
        catch (Exception ex) {
            result.setAttribute("error", (Object)ex.getMessage());
        }
        return result;
    }

    public Result<DrwebAgent> active() throws SQLException, BGException {
        this.execute();
        return new Result(new ArrayList());
    }

    protected List<DrwebTariff> getTariffs(boolean forNew) throws BGException {
        ArrayList<DrwebTariff> res = new ArrayList<DrwebTariff>();
        try (ContractManager contractManager = new ContractManager(this.con);
             DrwebTariffDAO tariffManager = new DrwebTariffDAO(this.con, this.moduleId);){
            Contract contract = contractManager.getContractById(this.contractId);
            if (contract == null) {
                List<DrwebTariff> list = tariffManager.getListAll();
                return list;
            }
            for (DrwebTariff tariff : tariffManager.getListAll()) {
                String groupStr = tariff.getGroupForView();
                if (!Utils.isEmptyString((String)groupStr)) {
                    long grTariff = Utils.enumToMask((String)groupStr);
                    if ((contract.getGroups() & grTariff) == 0L) continue;
                }
                if (!forNew && tariff.isOnlyForNew()) continue;
                Date date = new Date();
                Date from = tariff.getDateFromView();
                Date to = tariff.getDateToView();
                if (from != null && !TimeUtils.dateBeforeOrEq((Date)from, (Date)date) || to != null && !TimeUtils.dateBeforeOrEq((Date)date, (Date)to)) continue;
                res.add(tariff);
            }
        }
        return res;
    }
}

