/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.action.web;

import bitel.billing.server.ActionConType;
import javax.annotation.PostConstruct;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsService;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@ActionConType(value=2)
public class ActionDocuments
extends AbstractAction {
    private DocumentsService service;

    public ActionDocuments() {
        super("documents");
    }

    @PostConstruct
    public void init() throws BGException {
        this.service = (DocumentsService)this.context.newService(DocumentsService.class, this.moduleId);
    }

    public void execute() throws BGException {
    }

    public void list() throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(new Page(1, 0));
        searchResult.setList(this.service.getDocumentList(this.contractId, null, new Period()));
        this.context.getRequest().setAttribute("searchResult", (Object)searchResult);
        this.context.getRequest().setAttribute("journalList", (Object)this.service.documentJournalList());
        this.context.getRequest().setAttribute("typeList", (Object)this.service.documentTypeList());
        this.requestDispatcher(this.moduleName, "list");
    }

    public void info() throws BGException {
        int documentId = this.req.getInt("id", -1);
        Document document = this.service.getDocument(documentId);
        if (document != null && document.getContractId() == this.contractId) {
            this.context.getRequest().setAttribute("userMap", (Object)UserMap.getMap());
            this.context.getRequest().setAttribute("statusList", (Object)this.service.documentStatusList());
            this.context.getRequest().setAttribute("statusLog", (Object)this.service.getDocumentStatusLogList(documentId));
            this.context.getRequest().setAttribute("documentFileList", (Object)this.service.getDocumentFileList(documentId));
        }
        this.requestDispatcher(this.moduleName, "info");
    }
}

