/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor.dialup;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import bitel.billing.server.radius.RadiusSetup;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpSession;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNas;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.StopableThread;
import ru.bitel.common.worker.ThreadContext;

public class ZombiChecker
extends StopableThread {
    private static Logger logger = LogManager.getLogger((String)"processor");
    private DialUpNas nas;
    private int dropSleepTimeOut = 0;

    public ZombiChecker(DialUpNas nas) {
        this.nas = nas;
        ParameterMap conf = nas.getConf();
        this.dropSleepTimeOut = conf.getInt("drop.sleep.timeout", this.dropSleepTimeOut);
        if (this.dropSleepTimeOut <= 0) {
            this.dropSleepTimeOut = conf.getInt("nas.inspector.snmp.drop.sleep.timeout", this.dropSleepTimeOut);
        }
        if (this.dropSleepTimeOut > 0) {
            this.start();
            logger.info("Starting zombi checker " + nas.getNasIdentifier());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.info("Starting ZombiChecker for " + this.nas);
        while (this.working) {
            RadiusSetup setup = RadiusSetup.getSetup();
            ServerContext context = new ServerContext((Setup)setup, setup.getModuleId(), 0);
            context.init();
            ServerContext parentContext = (ServerContext)ThreadContext.get();
            ThreadContext.set((ThreadContext)context);
            try {
                GregorianCalendar now = new GregorianCalendar();
                boolean hasActive = false;
                for (DialUpNasConnection nasCon : this.nas.connections()) {
                    DialUpSession nasSession = (DialUpSession)nasCon.getSession();
                    if (nasSession.getStopTime() == null) continue;
                    long startDelta = (now.getTimeInMillis() - nasSession.getStartTime().getTimeInMillis()) / 1000L;
                    long stopDelta = (now.getTimeInMillis() - nasSession.getStopTime().getTimeInMillis()) / 1000L;
                    if (nasCon.getStatus() != NasConnection.Status.working || startDelta <= (long)this.dropSleepTimeOut || stopDelta >= (long)this.dropSleepTimeOut) continue;
                    hasActive = true;
                    break;
                }
                if (hasActive) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Checking zombi " + this.nas.getId());
                    }
                    for (DialUpNasConnection con : this.nas.connections()) {
                        this.dropZombi(con, now);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ThreadContext.set((ThreadContext)parentContext);
                context.destroy();
                context = null;
            }
            try {
                ZombiChecker.sleep((long)60000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info("Stopping ZombiChecker for " + this.nas);
    }

    private boolean dropZombi(DialUpNasConnection con, Calendar now) {
        boolean result = false;
        DialUpSessionRealtime session = (DialUpSessionRealtime)con.getSession();
        if (session.getStopTime() == null) {
            return false;
        }
        long delta = (now.getTimeInMillis() - session.getStopTime().getTimeInMillis()) / 1000L;
        session.addLogDebug("Checking zombi delta => " + delta + "; status => " + con.getStatus() + "; dropSleepTimeOut => " + this.dropSleepTimeOut);
        if (this.dropSleepTimeOut != 0 && delta > (long)this.dropSleepTimeOut) {
            session.addLogInfo("Removing as zombi..");
            this.nas.dropConnection(session.getNasPort());
        }
        return result;
    }
}

