/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor.dialup;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import bitel.billing.server.radius.RadiusSetup;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNas;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.StopableThread;
import ru.bitel.common.TimeUtils;

public class ConnectionBreaker
extends StopableThread {
    private static Logger logger = LogManager.getLogger((String)"processor");
    private DialUpNas nas;
    private final int monthBreakPeriod;

    public ConnectionBreaker(DialUpNas nas) {
        this.nas = nas;
        ParameterMap nasConf = nas.getConf();
        int monthWrap = nasConf.getInt("month.break", 0);
        if (monthWrap > 0) {
            this.start();
            logger.info("Starting connections month breaker " + nas.getNasIdentifier());
        }
        this.monthBreakPeriod = nasConf.getInt("month.break.period", 3600);
    }

    public void run() {
        Iterator iter = null;
        Random random = new Random();
        int wait = 60000;
        try {
            ConnectionBreaker.sleep((long)random.nextInt(60000));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("Starting ConnectionBreaker for: " + this.nas);
        while (this.working) {
            GregorianCalendar now = new GregorianCalendar();
            int month = now.get(2);
            Calendar borderTime = TimeUtils.parseCalendar((String)RadiusSetup.getSetup().get("drop.session.before.time", null), (String)"dd.MM.yyyy HH:mm:ss");
            iter = this.nas.connections().iterator();
            if (iter == null || !iter.hasNext()) {
                try {
                    ConnectionBreaker.sleep((long)60000L);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                iter = this.nas.connections().iterator();
            }
            try {
                int maxCount = 100;
                while (iter.hasNext()) {
                    DialUpNasConnection con = (DialUpNasConnection)((Object)iter.next());
                    Calendar startTime = ((DialUpSessionRealtime)con.getSession()).getStartTime();
                    if (startTime == null || startTime.get(2) == month && (borderTime == null || !startTime.before(borderTime))) continue;
                    ((DialUpSessionRealtime)con.getSession()).addLogDebug("Candidate to month break..");
                    while ((double)Setup.getSetup().getMasterPoolLoad() > 0.2) {
                        ((DialUpSessionRealtime)con.getSession()).addLogInfo("Month break skip by database load");
                        ConnectionBreaker.sleep((long)random.nextInt(5000));
                    }
                    if (random.nextInt(2) != 1) continue;
                    con.kill(this.nas);
                    ((DialUpSessionRealtime)con.getSession()).addLogInfo("Month break, maxCount=" + --maxCount);
                    ConnectionBreaker.sleep((long)1000L);
                    if (maxCount != 0) continue;
                    break;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            try {
                ConnectionBreaker.sleep((long)60000L);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.info("Stopping ConnectionBreaker for: " + this.nas);
    }
}

