/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.PacketChannel;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class PacketChannelManager {
    private Connection con;
    private int mid;

    public PacketChannelManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public void deletePacketChannels(int packetId) throws BGException {
        try {
            String query = "DELETE FROM packet_channel_" + this.mid + " WHERE pid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, packetId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deletePacketChannel(int id) throws BGException {
        try {
            String query = "DELETE FROM packet_channel_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updatePacketChannel(PacketChannel packetChannel) throws BGException {
        String query = null;
        PreparedStatement ps = null;
        try {
            if (packetChannel.getId() <= 0) {
                query = "INSERT INTO packet_channel_" + this.mid + " (pid, chid, date1, date2, comment) VALUES (?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE packet_channel_" + this.mid + " SET pid=?, chid=?, date1=?, date2=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(6, packetChannel.getId());
            }
            ps.setInt(1, packetChannel.getPacketId());
            ps.setInt(2, packetChannel.getChannelId());
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)packetChannel.getDateFrom()));
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)packetChannel.getDateTo()));
            ps.setString(5, packetChannel.getComment());
            ps.executeUpdate();
            if (packetChannel.getId() <= 0) {
                packetChannel.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public PacketChannel getPacketChannelById(int id) throws BGException {
        PacketChannel result = null;
        try {
            String query = "SELECT * FROM packet_channel_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new PacketChannel();
                this.loadFromRS(result, rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<PacketChannel> getPacketChannelList(int packetID) throws BGException {
        ArrayList<PacketChannel> result = new ArrayList<PacketChannel>(100);
        try {
            String query = "SELECT * FROM packet_channel_" + this.mid + " WHERE pid=? ORDER BY date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, packetID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PacketChannel packetContent = new PacketChannel();
                result.add(packetContent);
                this.loadFromRS(packetContent, rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<PacketChannel> getPacketChannelList(Calendar date) throws BGException {
        ArrayList<PacketChannel> result = new ArrayList<PacketChannel>();
        try {
            String query = "SELECT * FROM packet_channel_" + this.mid + " WHERE (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR ?<=date2)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PacketChannel packetContent = new PacketChannel();
                this.loadFromRS(packetContent, rs);
                result.add(packetContent);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    private void loadFromRS(PacketChannel result, ResultSet rs) throws SQLException {
        result.setId(rs.getInt("id"));
        result.setPacketId(rs.getInt("pid"));
        result.setChannelId(rs.getInt("chid"));
        result.setDateFrom((Date)rs.getDate("date1"));
        result.setDateTo((Date)rs.getDate("date2"));
        result.setComment(rs.getString("comment"));
    }
}

