/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.driver.starrus;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.starrus.DeviceStatus;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.starrus.PrinterStarrusException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.PrinterConnectException;

public class StarrusPrinter {
    private static Logger logger = LogManager.getLogger();
    private String address;
    private int port;
    private long password;
    private List<Request> mybatchenabled = null;

    public StarrusPrinter(String address, int port, long password) {
        this.address = address;
        this.port = port;
        this.password = password;
    }

    private String generateRequestId() {
        return UUID.randomUUID().toString();
    }

    private static String command2path(String command) {
        return String.format("/fr/api/v2/%s", command);
    }

    private static String path2command(String path) {
        String[] p = path.split("/");
        return p[p.length - 1];
    }

    private String command2url(String command) {
        return String.format("http://%s:%s/fr/api/v2/%s", this.address, this.port, command);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Response> request(List<Request> commands) throws PrinterConnectException, PrinterStarrusException {
        if (this.mybatchenabled != null) {
            this.mybatchenabled.addAll(commands);
            return null;
        }
        JSONArray requestslist = new JSONArray();
        for (Request command : commands) {
            JSONObject request = new JSONObject();
            request.put("Path", (Object)StarrusPrinter.command2path(command.command));
            if (command.ifs != null) {
                for (Map.Entry<String, Object> entry : command.ifs.entrySet()) {
                    request.put(entry.getKey(), entry.getValue());
                }
            }
            JSONObject requestparams = new JSONObject();
            for (Map.Entry<String, Object> param : command.params.entrySet()) {
                requestparams.put(param.getKey(), param.getValue());
            }
            request.put("Request", (Object)requestparams);
            requestslist.put((Object)request);
        }
        JSONObject batchrequest = new JSONObject();
        batchrequest.put("RequestId", (Object)this.generateRequestId());
        batchrequest.put("Requests", (Object)requestslist);
        String reply = StarrusPrinter.doPost(this.command2url("Batch"), batchrequest.toString(0));
        int Error2 = -1;
        JSONArray Responses = null;
        Object var7_11 = null;
        try {
            JSONTokener tokener = new JSONTokener(reply);
            JSONObject fullresponse = (JSONObject)tokener.nextValue();
            Error2 = fullresponse.getInt("Error");
            Responses = fullresponse.getJSONArray("Responses");
            if (fullresponse.has("ErrorMessages")) {
                StringBuilder sb = new StringBuilder();
                for (Object err : fullresponse.getJSONArray("ErrorMessages")) {
                    sb.append("(").append(err).append(")");
                }
                String string = sb.toString();
            }
        }
        catch (JSONException e) {
            throw new PrinterConnectException("strange json-response (" + reply + ")", e);
        }
        catch (Exception e) {
            throw new PrinterConnectException("error parse json-response (" + reply + ")", e);
        }
        if (Error2 != 0) {
            void var7_13;
            throw new PrinterStarrusException(Error2, (String)var7_13);
        }
        HashMap<String, Response> ret = new HashMap<String, Response>();
        try {
            for (Object dictResponse : Responses) {
                JSONObject oDictResponse = (JSONObject)dictResponse;
                String command = StarrusPrinter.path2command(oDictResponse.getString("Path"));
                JSONObject Response2 = oDictResponse.has("Response") ? oDictResponse.getJSONObject("Response") : null;
                ret.put(command, new Response(command, Response2));
            }
        }
        catch (Exception e) {
            throw new PrinterConnectException("error parse json-response, \"Responses\" array (" + reply + ")", e);
        }
        return ret;
    }

    private static String doPost(String url, String body) throws PrinterConnectException {
        HttpURLConnection con = null;
        try {
            StringBuilder result = new StringBuilder();
            long t0 = System.currentTimeMillis();
            URL url2 = new URL(url);
            con = (HttpURLConnection)url2.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            if (logger.isDebugEnabled()) {
                logger.debug("->" + body);
            }
            long t1 = System.currentTimeMillis();
            OutputStream os = con.getOutputStream();
            os.write(body.getBytes(StandardCharsets.UTF_8));
            os.close();
            long t2 = System.currentTimeMillis();
            if (con.getResponseCode() == 200) {
                int ch;
                long t3 = System.currentTimeMillis();
                InputStreamReader rd = new InputStreamReader(con.getInputStream(), "UTF-8");
                while ((ch = rd.read()) != -1) {
                    result.append((char)ch);
                }
                rd.close();
                long t4 = System.currentTimeMillis();
                long t_connect = t1 - t0;
                long t_write = t2 - t1;
                long t_wait = t3 - t2;
                long t_read = t4 - t3;
                if (logger.isDebugEnabled()) {
                    logger.debug("<-" + result.toString() + "\nconnect: " + t_connect + "ms, write: " + t_write + "ms, wait: " + t_wait + "ms, read: " + t_read + "ms");
                }
                String string = result.toString();
                return string;
            }
            try {
                throw new PrinterConnectException("HTTP response code \"" + con.getResponseCode() + " " + con.getResponseMessage() + "\", not \"200 OK\" (" + url + ")");
            }
            catch (IOException e) {
                throw new PrinterConnectException("error printer connect or data transfer (" + url + ")", e);
            }
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public DeviceStatus LongDeviceStatus() throws PrinterConnectException, PrinterStarrusException {
        Map<String, Response> responses = this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("LongDeviceStatus", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                    }
                }));
            }
        });
        Response response = responses.get("LongDeviceStatus");
        JSONObject Status = response.response.getJSONObject("Status");
        DeviceStatus status = new DeviceStatus();
        status.load(Status);
        return status;
    }

    public static LocalDate parseDate(JSONObject date) {
        return LocalDate.of(date.getInt("Year") + 2000, date.getInt("Month"), date.getInt("Day"));
    }

    private static LocalTime parseTime(JSONObject time) {
        return LocalTime.of(time.getInt("Hour"), time.getInt("Minute"), time.getInt("Second"));
    }

    public static LocalDateTime parseDateTime(JSONObject date, JSONObject time) {
        return LocalDateTime.of(StarrusPrinter.parseDate(date), StarrusPrinter.parseTime(time));
    }

    public static LocalDateTime parseDateTime(JSONObject datetime) {
        return StarrusPrinter.parseDateTime(datetime.getJSONObject("Date"), datetime.getJSONObject("Time"));
    }

    public void OpenTurn() throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("OpenTurn", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                    }
                }));
            }
        });
    }

    public void OpenTurnIfNeed() throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("OpenTurn", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("SkipWhenModeNotIn", new int[]{0, 4});
                    }
                }, (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                    }
                }));
            }
        });
    }

    public void _startBatch() {
        if (this.mybatchenabled != null) {
            throw new RuntimeException("diplicate _startBatch");
        }
        this.mybatchenabled = new ArrayList<Request>();
    }

    public Map<String, Response> _doBatch() throws PrinterStarrusException, PrinterConnectException {
        if (this.mybatchenabled == null) {
            throw new RuntimeException("no _startBatch");
        }
        List<Request> copybatchenabled = this.mybatchenabled;
        this.mybatchenabled = null;
        return this.request(copybatchenabled);
    }

    public void PrintString(final String Text2) throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("PrintString", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                        this.put("Text", Text2);
                        this.put("Font", 1);
                    }
                }));
            }
        });
    }

    public void CutPaper(final boolean FullCut) throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("CutPaper", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                        this.put("FullCut", FullCut);
                    }
                }));
            }
        });
    }

    public void CloseTurn() throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("CloseTurn", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                    }
                }));
            }
        });
    }

    public void IntermediateTurnReport() throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("IntermediateTurnReport", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                    }
                }));
            }
        });
    }

    public void PrintLastSavedDocument() throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("PrintLastSavedDocument", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                    }
                }));
            }
        });
    }

    public void IdentDevice(final boolean On) throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("IdentDevice", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                        this.put("On", On);
                    }
                }));
            }
        });
    }

    public String pureCmd(String commandandjson) throws PrinterConnectException {
        String[] s = commandandjson.split(";", 2);
        if (s.length != 2) {
            return "Command;json";
        }
        String command = s[0];
        String body = s[1];
        return StarrusPrinter.doPost(this.command2url(command), body);
    }

    public void CancelDocument() throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("CancelDocument", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                    }
                }));
            }
        });
    }

    public void OpenDocument(final int DocumentType2) throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("OpenDocument", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                        this.put("DocumentType", DocumentType2);
                    }
                }));
            }
        });
    }

    public void AddPhoneOrEmailOfCustomer(final String Value) throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("AddPhoneOrEmailOfCustomer", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                        this.put("Value", Value);
                    }
                }));
            }
        });
    }

    public void AddLineToDocument(final int DocumentType2, final int Qty, final long Price, final int PayAttribute, final int Linettribute, final int TaxId, final String Description) throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("AddLineToDocument", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                        this.put("DocumentType", DocumentType2);
                        this.put("Qty", Qty);
                        this.put("Price", Price);
                        if (PayAttribute != -1) {
                            this.put("PayAttribute", PayAttribute);
                        }
                        if (Linettribute != -1) {
                            this.put("Linettribute", Linettribute);
                        }
                        if (TaxId != -1) {
                            this.put("TaxId", TaxId);
                        }
                        this.put("Description", Description);
                    }
                }));
            }
        });
    }

    public void CloseDocument(final long Cash, final long NonCash2, final long NonCash3, final long NonCash4) throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("CloseDocument", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                        this.put("Cash", Cash);
                        this.put("NonCash", new long[]{NonCash2, NonCash3, NonCash4});
                    }
                }));
            }
        });
    }

    public void AddPostText(final String Value) throws PrinterStarrusException, PrinterConnectException {
        this.request((List<Request>)new ArrayList<Request>(){
            {
                this.add(new Request("AddPostText", (Map<String, Object>)new HashMap<String, Object>(){
                    {
                        this.put("Password", StarrusPrinter.this.password);
                        this.put("Value", Value);
                    }
                }));
            }
        });
    }

    private static class Request {
        String command;
        Map<String, Object> ifs;
        Map<String, Object> params;

        public Request(String command, Map<String, Object> params) {
            this.command = command;
            this.params = params;
        }

        public Request(String command, Map<String, Object> ifs, Map<String, Object> params) {
            this.command = command;
            this.ifs = ifs;
            this.params = params;
        }
    }

    private static class Response {
        String command;
        JSONObject response;

        public Response(String command, JSONObject response) {
            this.command = command;
            this.response = response;
        }
    }
}

