/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.viewer;

import bitel.billing.module.common.AWTViewer;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.InputStream;
import javax.activation.DataSource;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bill.client.viewer.Stylesheet;
import ru.bitel.bgbilling.modules.bill.client.viewer.StylesheetType;
import ru.bitel.common.XMLUtils;

public class FOStylesheet
extends Stylesheet {
    private AWTViewer component = new AWTViewer();

    public FOStylesheet() {
        this.type = StylesheetType.FO;
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    private void renderDocument(Document foDoc) throws BGException {
        this.pageCount = 0;
        this.component.setData(foDoc);
        this.pageCount = this.component.getNumberOfPages();
    }

    private void getRenderDocument(DataSource dataSource) {
        try {
            InputStream inputStream = dataSource.getInputStream();
            if (inputStream != null) {
                Document doc = XMLUtils.parseDocument((InputSource)new InputSource(inputStream));
                if (ClientUtils.checkStatus((Document)doc)) {
                    this.renderDocument(doc);
                }
            } else {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u043d\u0434\u0435\u0440\u0430 (\u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u043c?)");
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    @Override
    public void showDocument(DataSource dataSource) {
        this.getRenderDocument(dataSource);
        this.showPage(1);
    }

    @Override
    public PageFormat getPageFormat(DataSource ds, PrinterJob printJob, int pageIndex) throws IndexOutOfBoundsException {
        this.getRenderDocument(ds);
        return this.component.getPageFormat(pageIndex);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        return this.component.print(graphics, pageFormat, pageIndex);
    }

    @Override
    public int getNumberOfPages() {
        return this.component.getNumberOfPages();
    }

    @Override
    public void scale(double scale) {
        try {
            this.component.setScaleFactor(scale);
        }
        catch (BGException e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043c\u0430\u0441\u0448\u0442\u0430\u0431\u0430 (\u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u043c?)");
            e.printStackTrace();
        }
    }

    @Override
    public void showPage(int pageNum) {
        try {
            this.component.showPage(pageNum - 1);
        }
        catch (BGException e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043a\u0430\u0437\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b " + pageNum + " (\u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430 \u0441 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u043c?)");
            e.printStackTrace();
        }
    }

    @Override
    public void clear() {
        this.component.showClearPage();
    }
}

