/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bill.common.bean.AttributeType;
import ru.bitel.bgbilling.modules.bill.common.service.AttributeService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class AttributePanel
extends BGUPanel {
    private AttributeService service = null;
    private AttributeTableMaodel model = new AttributeTableMaodel(AttributeTableMaodel.class.getName());

    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AttributePanel.this.performAction("edit");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private AttributeService getAttributeService() {
        if (this.service == null) {
            this.service = (AttributeService)((ClientContext)this.getContext()).getPort(AttributeService.class);
        }
        return this.service;
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                AttributePanel.this.model.setData(AttributePanel.this.getAttributeService().attributeTypeList());
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                new AttributeEditor("\u041d\u043e\u0432\u044b\u0439 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442", new AttributeType()).getDialog().setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                AttributeType attributeType = (AttributeType)AttributePanel.this.model.getSelectedRow();
                if (attributeType != null) {
                    new AttributeEditor("\u041d\u043e\u0432\u044b\u0439 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442", attributeType).getDialog().setVisible(true);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                AttributeType attributeType = (AttributeType)AttributePanel.this.model.getSelectedRow();
                if (attributeType != null && BGSwingUtilites.confirmDelete((Object)attributeType)) {
                    AttributePanel.this.getAttributeService().deleteAttributeType(attributeType.getId());
                    AttributePanel.this.performAction("refresh");
                }
            }
        };
    }

    class AttributeTableMaodel
    extends BGTableModel<AttributeType> {
        public AttributeTableMaodel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434", 60, 60, 60, "id", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "name", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430", -1, -1, -1, "check", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }
    }

    class AttributeEditor
    extends BGEditorDialog<AttributeType> {
        private BGTextField nameField;
        private BGTextField titleField;
        private BGTextField regexpField;

        public AttributeEditor(String title, AttributeType data) {
            super(title, (Object)data);
            this.nameField = new BGTextField(30);
            this.titleField = new BGTextField(30);
            this.regexpField = new BGTextField(30);
        }

        public void doDialogPanel() {
            int gridy = 0;
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.nameField, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.titleField, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 (regexp):"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.regexpField, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.nameField.setText(((AttributeType)this.data).getName());
            this.titleField.setText(((AttributeType)this.data).getTitle());
            this.regexpField.setText(((AttributeType)this.data).getCheck());
            this.nameField.requestFocus();
        }

        public boolean doApply() throws Exception {
            if (Utils.isBlankString((String)this.nameField.getText())) {
                ClientUtils.showMessageDialog((Object)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            if (Utils.isBlankString((String)this.titleField.getText())) {
                ClientUtils.showMessageDialog((Object)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
                return false;
            }
            try {
                ((AttributeType)this.data).setName(this.nameField.getText());
                ((AttributeType)this.data).setTitle(this.titleField.getText());
                ((AttributeType)this.data).setCheck(this.regexpField.getText());
                AttributePanel.this.getAttributeService().updateAttributeType((AttributeType)this.data);
                AttributePanel.this.performAction("refresh");
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            return true;
        }
    }
}

