/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.task;

import bitel.billing.server.util.MailMsg;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.modules.bill.server.bean.AbstractManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.EmailMaster;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class BillDocsSenderForAll
extends RunTask {
    private int moduleId = -1;
    private String billCodes;
    private String invoiceCodes;
    private Map<Integer, List<Integer>> billMap;
    private Map<Integer, List<Integer>> invoiceMap;
    private int userId = -1;

    public BillDocsSenderForAll(int moduleId, String billCodes, String invoiceCodes, int userId) {
        this.moduleId = moduleId;
        this.billCodes = billCodes;
        this.invoiceCodes = invoiceCodes;
        this.userId = userId;
    }

    public String getDescription() {
        return "\u041c\u043e\u0434\u0443\u043b\u044c Bill. \u0417\u0430\u0434\u0430\u0447\u0430 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0441 \u043a\u043e\u043c\u043f\u043e\u043d\u043e\u0432\u043a\u043e\u0439.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try (BillManager billManager = new BillManager(con, this.moduleId);
             InvoiceManager invoiceManager = new InvoiceManager(con, this.moduleId);){
            this.billMap = this.sortDocByContract(billManager, this.billCodes);
            this.invoiceMap = this.sortDocByContract(invoiceManager, this.invoiceCodes);
            ArrayList<Integer> sendCids = new ArrayList<Integer>();
            for (int contractId : this.billMap.keySet()) {
                this.sendMessage(con, contractId, this.billMap.get(contractId), this.invoiceMap.get(contractId));
                sendCids.add(contractId);
            }
            for (int contractId : this.invoiceMap.keySet()) {
                if (sendCids.contains(contractId)) continue;
                this.sendMessage(con, contractId, this.billMap.get(contractId), this.invoiceMap.get(contractId));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private void sendMessage(Connection con, int contactId, List<Integer> bills, List<Integer> invoices) {
        try (EmailMaster emailMaster = new EmailMaster(this.setup, con, this.moduleId, this.userId);){
            if (this.log.isDebugEnabled()) {
                this.log.debug("Send message for contractId => " + contactId);
            }
            MimeMultipart multipart = new MimeMultipart();
            emailMaster.addMessage((Multipart)multipart);
            if (bills != null) {
                for (Integer id : bills) {
                    emailMaster.setDocumentId("bill", id);
                    emailMaster.setContractId(contactId);
                    emailMaster.addAttach((Multipart)multipart);
                }
            }
            if (invoices != null) {
                for (Integer id : invoices) {
                    emailMaster.setDocumentId("invoice", id);
                    emailMaster.setContractId(contactId);
                    emailMaster.addAttach((Multipart)multipart);
                }
            }
            new MailMsg((Preferences)this.setup).sendMessage(emailMaster.getEmail(), emailMaster.getSubject(), (Multipart)multipart);
        }
        catch (Exception e) {
            this.log.error("send for contract #" + contactId + " error: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Map<Integer, List<Integer>> sortDocByContract(AbstractManager billManager, String codes) {
        HashMap<Integer, List<Integer>> res = new HashMap<Integer, List<Integer>>();
        if (codes == null) {
            return res;
        }
        Iterator iterator = Utils.toIntegerList((String)codes).iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            BillDoc docInfo = billManager.getBillDocInfo(id);
            int cid = docInfo.getContractId();
            ArrayList<Integer> list = (ArrayList<Integer>)res.get(cid);
            if (list == null) {
                list = new ArrayList<Integer>();
                res.put(cid, list);
            }
            list.add(id);
        }
        return res;
    }
}

