<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<div class="pageTitle">${assistantAction.title}</div>
<c:if test="${not empty message}"><div class="tile actionMessage">${message}</div></c:if>

<form>
<c:if test="${not empty fields}">
<div class="tile actionFields">
	<c:forEach var="item" items="${fields}">
		<div class="actionField actionType${item.type}" style="position: relative;">
			<c:choose>
				<c:when test="${item.type == 'Hidden'}"><input type="hidden" name="${item.key}" value="${item.value}" id="${item.key}"></c:when>
				<c:when test="${item.type == 'Label'}"><div class="actionFieldTitle">${item.title} (${item.type})</div>
				</c:when>
				<c:otherwise>
					<div class="actionFieldRow" style="">
					<label class="actionFieldTitle" for="${item.key}">${item.title} (${item.type})</label>
					<div class="actionFieldValue">
					<c:choose>
						<c:when test="${item.type == 'String'}"><input type="text" name="${item.key}" value="${item.value}" id="${item.key}"></c:when>
						<c:when test="${item.type == 'Boolean'}"><input type="checkbox" name="${item.key}" value="${item.value}" id="${item.key}"></c:when>
						<c:when test="${item.type == 'Integer'}"><input type="number" pattern="^\d+$" name="${item.key}" value="${item.value}" id="${item.key}"></c:when>
						<c:when test="${item.type == 'Decimal'}"><input type="number" pattern="\d+.?\d*" name="${item.key}" value="${item.value}" id="${item.key}"></c:when>
						<c:when test="${item.type == 'Date'}"><input type="date" name="${item.key}" value="${item.value}" id="${item.key}"></c:when>
						<c:when test="${item.type == 'Period'}"><input type="date" name="${item.key}From" value="${item.valueFrom}" id="${item.key}From"> - <input type="date" name="${item.key}To" value="${item.valueTo}" id="${item.key}To"></c:when>
						<c:when test="${item.type == 'Contract'}">
							<div style="position: relative;">
								<button type="button" name="${item.key}" id="${item.key}" class="actionFieldContractButton" onclick="document.getElementById('${item.key}ContractListPopup').style.display='block'; return false;">${item.value} Выберите договор...</button> 
								<button type="button" name="${item.key}Clear" id="${item.key}Id" class="actionFieldContractButtonClear">X</button>
								<div id="${item.key}ContractListPopup" style="display: none; position: absolute; top: 1.6rem; padding: 5px; border: 1px solid; border-radius: 5px; z-index: 100; background-color: white; width: 100%;" ><c:forEach var="contractItem" items="${contractIds}"><div>${contractItem}</div></c:forEach></div>
							</div>
						</c:when>
						<c:when test="${item.type == 'Combox'}"><select name="${item.key}" id="${item.key}"><c:forEach var="listItem" items="${item.values}"><option value="${listItem.key}">${listItem.value}</option></c:forEach></select></c:when>
						<c:when test="${item.type == 'Textarea'}"><textarea rows="5" cols="30" name="${item.key}" id="${item.key}">${item.value}</textarea> </c:when>
						<c:when test="${item.type == 'Link'}"><a href="${item.value}" id="${item.key}">${item.value}</a></c:when>
						<c:when test="${item.type == 'List'}"><select name="${item.key}" id="${item.key}" size="8"></select></c:when>
					</c:choose>
					<c:if test="${not empty item.comment}"><div class="actionFieldComment">${item.comment}</div></c:if>
					</div>
					</div>
				</c:otherwise>
			</c:choose>
		</div>			
	</c:forEach>			
</div>
</c:if>
<div class="actionButtons">
	<c:forEach var="item" items="${buttons}">
	<c:set var="onclick">
	<c:choose>
		<c:when test="${item.code == 'cancel'}">showMenu(); return false;</c:when>
		<c:otherwise>doButton( '${item['code']}', '${assistantAction.actionId}', this.form ); return false;</c:otherwise>
	</c:choose>
	</c:set>
	<div><button value="${item['code']}" onclick="${onclick}">${item['title']}</button></div>
	</c:forEach>
</div>
</form>
