/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.client.admin;

import bitel.billing.common.VersionInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.ws.Holder;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.dynamic.common.DynamicCodeService;
import ru.bitel.bgbilling.plugins.assistant.client.admin.AssistantMastersTab;
import ru.bitel.bgbilling.plugins.assistant.client.admin.ExportImportDialog;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantActionItem;
import ru.bitel.bgbilling.plugins.assistant.common.service.AssistantService;
import ru.bitel.common.Utils;
import ru.bitel.common.ZipUtils;

public class ExportAssistantMaster {
    private ClientContext context;
    protected List<AssistantActionItem> actionsList;
    private AssistantMastersTab parent;
    private ExportDialog dialog;

    public ExportAssistantMaster(ClientContext ctx, List<AssistantActionItem> actionsList, AssistantMastersTab parent) throws IOException, BGException {
        this.context = ctx;
        this.actionsList = actionsList;
        this.parent = parent;
        this.dialog = new ExportDialog(parent);
        this.showDialog();
    }

    private void showDialog() throws IOException, BGException {
        BGFileChooser fileChooser = new BGFileChooser((Component)((Object)this.parent));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setApproveButtonText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        this.dialog.setDataList();
        if (this.dialog.showDialog().equals("ok")) {
            int responce = fileChooser.showOpenDialog((Component)((Object)this.parent));
            if (responce == 0) {
                String exportPath = fileChooser.getSelectedFile().getAbsolutePath();
                List<AssistantActionItem> selectedItems = this.dialog.actionList.getSelectedValuesList();
                if (!Utils.notEmptyCollection(selectedItems)) {
                    return;
                }
                String ZIP_FILE_TITLE = exportPath + "/" + ((AssistantActionItem)selectedItems.get(0)).getTitle() + ".action";
                ZipUtils.doZip(this.getFilesMap(selectedItems), (String)ZIP_FILE_TITLE, (String)"");
            }
        } else {
            this.dialog.dispose();
        }
    }

    private Map<String, byte[]> getFilesMap(List<AssistantActionItem> selectedActionsToExport) throws BGException, IOException {
        HashMap<String, byte[]> filesMap = new HashMap<String, byte[]>();
        for (AssistantActionItem actionItem : selectedActionsToExport) {
            AssistantAction assistantAction = this.getAssistantAction(actionItem.getActionId());
            File masterFile = this.getAssistantActionFile(assistantAction);
            File actionSourceFile = this.getActionClassSourceFile(assistantAction);
            File descriptionFile = this.getDescriptionFile(assistantAction);
            filesMap.put(masterFile.getPath(), Files.readAllBytes(masterFile.toPath()));
            filesMap.put(actionSourceFile.getPath(), Files.readAllBytes(actionSourceFile.toPath()));
            filesMap.put(descriptionFile.getPath(), Files.readAllBytes(descriptionFile.toPath()));
        }
        return filesMap;
    }

    private AssistantAction getAssistantAction(String actionId) throws BGException {
        AssistantService assistantService = (AssistantService)this.context.getPort(AssistantService.class);
        AssistantAction action = assistantService.getAssistantActionByActionId(actionId);
        if (action == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0435 \u043c\u0430\u0441\u0442\u0435\u0440\u0430");
        }
        return action;
    }

    private File getAssistantActionFile(AssistantAction action) throws IOException {
        File masterFile = new File(action.getTitle());
        StringWriter stringWriter = new StringWriter();
        new ObjectMapper().writeValue((Writer)stringWriter, (Object)action);
        this.writeTofile(masterFile, stringWriter.toString());
        return masterFile;
    }

    private File getActionClassSourceFile(AssistantAction action) throws BGException, IOException {
        int ch;
        String actionClass = action.getActionClass();
        if (Utils.isBlankString((String)actionClass)) {
            throw new BGMessageException("\u0412 \u041c\u0430\u0441\u0442\u0435\u0440\u0435 \"" + action.getTitle() + "\" \u043d\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430. \u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u043d\u0435 \u0443\u0434\u0430\u043b\u0441\u044f");
        }
        DynamicCodeService codeService = (DynamicCodeService)this.context.getPort(DynamicCodeService.class);
        Holder data = new Holder();
        codeService.getSource(action.getActionClass(), data);
        InputStream inputStream = ((DataHandler)data.value).getInputStream();
        if (inputStream == null) {
            throw new BGMessageException("\u0414\u043b\u044f \u043c\u0430\u0441\u0442\u0435\u0440\u0430 " + action.getTitle() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043a\u043b\u0430\u0441\u0441-\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a. \u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u043d\u0435 \u0443\u0434\u0430\u043b\u0441\u044f");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder source = new StringBuilder();
        while ((ch = br.read()) >= 0) {
            source.append((char)ch);
        }
        br.close();
        File actionClassSource = new File(action.getActionClass() + ".java");
        this.writeTofile(actionClassSource, source.toString());
        return actionClassSource;
    }

    private File getDescriptionFile(AssistantAction action) throws IOException {
        File descriptionFile = new File("description");
        JSONObject descriptionJson = new JSONObject();
        JSONObject config = new JSONObject(action.getConfig());
        descriptionJson.put("comment", config.get("comment"));
        if (this.dialog != null) {
            String description = this.dialog.description.getText();
            String version = this.dialog.version.getText();
            descriptionJson.put("description", (Object)description);
            descriptionJson.put("version", (Object)version);
        }
        this.writeTofile(descriptionFile, descriptionJson.toString());
        return descriptionFile;
    }

    private void writeTofile(File file, String text) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(text);
        fileWriter.flush();
        fileWriter.close();
    }

    class ExportDialog
    extends ExportImportDialog {
        ExportDialog(AssistantMastersTab parent) {
            super(parent, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0441\u0435 \u043c\u0430\u0441\u0442\u0435\u0440\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c", "(\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044f \u043a\u043b\u0430\u0432\u0438\u0448\u0443 CTRL \u043c\u043e\u0436\u043d\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u041c\u0430\u0441\u0442\u0435\u0440\u043e\u0432 \u0434\u043b\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430)");
            this.actionList.setSelectionMode(2);
            VersionInfo versionInfo = VersionInfo.getVersionInfo((String)"client");
            this.version.setText("\u0412\u0435\u0440\u0441\u0438\u044f \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u041c\u0430\u0441\u0442\u0435\u0440\u0430: " + versionInfo.getVersionString());
            this.pack();
            this.moveWindowToCenterScreen();
        }

        private void setDataList() {
            Comparator<AssistantActionItem> comparator = Comparator.comparing(AssistantActionItem::getSort);
            Collections.sort(ExportAssistantMaster.this.actionsList, comparator);
            ExportAssistantMaster.this.actionsList.forEach(i -> this.listModel.addElement(i));
        }
    }
}

