/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.modules.voiceip.server.bean.LoginInfo;
import ru.bitel.common.TimeUtils;

public class LoginInfoManager {
    private Connection con;
    private String tableName;

    public LoginInfoManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "user_login_" + mid;
    }

    public List<LoginInfo> getLoginList(int cid, int objectId) {
        return this.getLoginList(cid, objectId, null);
    }

    public List<LoginInfo> getLoginList(int cid, int objectId, Date date) {
        ArrayList<LoginInfo> userLoginList = new ArrayList<LoginInfo>();
        try {
            String query = "SELECT id, login, date1, date2, type, status, comment FROM " + this.tableName + " WHERE cid=?";
            if (objectId > 0) {
                query = query + " AND object_id=" + objectId;
            }
            if (date != null) {
                query = query + " AND (date1<=? OR date1 IS NULL) AND (date2>=? OR date2 IS NULL)";
            }
            query = query + " ORDER BY login, date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            if (date != null) {
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
                ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)date));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                userLoginList.add(this.getContractInfoFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userLoginList;
    }

    private LoginInfo getContractInfoFromRs(ResultSet rs) throws SQLException {
        LoginInfo contractInfo = new LoginInfo();
        contractInfo.setId(rs.getInt(1));
        contractInfo.setLogin(rs.getString(2));
        java.sql.Date dateFrom = rs.getDate(3);
        if (dateFrom != null) {
            contractInfo.setDateFrom(new Date(dateFrom.getTime()));
        } else {
            contractInfo.setDateFrom(null);
        }
        java.sql.Date dateTo = rs.getDate(4);
        if (dateTo != null) {
            contractInfo.setDateTo(new Date(dateTo.getTime()));
        } else {
            contractInfo.setDateTo(null);
        }
        contractInfo.setType(rs.getInt(5));
        contractInfo.setStatus(rs.getInt(6));
        contractInfo.setComment(rs.getString(7));
        return contractInfo;
    }
}

