/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.tariff;

import java.math.BigDecimal;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapItem;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.server.runtime.geocode.GeoCodeCache;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffRequest;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class CostMapTariffTreeNode
extends TariffTreeNode<VoiceTariffRequest, VoiceTariffContext, TreeContext, VoiceTariffWorkerContext> {
    private static final Logger logger = LogManager.getLogger();
    private int costMapId = -1;

    public CostMapTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.costMapId = parameterMap.getInt("costMapId", -1);
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, VoiceTariffRequest req, TariffTreeNodeHolder holder, VoiceTariffContext ctx, TreeContext treeContext, VoiceTariffWorkerContext workerContext) {
        BigDecimal parentCost = req.costMapCost;
        int result = super.execute(treeNodeId, parentTreeNodeId, (AbstractTariffRequest)req, holder, (TariffContext)ctx, treeContext, (ThreadContext)workerContext);
        req.costMapCost = parentCost;
        return result;
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, VoiceTariffRequest req, VoiceTariffContext ctx, TreeContext treeContext, VoiceTariffWorkerContext workerContext) {
        String phone = req.phoneTo;
        Set costMapAcceptedSet = req.getAcceptedSet(CostMapTariffTreeNode.class);
        if (Utils.notBlankString((String)phone) && !costMapAcceptedSet.contains(parentTreeNodeId)) {
            try {
                VoiceCostMapItem item = ctx.getCostMapCache().findCost(this.costMapId, phone);
                if (item != null && item.getItemCost() != null) {
                    req.costMapCost = item.getItemCost();
                    req.costMapItemId = item.getId();
                    req.codeId = item.getCodeId();
                    VoiceGeographicCode code = GeoCodeCache.findCode(phone, workerContext.getModuleId(), req.getOperatorId(), workerContext.getConnection());
                    if (code != null && code.getDestinationId() > 0) {
                        req.setDestId(code.getDestinationId());
                    } else {
                        logger.warn("Destination from " + phone + " not found.");
                    }
                    costMapAcceptedSet.add(parentTreeNodeId);
                    return 1;
                }
                req.addError("CostMap with id=" + this.costMapId + " not found!");
            }
            catch (Exception e) {
                req.addError(e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return 0;
    }
}

