/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.AbtractVoiceAccount;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class VoiceCommonAccountDao {
    public static final String TABLE_COMMON_VOICE_ACCOUNT = "voice_account_base";
    private String tableName;
    Connection con;

    public VoiceCommonAccountDao(Connection con, int moduleId) {
        this.tableName = "voice_account_base_" + moduleId;
        this.con = con;
    }

    protected void fillFromRS(ResultSet rs, AbtractVoiceAccount account, boolean contractLoad) throws SQLException, BGException {
        account.setId(rs.getInt("id"));
        account.setContractId(rs.getInt("contractId"));
        if (contractLoad) {
            account.setContractTitle(rs.getString("contractTitle"));
            account.setContractComment(rs.getString("contractComment"));
        }
        account.setTypeId(rs.getInt("typeId"));
        account.setDateFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateFrom")));
        account.setDateTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateTo")));
        account.setDeviceId(rs.getInt("deviceId"));
        account.setTitle(rs.getString("title"));
    }

    protected void update(AbtractVoiceAccount account) throws BGException, SQLException {
        String fieldPart = " SET contractId=?,  typeId=?, deviceId=?, dateFrom=?, dateTo=?, title =? ";
        String query = account.getId() > 0 ? "UPDATE " + this.tableName + fieldPart + " WHERE id = ?" : "INSERT INTO " + this.tableName + fieldPart;
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, account.getContractId());
            ps.setInt(index++, account.getTypeId());
            ps.setInt(index++, account.getDeviceId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)account.getDateFrom()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)account.getDateTo()));
            ps.setString(index++, account.getTitle());
            if (account.getId() > 0) {
                ps.setInt(index++, account.getId());
            }
            ps.executeUpdate();
            if (account.getId() <= 0) {
                account.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    protected int delete(int id) throws BGException {
        int result = 0;
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id = " + id);
            result = ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    protected void delete(List<Integer> ids) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=?");
            for (int i : ids) {
                ps.setInt(1, i);
                ps.addBatch();
            }
            ps.executeBatch();
            this.con.commit();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

