/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.modules.tv.server.ProductManager;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductRuntimeList;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOffering;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOfferingActivationMode;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;

public class TvUtils {
    private static final Logger logger = LogManager.getLogger();
    private static final Pattern macClearPattern = Pattern.compile("[\\s\\.:\\-]+");

    public static long secondsFrom(Date time) {
        if (time == null) {
            return 0L;
        }
        return time.getTime() / 1000L * 1000L;
    }

    public static long secondsTo(Date time) {
        if (time == null) {
            return 0L;
        }
        return time.getTime() / 1000L * 1000L + 999L;
    }

    public static long dateFrom(Date dateFrom, Calendar utilCalendar) {
        if (dateFrom == null) {
            return 0L;
        }
        utilCalendar.setTime(dateFrom);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
        return utilCalendar.getTimeInMillis();
    }

    public static long dateTo(Date dateTo, Calendar utilCalendar) {
        if (dateTo == null) {
            return 0L;
        }
        utilCalendar.setTime(dateTo);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
        utilCalendar.add(5, 1);
        utilCalendar.add(14, -1);
        return utilCalendar.getTimeInMillis();
    }

    public static Calendar toCalendar(long millis) {
        if (millis == 0L) {
            return null;
        }
        GregorianCalendar result = new GregorianCalendar();
        result.setTimeInMillis(millis);
        return result;
    }

    public static Calendar toCalendarFrom(Date time) {
        if (time == null) {
            return null;
        }
        GregorianCalendar result = new GregorianCalendar();
        result.setTimeInMillis(time.getTime() / 1000L * 1000L);
        return result;
    }

    public static Calendar toCalendarTo(Date time) {
        if (time == null) {
            return null;
        }
        GregorianCalendar result = new GregorianCalendar();
        result.setTimeInMillis(time.getTime() / 1000L * 1000L + 999L);
        return result;
    }

    public static Date toDate(long millis) {
        if (millis == 0L) {
            return null;
        }
        return new Date(millis);
    }

    public static Date moveSecond(Date time, int amount, Calendar utilCalendar) {
        utilCalendar.setTime(time);
        utilCalendar.set(14, 0);
        utilCalendar.add(13, amount);
        return utilCalendar.getTime();
    }

    public static long periodAmountToUnit(int periodMode, int periodAmount, TimeUnit unit) {
        switch (periodMode % 10) {
            case 1: {
                return unit.convert(periodAmount, TimeUnit.MINUTES);
            }
            case 2: {
                return unit.convert(periodAmount, TimeUnit.HOURS);
            }
            case 3: {
                return unit.convert(periodAmount, TimeUnit.DAYS);
            }
            case 4: {
                return unit.convert((long)periodAmount * 7L, TimeUnit.DAYS);
            }
            case 5: {
                return unit.convert((long)periodAmount * 30L, TimeUnit.DAYS);
            }
        }
        return periodAmount;
    }

    public static byte[] parseMacAddress(String macAddress) {
        if (Utils.isBlankString((String)macAddress)) {
            return null;
        }
        macAddress = macClearPattern.matcher(macAddress).replaceAll("");
        return TvUtils.toBytes(macAddress);
    }

    public static String macAddressToString(byte[] macAddress) {
        if (macAddress == null || macAddress.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(macAddress.length * 3);
        int size = macAddress.length;
        for (int i = 0; i < size; ++i) {
            sb.append(Utils.HEX[(macAddress[i] & 0xF0) >> 4]);
            sb.append(Utils.HEX[macAddress[i] & 0xF]);
            sb.append(':');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static byte[] toBytes(String s) {
        byte[] result;
        int i;
        int j;
        if (Utils.isBlankString((String)s)) {
            return null;
        }
        int size = s.length();
        if (size % 2 == 0) {
            j = 0;
            i = 0;
            result = new byte[size / 2];
        } else {
            j = 1;
            i = 1;
            result = new byte[size / 2 + 1];
            int digit2 = Character.digit(s.charAt(0), 16);
            result[0] = (byte)digit2;
        }
        while (i < size) {
            int digit1 = Character.digit(s.charAt(i++), 16);
            int digit2 = Character.digit(s.charAt(i++), 16);
            result[j++] = (byte)(digit1 * 16 + digit2);
        }
        return result;
    }

    public static List<TvServiceCost> createServiceCostList(ProductSpecRuntimeMap productSpecRuntimeMap, List<ProductManager.Entry> entryList) throws BGException {
        ArrayList<TvServiceCost> tvServiceCostList = new ArrayList<TvServiceCost>(entryList.size());
        int size = entryList.size();
        for (int i = 0; i < size; ++i) {
            ProductManager.Entry entry = entryList.get(i);
            ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)productSpecRuntimeMap.get(entry.productSpecId);
            Calendar productTimeFrom = TvUtils.toCalendarFrom(entry.productTimeFrom);
            Calendar productTimeTo = TvUtils.toCalendarTo(entry.productTimeTo);
            TvServiceCost tvServiceCost = new TvServiceCost(-entry.productSpecId, entry.productId, entry.activationModeId, null, productSpecRuntime, entry, productTimeFrom, productTimeTo, 1L);
            if (entry.activationPrice != null) {
                tvServiceCost.activationPrice = entry.activationPrice;
                tvServiceCost.activationPriceExternal = true;
            }
            tvServiceCostList.add(tvServiceCost);
        }
        return tvServiceCostList;
    }

    public static List<TvServiceCost> createServiceCostListForRecalculate(ProductSpecRuntimeMap productSpecRuntimeMap, List<ProductManager.Entry> entryList) throws BGException {
        ArrayList<TvServiceCost> tvServiceCostList = new ArrayList<TvServiceCost>(entryList.size());
        int size = entryList.size();
        for (int i = 0; i < size; ++i) {
            ProductManager.Entry entry = entryList.get(i);
            ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)productSpecRuntimeMap.get(entry.productSpecId);
            Calendar productTimeFrom = TvUtils.toCalendarFrom(entry.productTimeFrom);
            Calendar productTimeTo = TvUtils.toCalendarTo(entry.productTimeTo);
            TvServiceCost tvServiceCost = new TvServiceCost(-entry.productSpecId, entry.productId, entry.activationModeId, entry.activationTime, productSpecRuntime, entry, productTimeFrom, productTimeTo, 1L);
            tvServiceCost.periodTimeFrom = entry.productPeriodTimeFrom;
            tvServiceCost.periodTimeTo = entry.productPeriodTimeTo;
            if (entry.activationPrice != null) {
                tvServiceCost.activationPrice = entry.activationPrice;
                tvServiceCost.activationPriceExternal = true;
            }
            tvServiceCostList.add(tvServiceCost);
        }
        return tvServiceCostList;
    }

    public static List<TvServiceCost> createServiceCostList(ProductSpecRuntimeMap productSpecRuntimeMap, TvAccountRuntime tvAccountRuntime, long millis) throws BGException {
        ArrayList<ProductManager.Entry> entryList = new ArrayList<ProductManager.Entry>();
        ProductRuntimeList productRuntimeList = tvAccountRuntime.getProductRuntimeList();
        for (ProductPeriodRuntimeList.ProductPeriodItem item : tvAccountRuntime.getProductPeriodRuntimeList().items()) {
            if (item.timeFrom > millis && item.timeFrom != 0L || item.timeTo < millis && item.timeTo != 0L) continue;
            ProductRuntimeList.ProductItem productItem = productRuntimeList.itemByProductId(item.productId);
            if (productItem == null) {
                logger.error("ProductItem:" + item.productId + " not found for period:" + item.productPeriodId);
                continue;
            }
            if (productItem.deviceState != 1) continue;
            ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)productSpecRuntimeMap.get(item.productSpecId);
            if (productSpecRuntime == null) {
                logger.error("ProductSpec:" + item.productSpecId + " not found for period:" + item.productPeriodId);
                continue;
            }
            ProductManager.Entry entry = new ProductManager.Entry(tvAccountRuntime.tvAccountId, item.productPeriodId, null, TvUtils.toDate(item.timeFrom), TvUtils.toDate(item.timeTo), 0, productItem.productId, item.productSpecId, productSpecRuntime.getProductSpec(), productItem.activationModeId, null, null, TvUtils.toDate(productItem.timeFrom), TvUtils.toDate(productItem.timeTo), null, productItem.deviceState, null);
            entryList.add(entry);
        }
        return TvUtils.createServiceCostList(productSpecRuntimeMap, entryList);
    }

    public static Map<Pair<Integer, Integer>, Pair<ProductOffering, ProductOfferingActivationMode>> getProductOfferingMap(List<ProductOffering> productOfferingList) {
        HashMap<Pair<Integer, Integer>, Pair<ProductOffering, ProductOfferingActivationMode>> result = new HashMap<Pair<Integer, Integer>, Pair<ProductOffering, ProductOfferingActivationMode>>();
        for (ProductOffering productOffering : productOfferingList) {
            if (productOffering.getActivationModeList() == null) continue;
            for (ProductOfferingActivationMode activationMode : productOffering.getActivationModeList()) {
                result.put((Pair<Integer, Integer>)new Pair((Object)productOffering.getProductSpec().getId(), (Object)activationMode.getProductSpecActivationMode().getId()), (Pair<ProductOffering, ProductOfferingActivationMode>)new Pair((Object)productOffering, (Object)activationMode));
            }
        }
        return result;
    }

    public static void filterServiceCostList(List<TvServiceCost> serviceCostList, Calendar tariffPeriodStart, Calendar tariffPeriodStop, List<TvServiceCost> workingServiceCostList, Set<TvServiceCost> processedSet) {
        assert (tariffPeriodStart != null);
        assert (tariffPeriodStop != null);
        Date tariffPeriodStartTime = tariffPeriodStart.getTime();
        Date tariffPeriodStopTime = tariffPeriodStop.getTime();
        int size = serviceCostList.size();
        for (int i = 0; i < size; ++i) {
            TvServiceCost serviceCost = serviceCostList.get(i);
            Date periodStartTime = serviceCost.productItem.productPeriodActivationTime.after(serviceCost.periodTimeFrom) ? serviceCost.productItem.productPeriodActivationTime : serviceCost.periodTimeFrom;
            if (processedSet.contains((Object)serviceCost) || periodStartTime.before(tariffPeriodStartTime) || !periodStartTime.before(tariffPeriodStopTime)) continue;
            workingServiceCostList.add(serviceCost);
        }
    }

    public static Set<Calendar> getTariffPeriods(Date begin, TariffModuleTreeSet tariffTreeSet) {
        TreeSet<Calendar> tariffPeriods = new TreeSet<Calendar>();
        GregorianCalendar beginCalendar = new GregorianCalendar();
        beginCalendar.setTime(begin);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)beginCalendar);
        tariffPeriods.add(beginCalendar);
        for (TariffModuleTreeSet.Entry tariffEntry : tariffTreeSet.entries()) {
            Calendar timeTo;
            Calendar timeFrom = tariffEntry.getCalendarFrom();
            if (timeFrom != null) {
                tariffPeriods.add(timeFrom);
            }
            if ((timeTo = tariffEntry.getCalendarTo()) == null) continue;
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)timeTo);
            timeTo.add(5, 1);
            tariffPeriods.add(timeTo);
        }
        return tariffPeriods;
    }

    public static URL getUrl(Device<?, ?> tvDevice, ParameterMap config, String paramName, String paramName2, String defaultHost, int defaultPort) throws MalformedURLException {
        InetSocketAddress socketAddress;
        String configUrl = config.get(paramName, config.get(paramName2, null));
        if (Utils.notBlankString((String)configUrl)) {
            return new URL(configUrl);
        }
        if (Utils.maskNull((String)tvDevice.getHost()).trim().startsWith("http")) {
            try {
                URL url = new URL(tvDevice.getHost());
                return url;
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
        }
        String host = null;
        int port = 0;
        List addressList = tvDevice.getHosts();
        if (addressList.size() > 0 && (socketAddress = (InetSocketAddress)addressList.get(0)) != null) {
            InetAddress inetAddress = socketAddress.getAddress();
            if (inetAddress != null) {
                host = inetAddress.getHostName();
            }
            port = socketAddress.getPort();
        }
        if (Utils.isBlankString(host)) {
            host = defaultHost;
        }
        if (port <= 0) {
            port = defaultPort;
        }
        String defaultUrl = port == 443 || port == 8443 ? "https://" + host + ":" + port + "/" : "http://" + host + ":" + port + "/";
        return new URL(defaultUrl);
    }
}

