/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softkey.server.action.web;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Resource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyTransaction;
import ru.bitel.bgbilling.modules.softkey.common.service.SoftkeyService;
import ru.bitel.common.Utils;

public class ActionSoftkey
extends AbstractAction {
    @Resource
    private SoftkeyService ss;

    public ActionSoftkey() {
        super("softkey");
    }

    public void execute() throws BGException {
        try {
            SoftkeyTransaction transaction = this.ss.getTransactionByCid(this.contractId, -1);
            List productList = this.ss.getProductList();
            if (transaction != null) {
                List log = this.ss.getTransactionLog(transaction.getId());
                this.setResultParam("transactionLog", log);
                this.setResultParam("transaction", transaction);
            }
            this.setResultParam("productList", productList);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void activateSubscription() throws BGException, IOException, SQLException {
        int count = this.req.getInt("count", 1);
        int optionId = Utils.parseInt((String)this.req.get("optionId", null));
        if (optionId <= 0) {
            this.execute();
            throw new BGMessageException("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u043d\u0443 \u0438\u0437 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a!");
        }
        SoftkeyTransaction transaction = this.ss.getTransactionByCid(this.contractId, optionId);
        if (transaction != null) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043d\u043e\u0432\u0443\u044e \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443 \u0438\u0437-\u0437\u0430 \u043d\u0430\u043b\u0438\u0447\u0438\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0439/\u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e\u0439 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438!!!");
        }
        this.ss.activate(this.contractId, count, optionId);
        this.execute();
    }

    public void pauseSubscription() throws BGException, IOException {
        int optionId = Utils.parseInt((String)this.req.get("optionId", ""), (int)-1);
        SoftkeyTransaction transaction = this.ss.getTransactionByCid(this.contractId, optionId);
        if (transaction.getStatus() != 1) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u0443\u044e \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443!");
        }
        this.ss.pause(this.contractId, optionId);
        this.execute();
    }

    public void continueSubscription() throws BGException, IOException {
        int optionId = Utils.parseInt((String)this.req.get("optionId", ""), (int)-1);
        SoftkeyTransaction transaction = this.ss.getTransactionByCid(this.contractId, optionId);
        if (transaction.getStatus() != 2) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0432\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u0435\u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u0443\u044e \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443!");
        }
        this.ss.continueSubscription(this.contractId, optionId);
        this.execute();
    }

    public void stopSubscription() throws BGException, IOException {
        int optionId = Utils.parseInt((String)this.req.get("optionId", ""), (int)-1);
        this.ss.stop(this.contractId, optionId);
        this.execute();
    }
}

