/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.bean;

import bsh.Interpreter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.query.JRJdbcQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuterFactory;
import net.sf.jasperreports.engine.util.DefaultFormatFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportTemplate;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGMapCollectionDataSource;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGXmlDataSource;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.localize.Localizer;

public class BGBSQueryExecuterFactory
implements JRQueryExecuterFactory {
    private static final String[] queryParameterClassNames = new String[]{Object.class.getName(), Boolean.class.getName(), Byte.class.getName(), Double.class.getName(), Float.class.getName(), Integer.class.getName(), Long.class.getName(), Short.class.getName(), BigDecimal.class.getName(), String.class.getName(), Date.class.getName(), Timestamp.class.getName(), Time.class.getName()};

    public JRQueryExecuter createQueryExecuter(JRDataset dataSet, Map parameters) throws JRException {
        ModuleSetup moduleSetup;
        JRFillParameter reportParametersMapFP = (JRFillParameter)parameters.get("REPORT_PARAMETERS_MAP");
        Map reportParametersMap = (Map)reportParametersMapFP.getValue();
        Object _mid = reportParametersMap.get("mid");
        int mid = Utils.parseInt((String)(_mid == null ? null : _mid.toString()), (int)0);
        JRQuery query = dataSet.getQuery();
        String language = query != null ? query.getLanguage() : null;
        Setup setup = Setup.getSetup();
        ModuleSetup moduleSetup2 = moduleSetup = setup != null ? setup.getModuleSetup(Integer.valueOf(mid)) : null;
        if (moduleSetup == null) {
            moduleSetup = setup;
        }
        if (language != null) {
            if ("bgbs".equalsIgnoreCase(language)) {
                return new BGBSQueryExecuter(setup, (Preferences)moduleSetup, mid, dataSet, query, reportParametersMap);
            }
            if ("javascript".equalsIgnoreCase(language)) {
                return new JSQueryExecuter(setup, (Preferences)moduleSetup, mid, dataSet, query, reportParametersMap);
            }
            if ("sql".equalsIgnoreCase(language)) {
                return new SQLQueryExecuter(setup, (Preferences)moduleSetup, dataSet, parameters);
            }
            if ("xpath".equalsIgnoreCase(language)) {
                return new XPathQueryExecuter(setup, (Preferences)moduleSetup, mid, dataSet, query, reportParametersMap, null);
            }
        }
        return new JRQueryExecuter(){

            public boolean cancelQuery() throws JRException {
                return true;
            }

            public void close() {
            }

            public JRDataSource createDatasource() throws JRException {
                return new BGMapCollectionDataSource(null);
            }
        };
    }

    public Object[] getBuiltinParameters() {
        return new Object[0];
    }

    public boolean supportsQueryParameterType(String className) {
        return Arrays.binarySearch(queryParameterClassNames, className) >= 0;
    }

    static {
        Arrays.sort(queryParameterClassNames);
    }

    private class BGBSQueryExecuter
    implements JRQueryExecuter {
        protected final Setup setup;
        protected final Preferences moduleSetup;
        protected final int mid;
        protected final JRDataset dataset;
        protected final JRQuery query;
        protected final Map<String, Object> reportParametersMap;
        protected Connection con;

        public BGBSQueryExecuter(Setup setup, Preferences moduleSetup, int mid, JRDataset dataset, JRQuery query, Map<String, Object> reportParametersMap) {
            this.setup = setup;
            this.moduleSetup = moduleSetup;
            this.mid = mid;
            this.dataset = dataset;
            this.query = query;
            this.reportParametersMap = reportParametersMap;
        }

        public boolean cancelQuery() throws JRException {
            return true;
        }

        public void close() {
            if (this.con != null) {
                ServerUtils.closeConnection((Connection)this.con);
            }
        }

        public JRDataSource createDatasource() throws JRException {
            BGReportTemplate.ReportResult result = new BGReportTemplate.ReportResult(this.mid);
            BGReportFilter filter = new BGReportFilter(new HashMap<String, String>(), this.moduleSetup, this.reportParametersMap, this.dataset, 0);
            result.params = new HashMap<String, Object>();
            this.process(this.dataset, result, filter);
            if (result.params == null) {
                result.params = new HashMap<String, Object>();
            }
            if (result.dataSource == null) {
                result.dataSource = new BGMapCollectionDataSource(null);
            }
            this.reportParametersMap.putAll(result.params);
            return result.dataSource;
        }

        protected void process(JRDataset dataset, BGReportTemplate.ReportResult result, BGReportFilter filter) {
            try {
                this.con = this.setup != null ? this.setup.getDBConnectionFromPool() : (Connection)this.reportParametersMap.get("REPORT_CONNECTION");
                Interpreter i = new Interpreter();
                i.getNameSpace().importCommands("/ru/bitel/bgbilling/kernel/script/server/bsh/commands");
                i.eval(this.query.getText());
                BGReportTemplate.ReportFiller filler = (BGReportTemplate.ReportFiller)i.getInterface(BGReportTemplate.ReportFiller.class);
                filler.fillReport(this.con, filter, result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class JSQueryExecuter
    extends BGBSQueryExecuter {
        public JSQueryExecuter(Setup setup, Preferences moduleSetup, int mid, JRDataset dataset, JRQuery query, Map<String, Object> reportParametersMap) {
            super(setup, moduleSetup, mid, dataset, query, reportParametersMap);
        }

        @Override
        protected void process(JRDataset dataset, BGReportTemplate.ReportResult result, BGReportFilter filter) {
            try {
                ScriptEngine e = new ScriptEngineManager().getEngineByName("js");
                e.eval(this.query.getText());
                BGReportTemplate.ReportFiller filler = ((Invocable)((Object)e)).getInterface(BGReportTemplate.ReportFiller.class);
                filler.fillReport(this.con, filter, result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class SQLQueryExecuter
    extends JRJdbcQueryExecuter {
        public SQLQueryExecuter(Setup setup, Preferences moduleSetup, JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) {
            super((JasperReportsContext)DefaultJasperReportsContext.getInstance(), dataset, parameters);
        }

        public void close() {
            Connection con = (Connection)this.getParameterValue("REPORT_CONNECTION");
            if (con != null) {
                ServerUtils.closeConnection((Connection)con);
            }
        }
    }

    private class XPathQueryExecuter
    extends BGBSQueryExecuter {
        private Document doc;

        public XPathQueryExecuter(Setup setup, Preferences moduleSetup, int mid, JRDataset dataset, JRQuery query, Map<String, Object> reportParametersMap, Document doc) {
            super(setup, moduleSetup, mid, dataset, query, reportParametersMap);
            this.doc = doc;
        }

        @Override
        protected void process(JRDataset dataset, BGReportTemplate.ReportResult result, BGReportFilter filter) {
            try {
                if (this.doc == null) {
                    Object _doc = filter.getReportParametersMap().get("doc");
                    if (_doc instanceof Document) {
                        this.doc = (Document)_doc;
                    } else {
                        _doc = filter.getReportParametersMap().get("document");
                        if (_doc instanceof Document) {
                            this.doc = (Document)_doc;
                        }
                    }
                }
                new BGXmlDataSource(this.doc, "");
                if (this.doc != null) {
                    BGXmlDataSource ds = new BGXmlDataSource((Node)this.doc, this.query.getText(), dataset.getFields());
                    result.setDataSource((JRDataSource)ds);
                    result.params.put("_document", this.doc);
                    result.params.put("_xpath", ds);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class FormatFactory
    extends DefaultFormatFactory {
        public NumberFormat createNumberFormat(String pattern, Locale locale) {
            if (pattern != null && pattern.length() > 0) {
                return new DecimalFormat(pattern, Localizer.getDecimalFormatSymbols());
            }
            return null;
        }
    }
}

