/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payonline.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.payonline.common.bean.RebillTransaction;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Period;

public class RebillTransactionManager
extends AbstractDao<RebillTransaction> {
    public RebillTransactionManager(Connection con, int mid) {
        super(con, mid, "payonline_rebill_transaction");
    }

    protected void updateImpl(RebillTransaction b) throws BGException, SQLException {
        StringBuilder sql = new StringBuilder();
        int index = 1;
        if (b.getId() < 0) {
            sql.append(" INSERT INTO ");
            sql.append(this.tableName);
            sql.append(" ( transaction_id, cid, result, code, status, error_code, date ) VALUES (?,?,?,?,?,?,?) ");
            PreparedStatement ps = this.con.prepareStatement(sql.toString(), 1);
            ps.setLong(index++, b.getTransactionId());
            ps.setInt(index++, b.getContractId());
            ps.setString(index++, b.getResult());
            ps.setInt(index++, b.getCode());
            ps.setString(index++, b.getStatus());
            ps.setInt(index++, b.getErrorCode());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)b.getDate()));
            ps.executeUpdate();
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            ps.close();
        }
    }

    public List<RebillTransaction> getList(Period period, String filter, Object ... params) throws BGException {
        ArrayList<RebillTransaction> list = new ArrayList<RebillTransaction>();
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT c.title, rte.* FROM ");
            sql.append(this.tableName);
            sql.append(" AS rte LEFT JOIN contract AS c ON rte.cid=c.id ");
            sql.append(" WHERE 1 = 1 ");
            if (period != null && period.getDateFrom() != null) {
                sql.append(" AND (? IS NULL OR rte.date>=?) AND (? IS NULL OR rte.date<=?)");
            }
            if (Utils.notBlankString((String)filter)) {
                sql.append(" AND ");
                sql.append(filter);
            }
            sql.append(" ORDER BY rte.date");
            PreparedStatement ps = this.con.prepareStatement(sql.toString());
            int index = 1;
            if (period != null && period.getDateFrom() != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            }
            for (int i = 0; i < params.length; ++i) {
                RebillTransactionManager.setStatementParam((PreparedStatement)ps, (int)index++, (Object)params[i]);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RebillTransaction transactionError = this.getFromRS(rs);
                transactionError.setContractTitle(rs.getString("c.title"));
                list.add(transactionError);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    protected RebillTransaction getFromRS(ResultSet rs) throws SQLException, BGException {
        RebillTransaction transactionError = new RebillTransaction();
        transactionError.setCode(rs.getInt("code"));
        transactionError.setContractId(rs.getInt("cid"));
        transactionError.setDate(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("date")));
        transactionError.setErrorCode(rs.getInt("error_code"));
        transactionError.setId(rs.getInt("id"));
        transactionError.setResult(rs.getString("result"));
        transactionError.setStatus(rs.getString("status"));
        transactionError.setTransactionId(rs.getLong("transaction_id"));
        return transactionError;
    }
}

