/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.netpay.server.servlet;

import java.io.IOException;
import java.sql.Connection;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.netpay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.netpay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.netpay.server.bean.NetpayUtils;
import ru.bitel.bgbilling.modules.netpay.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.SerialUtils;
import ru.bitel.common.Utils;

@WebServlet(name="NetpayExecutor", urlPatterns={"/netpay/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(ModuleExecutor.class);
    private final Logger log = LogManager.getLogger();

    public void init() throws ServletException {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Connection con = null;
        TransactionManager transactionManager = null;
        try {
            int moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
            con = Setup.getSetup().getDBConnectionFromPool();
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            String data = request.getParameter("data");
            String expire = request.getParameter("expire");
            String apiKey = moduleSetup.get("netpay.api.key", "js4cucpn4kkc6jl1p95np054g2");
            if (this.log.isDebugEnabled()) {
                this.log.debug("data = " + data);
                this.log.debug("expire = " + expire);
                this.log.debug("apiKey = " + apiKey);
            }
            Map<String, String> dataMap = this.getDataMap(data, expire, apiKey);
            transactionManager = new TransactionManager(con, moduleId);
            Transaction transaction = (Transaction)transactionManager.get(Utils.parseInt((String)dataMap.get("orderID")));
            Date now = new Date();
            Payment payment = null;
            payment = new Payment();
            payment.setContractId(transaction.getContractId());
            payment.setTypeId(moduleSetup.getInt("netpay.payment.type.id", -1));
            payment.setDate(now);
            payment.setSum(transaction.getSum());
            payment.setComment(moduleSetup.get("netpay.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 Net Pay [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())));
            payment.setUserId(0);
            PaymentDao paymentDao = new PaymentDao(con);
            paymentDao.update((Object)payment);
            paymentDao.close();
            if (payment != null) {
                transaction.setPaymentId(payment.getId());
                BalanceUtils bu = new BalanceUtils(con);
                bu.updateBalance(payment.getDate(), transaction.getContractId());
                bu.close();
                EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
            }
            transaction.setStatus(TransactionStatus.OK.getCode());
            transaction.setTransactionDate(now);
            transactionManager.update(transaction);
            this.sendResponse(200, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d", response);
        }
        catch (BGException e) {
            this.log.error((Object)e);
            this.sendResponse(500, e.getLocalizedMessage(), response);
        }
        finally {
            if (transactionManager != null) {
                try {
                    transactionManager.close();
                }
                catch (BGException e) {
                    e.printStackTrace();
                }
            }
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private Map<String, String> getDataMap(String data, String expireDate, String apiKey) {
        String cryptoKey = NetpayUtils.getCryptoKey(apiKey, expireDate);
        return NetpayUtils.decrypt(data, cryptoKey);
    }

    private void sendResponse(int statusCode, String message, HttpServletResponse response) {
        if (statusCode != 200) {
            this.log.error(message);
        }
        try {
            response.setStatus(statusCode);
            response.setContentType("text/plain;charset=UTF-8");
            response.getWriter().print((statusCode == 200 ? "SUCCESS" : "FAIL") + "\n" + message);
            response.flushBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

