/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.Contract;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class SberbankTransactionManager
extends MPSTransactionManager {
    private static final Logger logger = LogManager.getLogger();
    private static final int SUCCESS = 0;
    private static final int UNKNOWN_REQUEST_TYPE = 1;
    private static final int CONTRACT_NOT_FOUND = 2;
    private static final int INCORRECT_PAYMENT_SUMM = 3;
    private static final int SUCCESS_PAYMENT_NOT_FOUND = 6;
    private static final int PAYMENT_ALREADY_CANCELED = 7;
    private static final int OTHER_ERROR = 9;
    private static final String TIME_FORMAT = "yyyy-MM-dd'T'hh:mm:ss";
    private static final int ACTION_REGISTER = 20;

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            mpsResponse.setAction(mpsRequest.getAction());
            switch (mpsRequest.getAction()) {
                case 1: {
                    logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0443\u043c\u043c\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
                    if (mpsRequest.getSum().compareTo(system.minSumm) >= 0 && mpsRequest.getSum().compareTo(system.maxSumm) <= 0) {
                        logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                        Contract contract = this.actionCheck(mpsRequest);
                        logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043e\u043a. \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0430\u0439\u0434\u0435\u043d, \u0441\u0443\u043c\u043c\u0430 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430.");
                        mpsResponse.setResult(0);
                        mpsResponse.setMessage("\u0421\u0443\u043c\u043c\u0430 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430, \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0430\u0439\u0434\u0435\u043d, \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u043f\u0440\u0438\u0435\u043c \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
                        mpsResponse.getParameters().put("add", this.getComment(system, conf, con, contract));
                        break;
                    }
                    throw new MPSException(8, "\u0412\u0432\u0435\u0434\u0435\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0441\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 " + system.minSumm + " " + Setup.getSetup().get("client.gui.currency.title.medium", "\u0440\u0443\u0431.;") + " \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 - " + system.maxSumm + " " + Setup.getSetup().get("client.gui.currency.title.medium", "\u0440\u0443\u0431."));
                }
                case 2: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0438 \u0435\u0433\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435.");
                        }
                        Contract contract = this.actionCheck(mpsRequest);
                        transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getNumber(), mpsRequest.getType(), system.title);
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043e\u043a. \u041a\u043e\u0434 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + transaction.getId());
                        }
                        mpsResponse.setResult(0);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0447\u0438\u0441\u043b\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contract.getTitle() + "(contractId=" + contract.getId() + ")");
                        mpsResponse.getParameters().put("date", TimeUtils.format((Date)transaction.getLocalTime(), (String)TIME_FORMAT));
                        mpsResponse.getParameters().put("authcode", transaction.getId());
                        break;
                    }
                    Contract contract = this.actionCheck(mpsRequest);
                    mpsResponse.setResult(0);
                    mpsResponse.setMessage("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0443\u0436\u0435 \u0431\u044b\u043b \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contract.getTitle() + "(contractId=" + contract.getId() + ")");
                    mpsResponse.getParameters().put("date", TimeUtils.format((Date)transaction.getLocalTime(), (String)TIME_FORMAT));
                    mpsResponse.getParameters().put("authcode", transaction.getId());
                    break;
                }
                case 3: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction == null) {
                        throw new MPSException(5, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0442\u0430\u043a\u0438\u043c \u043a\u043e\u0434\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 (id=" + transaction.getId() + ")");
                    }
                    mpsResponse.setResult(transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode()) ? 0 : 7);
                    mpsResponse.setMessage(transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode()) ? "\u041f\u043b\u0430\u0442\u0435\u0436 \u043e\u043f\u043b\u0430\u0447\u0435\u043d" : "\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: \u0443\u0436\u0435 \u0431\u044b\u043b \u043e\u0442\u043c\u0435\u043d\u0435\u043d ");
                    mpsResponse.getParameters().put("authcode", transaction.getId());
                    mpsResponse.getParameters().put("date", TimeUtils.format((Date)transaction.getLocalTime(), (String)TIME_FORMAT));
                    break;
                }
                case 4: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction == null) {
                        throw new MPSException(5, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0442\u0430\u043a\u0438\u043c \u043a\u043e\u0434\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438 \u0435\u0433\u043e \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c");
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430.");
                    }
                    mpsResponse.getParameters().put("date", TimeUtils.format((Date)transaction.getLocalTime(), (String)TIME_FORMAT));
                    mpsResponse.getParameters().put("authcode", transaction.getId());
                    if (!transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        throw new MPSException(7, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u043a\u043e\u0434\u043e\u043c \u0443\u0436\u0435 \u0431\u044b\u043b \u043e\u0442\u043c\u0435\u043d\u0435\u043d \u0440\u0430\u043d\u0435\u0435!");
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043e\u0442\u043c\u0435\u043d\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430.");
                    }
                    this.cancelTransaction(con, moduleId, mpsId, system, transaction);
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043e\u043a.");
                    }
                    mpsResponse.setResult(0);
                    mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d.");
                    break;
                }
                case 20: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0441\u0432\u0435\u0440\u043a\u0438 \u0440\u0435\u0435\u0441\u0442\u0440\u043e\u0432 - \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0435\u0441\u0442\u0440\u0430");
                    }
                    String register = (String)mpsRequest.parameters.get("register");
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u0420\u0435\u0435\u0441\u0442\u0440 - " + register);
                    }
                    for (String line : register.split("\\r\\n")) {
                        String[] items = line.split("\\t");
                        if (items.length != 5) continue;
                        Contract contract = this.findContract(con, moduleId, system, items[0], -1);
                        Date dateTime = TimeUtils.parseDate((String)items[2], (String)TIME_FORMAT);
                        BigDecimal sum = Utils.parseBigDecimal((String)items[3], (BigDecimal)BigDecimal.ZERO);
                        Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, this.parseBigInteger(items[4]), dateTime);
                        if (transaction == null) {
                            this.addTransaction(con, moduleId, mpsId, system, contract.getId(), dateTime, sum, items[4], items[0], 0, system.title);
                            continue;
                        }
                        if (transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) continue;
                        this.cancelTransaction(con, moduleId, mpsId, system, transaction);
                    }
                    break;
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            logger.error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage(), (Throwable)e);
            this.processError(new MPSException(-1), mpsResponse);
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        if (logger.isDebugEnabled()) {
            logger.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
        MPSRequest mpsRequest = new MPSRequest(con, moduleId, mpsId, request, system);
        String[] params = (String[])request.getAttribute("ru.bitel.bgbilling.modules.mps.server.bean.MPSTransactionManager.PATH_INFO");
        String actionString = request.getParameter("action");
        if ("check".equals(actionString)) {
            mpsRequest.setAction(1);
        } else if ("payment".equals(actionString)) {
            mpsRequest.setAction(2);
        } else if ("status".equals(actionString)) {
            mpsRequest.setAction(3);
        } else if ("cancel".equals(actionString)) {
            mpsRequest.setAction(4);
        } else if (params[params.length - 1].equals("register")) {
            mpsRequest.setAction(20);
            StringBuilder register = new StringBuilder();
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
                if (br.ready()) {
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        register.append(line);
                    }
                }
                br.close();
            }
            catch (IOException e) {
                throw new MPSException(9, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0440\u0435\u0435\u0441\u0442\u0440\u0430!");
            }
            mpsRequest.parameters.put("register", register.toString());
        } else {
            throw new MPSException(1, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 action");
        }
        mpsRequest.setNumber(request.getParameter("number"));
        mpsRequest.setType(0);
        mpsRequest.setSum(Utils.parseBigDecimal((String)request.getParameter("amount"), (BigDecimal)BigDecimal.ZERO));
        mpsRequest.setTransId(request.getParameter("receipt"));
        mpsRequest.setTime(TimeUtils.parseDate((String)request.getParameter("date"), (String)TIME_FORMAT));
        logger.debug("\u041f\u0440\u0438\u0448\u0435\u0434\u0448\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b - action=" + actionString + "; number=" + mpsRequest.getNumber() + "; summ=" + mpsRequest.getSum() + "; transId=" + mpsRequest.getTransId() + "; time=" + TimeUtils.format((Date)mpsRequest.getTime(), (String)"dd.MM.yyyy HH:mm:ss"));
        return mpsRequest;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 3: {
                response.setResult(2);
                break;
            }
            case 4: {
                response.setResult(9);
                break;
            }
            case 5: {
                response.setResult(6);
                break;
            }
            case 8: {
                response.setResult(3);
                break;
            }
            default: {
                response.setResult(ex.error);
            }
        }
        response.setMessage(ex.message);
        logger.error("Error code = " + ex.error + "; error message = " + ex.message);
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        Document doc = this.documentBuilder.newDocument();
        Element rootNode = doc.createElement("response");
        doc.appendChild(rootNode);
        Element element = doc.createElement("code");
        element.setTextContent(String.valueOf(response.getResult()));
        rootNode.appendChild(element);
        element = doc.createElement("message");
        element.setTextContent(response.getMessage());
        rootNode.appendChild(element);
        switch (response.getAction()) {
            case 1: {
                if (!response.getParameters().containsKey("add")) break;
                element = doc.createElement("add");
                element.setTextContent(response.getParameters().get("add").toString());
                rootNode.appendChild(element);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if ((response.getResult() == 0 || response.getResult() == 7) && response.getParameters().containsKey("authcode")) {
                    element = doc.createElement("authcode");
                    element.setTextContent(response.getParameters().get("authcode").toString());
                    rootNode.appendChild(element);
                }
                if (!response.getParameters().containsKey("date")) break;
                element = doc.createElement("date");
                element.setTextContent(response.getParameters().get("date").toString());
                rootNode.appendChild(element);
            }
        }
        return this.xmlSerialize(doc);
    }
}

