/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public abstract class ElecsnetAbstractTransactionManager
extends MPSTransactionManager {
    protected static final String DATE_FORMAT = "yyyyMMddhhmmss";
    protected static final int ERROR_SERVICE_UNAVAILABLE = 1000;
    protected static final int ERROR_CONTRACT_NOT_FOUND = 1001;
    protected static final String encoding = "cp1251";
    protected static final BigDecimal MULTIPLICAND = new BigDecimal(100);
    private String sumParamName;
    private String dateParamName;

    public ElecsnetAbstractTransactionManager(String sum, String date) {
        this.sumParamName = sum;
        this.dateParamName = date;
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        MPSRequest result = new MPSRequest(con, moduleId, mpsId, request, system);
        String action = request.getParameter("type");
        if (Utils.isBlankString((String)action)) {
            throw new MPSException(21, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"type\" \u043d\u0435 \u0437\u0430\u0434\u0430\u043d [" + action + "]");
        }
        if ("1".equals(action)) {
            result.setAction(1);
        } else {
            result.setAction(2);
        }
        String reqidParameter = request.getParameter("reqid");
        if (reqidParameter == null) {
            throw new MPSException(21, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"reqid\" \u043d\u0435 \u0437\u0430\u0434\u0430\u043d [" + reqidParameter + "]");
        }
        result.setNumber(reqidParameter);
        result.setRawNumber(reqidParameter);
        if (result.getAction() == 2) {
            result.setTransId(request.getParameter("auth_code"));
            BigDecimal amount = new BigDecimal(request.getParameter(this.sumParamName));
            result.setSum(amount.divide(MULTIPLICAND));
            String dateString = request.getParameter(this.dateParamName);
            Date date = TimeUtils.parseDate((String)dateString, (String)DATE_FORMAT);
            result.setTime(date);
            result.setTimeString(dateString);
        }
        return result;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 1001: {
                response.setResult(AnswerCode.ERROR_CONTRACT_NUMBER.getCode());
                break;
            }
            case 3: {
                response.setResult(AnswerCode.ERROR_ACCOUNT_NUMBER.getCode());
                break;
            }
            case -1: {
                response.setResult(AnswerCode.ERROR_SYSTEM.getCode());
                break;
            }
            case 6: {
                response.setResult(AnswerCode.ERROR_DATE.getCode());
                response.setMessage("\u0443\u0447\u0435\u0442\u043d\u0430\u044f \u0434\u0430\u0442\u0430 \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043d\u0430 24 \u0447\u0430\u0441\u0430");
                break;
            }
            case 10: {
                response.setResult(AnswerCode.ERROR_HASH.getCode());
                break;
            }
            case 21: {
                response.setResult(AnswerCode.ERROR_SYSTEM.getCode());
                break;
            }
            case 1000: {
                response.setResult(AnswerCode.ERROR_SERVICE_TECHN.getCode());
                break;
            }
            case 4: {
                response.setResult(AnswerCode.ERROR_AUTH_CODE.getCode());
            }
        }
        response.setMessage(ex.message);
    }

    protected static enum AnswerCode {
        ACCEPT_PAYMENT(0),
        ERROR_AUTH_CODE(1),
        ERROR_DATE(2),
        ERROR_HASH(3),
        ERROR_SERVICE_ADMIN(26),
        ERROR_ACCOUNT_NUMBER(43),
        ERROR_SERVICE_TECHN(45),
        ERROR_CONTRACT_NUMBER(48),
        ERROR_SYSTEM(49);

        private int code;

        private AnswerCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return String.valueOf(this.code);
        }
    }
}

