/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.Contract;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class BiSysTransactionManager
extends MPSTransactionManager {
    private static final Logger logger = LogManager.getLogger();
    private static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9);
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            mpsResponse.setAction(mpsRequest.getAction());
            mpsResponse.getParameters().put("sign", mpsRequest.parameters.get("sign"));
            mpsResponse.setNumber(mpsRequest.getNumber());
            Contract contract = this.actionCheck(mpsRequest);
            switch (mpsRequest.getAction()) {
                case 1: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 - \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                    }
                    BalanceUtils bu = new BalanceUtils(con);
                    mpsResponse.getParameters().put("balance", Utils.formatBigDecimalSumm((BigDecimal)bu.getBalanceOut(new Date(), contract.getId())));
                    bu.close();
                    String comment = this.getComment(system, conf, con, contract);
                    if (system.extNeedClientInfo && Utils.notBlankString((String)comment)) {
                        mpsResponse.getParameters().put("client_name", comment);
                    }
                    mpsResponse.setResult(0);
                    mpsResponse.setMessage("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0430\u0439\u0434\u0435\u043d - \u043e\u043f\u043b\u0430\u0442\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430");
                    break;
                }
                case 2: {
                    Transaction transaction;
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
                    }
                    if ((transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getSessionId(), mpsRequest.getTime())) == null) {
                        transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getSessionId(), mpsRequest.getNumber(), mpsRequest.getType(), "");
                        mpsResponse.getParameters().put("reg_id", transaction.getId());
                        mpsResponse.getParameters().put("reg_date", TimeUtils.format((Date)transaction.getLocalTime(), (String)TIME_FORMAT));
                        mpsResponse.setResult(0);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0437\u0430\u0447\u0438\u0441\u043b\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
                        break;
                    }
                    if (mpsRequest.getNumber().equals(transaction.getRawNumber()) && mpsRequest.getSum().compareTo(transaction.getSum()) == 0) {
                        mpsResponse.getParameters().put("reg_id", transaction.getId());
                        mpsResponse.getParameters().put("reg_date", TimeUtils.format((Date)transaction.getLocalTime(), (String)TIME_FORMAT));
                        throw new MPSException(4);
                    }
                    throw new MPSException(ErrorCode.ANSWER_ERROR_ANOTHER_PAYMENT.errCode);
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1), mpsResponse);
            logger.error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage(), (Throwable)e);
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        int act;
        Document doc;
        if (logger.isDebugEnabled()) {
            logger.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
        MPSRequest req = new MPSRequest(con, moduleId, mpsId, request, system);
        String params = request.getParameter("params");
        try {
            if (!Utils.notBlankString((String)params)) {
                throw new MPSException(2, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430!");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u0430\u044f xml: " + params);
            }
            doc = this.documentBuilder.parse(new InputSource(new StringReader(params)));
        }
        catch (SAXException e) {
            throw new MPSException(2, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0447\u0438\u0442\u0430\u0442\u044c xml \u0438\u0437 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
        catch (IOException e) {
            throw new MPSException(2, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0447\u0438\u0442\u0430\u0442\u044c xml \u0438\u0437 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
        Element paramsElement = XMLUtils.selectElement((Node)doc, (String)"//request/params");
        Element actElement = XMLUtils.selectElement((Node)paramsElement, (String)"//act");
        Element signElement = XMLUtils.selectElement((Node)doc, (String)"//sign");
        Element accountElement = XMLUtils.selectElement((Node)paramsElement, (String)"//account");
        Element agentDateElement = XMLUtils.selectElement((Node)paramsElement, (String)"//agent_date");
        Element payIdElement = XMLUtils.selectElement((Node)paramsElement, (String)"//pay_id");
        Element payAmountElement = XMLUtils.selectElement((Node)paramsElement, (String)"//pay_amount");
        Element servCodeElement = XMLUtils.selectElement((Node)paramsElement, (String)"//serv_code");
        if (actElement == null || signElement == null || accountElement == null) {
            throw new MPSException(21);
        }
        if (logger.isDebugEnabled()) {
            String debugMessage = "\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0438\u0437 xml: \n act = " + (actElement != null ? actElement.getTextContent() : "null") + "; sign = " + (signElement != null ? signElement.getTextContent() : "null") + "; account = " + (accountElement != null ? accountElement.getTextContent() : "null") + "; agent_date = " + (agentDateElement != null ? agentDateElement.getTextContent() : "null") + "; pay_id = " + (payIdElement != null ? payIdElement.getTextContent() : "null") + "; pay_amount = " + (payAmountElement != null ? payAmountElement.getTextContent() : "null") + "; serv_code = " + (servCodeElement != null ? servCodeElement.getTextContent() : "null");
            logger.debug(debugMessage);
        }
        if ((act = Utils.parseInt((String)actElement.getTextContent(), (int)1)) == 1) {
            req.setAction(1);
        } else {
            req.setAction(2);
            if (payIdElement == null || agentDateElement == null || payAmountElement == null) {
                throw new MPSException(21);
            }
            req.setSessionId(payIdElement.getTextContent());
            req.setTimeString(agentDateElement.getTextContent());
            req.setTime(TimeUtils.parseDate((String)req.getTimeString(), (String)TIME_FORMAT));
            req.setSum(new BigDecimal(Utils.parseInt((String)payAmountElement.getTextContent(), (int)0)).divide(new BigDecimal(100)));
        }
        if (servCodeElement != null) {
            req.setType(Utils.parseInt((String)servCodeElement.getTextContent(), (int)0));
        }
        req.setNumber(accountElement.getTextContent());
        req.setRawNumber(req.getNumber());
        String incomingSign = signElement.getTextContent();
        String serializedXml = params.substring(params.indexOf("<params>") + 8, params.indexOf("</params>"));
        String strToSign = serializedXml + system.secret;
        if (logger.isDebugEnabled()) {
            logger.debug("\u0421\u0442\u0440\u043e\u043a\u0430, \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0432\u044b\u0447\u0438\u0441\u043b\u044f\u0435\u0442\u0441\u044f \u0445\u044d\u0448 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u0440\u0438\u0448\u0435\u0434\u0448\u0435\u0439 \u043f\u043e\u0434\u043f\u0438\u0441\u0438: " + strToSign);
        }
        String sign = null;
        try {
            String encoding = Utils.maskBlank((String)system.requestEncoding, (String)"UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(strToSign.getBytes(encoding));
            sign = new String(Utils.bytesToHexString((byte[])md.digest())).toLowerCase();
            if (logger.isDebugEnabled()) {
                logger.debug("\u041f\u043e\u043b\u0443\u0447\u0438\u0432\u0448\u0430\u044f\u0441\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u044c (\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430 " + encoding + "): " + sign);
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0430\u043b\u0433\u043e\u0440\u0438\u0442\u043c \u043f\u043e\u0434\u043f\u0438\u0441\u0438", (Throwable)e);
            throw new MPSException(-1, "\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0430\u043b\u0433\u043e\u0440\u0438\u0442\u043c \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u0438");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u0430\u044f \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430", (Throwable)e);
            throw new MPSException(-1, "\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
        }
        if (!sign.equalsIgnoreCase(incomingSign)) {
            throw new MPSException(10);
        }
        req.parameters.put("sign", incomingSign);
        return req;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case -1: 
            case 2: {
                response.setResult(ErrorCode.ANSWER_ERROR_OTHER.errCode);
                response.setMessage(ex.message);
                break;
            }
            case 21: {
                response.setResult(ErrorCode.ANSWER_NOT_ENOUGH_PARAMS.errCode);
                response.setMessage(ErrorCode.ANSWER_NOT_ENOUGH_PARAMS.errText);
                break;
            }
            case 9: {
                response.setResult(ErrorCode.ANSWER_ERROR_SERVICE_UNAVAILABLE.errCode);
                response.setMessage(ErrorCode.ANSWER_ERROR_SERVICE_UNAVAILABLE.errText);
                break;
            }
            case 3: {
                response.setResult(ErrorCode.ANSWER_ERROR_CONTRACT_NOT_FOUND.errCode);
                response.setMessage(ErrorCode.ANSWER_ERROR_CONTRACT_NOT_FOUND.errText);
                break;
            }
            case 10: {
                response.setResult(ErrorCode.ANSWER_ERROR_HASH.errCode);
                response.setMessage(ErrorCode.ANSWER_ERROR_HASH.errText);
                break;
            }
            case 4: {
                response.setResult(ErrorCode.ANSWER_ERROR_PAYMENT_ALREADY_PAYED.errCode);
                response.setMessage(ErrorCode.ANSWER_ERROR_PAYMENT_ALREADY_PAYED.errText);
                break;
            }
            case 30: {
                response.setResult(ErrorCode.ANSWER_ERROR_ANOTHER_PAYMENT.errCode);
                response.setMessage(ErrorCode.ANSWER_ERROR_ANOTHER_PAYMENT.errText);
            }
        }
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        Document document = XMLUtils.newDocument();
        Element responseElement = XMLUtils.createElement((Document)document, (String)"response");
        Element paramsElement = XMLUtils.createElement((Element)responseElement, (String)"params");
        XMLUtils.createElement((Element)paramsElement, (String)"err_code").setTextContent(String.valueOf(response.getResult()));
        XMLUtils.createElement((Element)paramsElement, (String)"err_text").setTextContent(response.getMessage());
        if (response.getResult() == 0 || response.getResult() == 1) {
            XMLUtils.createElement((Element)paramsElement, (String)"account").setTextContent(response.getNumber());
            switch (response.getAction()) {
                case 1: {
                    XMLUtils.createElement((Element)paramsElement, (String)"balance").setTextContent(response.getParameters().get("balance").toString());
                    if (response.getParameters().get("client_name") == null) break;
                    XMLUtils.createElement((Element)paramsElement, (String)"client_name").setTextContent(response.getParameters().get("client_name").toString());
                    break;
                }
                case 2: {
                    XMLUtils.createElement((Element)paramsElement, (String)"reg_id").setTextContent(response.getParameters().get("reg_id").toString());
                    XMLUtils.createElement((Element)paramsElement, (String)"reg_date").setTextContent(response.getParameters().get("reg_date").toString());
                }
            }
        }
        if (response.getParameters().get("sign") != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                String encoding = Utils.maskBlank((String)system.responseEncoding, (String)"UTF-8");
                XMLUtils.serialize((Node)paramsElement, (OutputStream)baos, (String)encoding);
                String serializedXml = baos.toString(encoding);
                serializedXml = serializedXml.substring(serializedXml.indexOf("<params>") + 8, serializedXml.indexOf("</params>"));
                String strToSign = serializedXml + response.getParameters().get("sign").toString() + system.secret;
                if (logger.isDebugEnabled()) {
                    logger.debug("\u0421\u0442\u0440\u043e\u043a\u0430, \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0444\u043e\u0440\u043c\u0438\u0440\u0443\u0435\u0442\u0441\u044f MD5-\u043f\u043e\u0434\u043f\u0438\u0441\u044c \u0434\u043b\u044f \u043e\u0442\u0432\u0435\u0442\u0430 \u0441\u0435\u0440\u0432\u0438\u0441\u0443: " + strToSign);
                }
                String sign = null;
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(strToSign.getBytes(encoding));
                sign = new String(Utils.bytesToHexString((byte[])md.digest())).toLowerCase();
                if (logger.isDebugEnabled()) {
                    logger.debug("\u0421\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f MD5-\u043f\u043e\u0434\u043f\u0438\u0441\u044c (\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430 " + encoding + "): " + sign);
                }
                XMLUtils.createElement((Element)responseElement, (String)"sign").setTextContent(sign);
            }
            catch (NoSuchAlgorithmException e) {
                logger.error("\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0430\u043b\u0433\u043e\u0440\u0438\u0442\u043c \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u0438", (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u0430\u044f \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430", (Throwable)e);
            }
        }
        return this.xmlSerialize(document);
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    @Override
    protected void checkValid(Conf.MPSSystem system, MPSRequest req, Connection con) throws MPSException {
    }

    @Override
    public String getDefaultEncoding() {
        return "UTF-8";
    }

    private static enum ErrorCode {
        ANSWER_SUCCESS(0, "\u041d\u0435\u0442 \u043e\u0448\u0438\u0431\u043a\u0438. \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e"),
        ANSWER_ERROR_PAYMENT_ALREADY_PAYED(1, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0436\u0435 \u0431\u044b\u043b \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d"),
        ANSWER_NOT_ENOUGH_PARAMS(11, "\u0423\u043a\u0430\u0437\u0430\u043d\u044b \u043d\u0435 \u0432\u0441\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"),
        ANSWER_ERROR_HASH(13, "\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0446\u0438\u0444\u0440\u043e\u0432\u0430\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u044c"),
        ANSWER_ERROR_CONTRACT_NOT_FOUND(20, "\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0441\u0447\u0435\u0442\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442"),
        ANSWER_ERROR_ANOTHER_PAYMENT(30, "\u0411\u044b\u043b \u0434\u0440\u0443\u0433\u043e\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043d\u043e\u043c\u0435\u0440\u043e\u043c"),
        ANSWER_ERROR_SERVICE_UNAVAILABLE(90, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442"),
        ANSWER_ERROR_OTHER(99, "\u041f\u0440\u043e\u0447\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438. ");

        private int errCode;
        private String errText;

        private ErrorCode(int code, String title) {
            this.errCode = code;
            this.errText = title;
        }
    }
}

