/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.service;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.util.MailMsg;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.jws.WebService;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.license.common.LicenseUtils;
import ru.bitel.bgbilling.modules.license.common.bean.Component;
import ru.bitel.bgbilling.modules.license.common.bean.ConfirmedOrder;
import ru.bitel.bgbilling.modules.license.common.bean.ContractData;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.bean.License;
import ru.bitel.bgbilling.modules.license.common.bean.Order;
import ru.bitel.bgbilling.modules.license.common.bean.OrderType;
import ru.bitel.bgbilling.modules.license.common.bean.Product;
import ru.bitel.bgbilling.modules.license.common.bean.StatData;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.bgbilling.modules.license.common.service.OrderService;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.license.common.service.LicenseService")
public class LicenseServiceImpl
extends AbstractService
implements LicenseService {
    private LicenseManager licenseManager;
    @Resource
    private OrderService orderService;

    private LicenseManager getLicenseManager() {
        if (this.licenseManager == null) {
            this.licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        }
        return this.licenseManager;
    }

    public List<Copy> copyList(int contractId) throws BGException {
        return this.getLicenseManager().getCopyList(contractId);
    }

    public List<Product> productList() throws BGException {
        return this.getLicenseManager().getProducts();
    }

    public List<Product> productListWithComponent(int componentId) throws BGException {
        return this.getLicenseManager().getProductsWithComponent(componentId);
    }

    public List<Copy> productCopyList(int contractId) {
        return this.getLicenseManager().getCopyList(contractId);
    }

    public List<ConfirmedOrder> confirmedOrderList(int contractId, int copyId, int filter) throws BGException {
        if (!this.copyList(contractId).stream().anyMatch(a -> a.getId() == copyId)) {
            throw new BGIllegalArgumentException("copyId");
        }
        return this.getLicenseManager().getCopyItems(copyId, filter);
    }

    public List<License> licenseList(int contractId, int copyId) throws BGIllegalArgumentException {
        Copy copy = this.getLicenseManager().getCopy(copyId);
        if (copy.getContractId() != contractId) {
            throw new BGIllegalArgumentException("copyId");
        }
        return this.getLicenseManager().getLicenses(copyId);
    }

    private Map<String, BigDecimal> getItemsCosts(List<ConfirmedOrder> items, String productVersion) {
        String url = LicenseUtils.buildLicenseCostUrlRequest(items, (String)productVersion, (ParameterMap)this.getModuleSetup());
        return LicenseUtils.getCosts((String)url);
    }

    public List<ConfirmedOrder> licenseComponentList(int contractId, int licenseId) throws BGIllegalArgumentException {
        License license = this.getLicenseManager().getLicenseById(licenseId);
        Copy copy = this.getLicenseManager().getCopy(license.getCopyId());
        if (copy.getContractId() != contractId) {
            throw new BGIllegalArgumentException("licenseId");
        }
        List<ConfirmedOrder> result = this.getLicenseManager().getLicenseItems(licenseId, false);
        Map<String, BigDecimal> licenseItemCosts = this.getItemsCosts(result, copy.getProductVersion());
        for (ConfirmedOrder item : result) {
            BigDecimal itemCost = licenseItemCosts.get(item.getComponentName());
            if (itemCost == null || item.getType() == OrderType.TEST.getCode()) {
                itemCost = BigDecimal.ZERO;
            }
            item.setCost(itemCost);
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(Currency.getInstance("UZS").getDefaultFractionDigits());
    }

    public int licenseCreate(int contractId, int copyId, Set<String> confirmedOrderIds_, boolean customer) throws BGException {
        String receiverEmail;
        Set confirmedOrderIds = confirmedOrderIds_.stream().map(a -> Utils.toIntegerSet((String)a)).collect(Collectors.toSet());
        List<ConfirmedOrder> currentConfirmedOrderList = this.confirmedOrderList(contractId, copyId, 2);
        Map<Set, ConfirmedOrder> currentConfirmedOrderMap = currentConfirmedOrderList.stream().collect(Collectors.toMap(k -> Utils.toIntegerSet((String)k.getIds()), v -> v));
        if (!currentConfirmedOrderMap.keySet().containsAll(confirmedOrderIds)) {
            throw new BGIllegalArgumentException("confirmedComponentIds");
        }
        currentConfirmedOrderMap.keySet().retainAll(confirmedOrderIds);
        ArrayList<ConfirmedOrder> confirmedOrderList = new ArrayList<ConfirmedOrder>(currentConfirmedOrderMap.values());
        int[] componentIds = new int[confirmedOrderList.size()];
        int i = 0;
        HashSet<Integer> componentIdCheckSet = new HashSet<Integer>();
        for (ConfirmedOrder confirmedOrder : confirmedOrderList) {
            if (!componentIdCheckSet.add(confirmedOrder.getComponentId())) {
                throw new BGMessageException("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u043a\u043b\u044e\u0447\u0430\u0442\u044c \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b.", "confirmedComponentIds.componentIntersection");
            }
            for (Object orderId : Utils.toIntegerSet((String)confirmedOrder.getIds())) {
                if (this.getLicenseManager().checkCopyItemStatus((Integer)orderId)) continue;
                throw new BGMessageException("\u0421\u0442\u0430\u0442\u0443\u0441 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043d\u0435 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0438\u0445 \u0432 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e.", "confirmedComponentIds.status");
            }
            componentIds[i++] = confirmedOrder.getComponentId();
        }
        Set ids = confirmedOrderIds.stream().reduce(new HashSet(), (a, b) -> {
            a.addAll(b);
            return a;
        });
        int[] idsa = new int[ids.size()];
        int c = 0;
        for (Integer id : ids) {
            idsa[c++] = id;
        }
        License p = new License();
        p.setCopyId(copyId);
        p.setUserId(this.userId);
        p.setCopyItemIds(idsa);
        p.setData("");
        p.setOriginalData("");
        int licenseId = this.getLicenseManager().createLicense(p);
        Copy copy = this.getLicenseManager().getCopy(copyId);
        List<ConfirmedOrder> licenseItems = this.getLicenseManager().getLicenseItems(p.getId(), true);
        String licText = LicenseUtils.getLicenseText(licenseItems, (LicenseManager)this.getLicenseManager(), (int)contractId, (Preferences)this.getModuleSetup(), (Copy)copy);
        if (Utils.isBlankString((String)licText)) {
            throw new BGIllegalAccessException("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0442\u0438\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438.");
        }
        p.setOriginalData(licText);
        try {
            p.setData(LicenseUtils.encryptLicenseText((String)licText, (Preferences)this.getModuleSetup()));
        }
        catch (IOException e) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0448\u0438\u0444\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438.");
        }
        if (Utils.isBlankString((String)p.getData())) {
            throw new BGIllegalAccessException("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438.");
        }
        this.getLicenseManager().updateLicenseData(p);
        if (customer && "true".equals(this.getModuleSetup().get("license.create.email.send", "false")) && Utils.notBlankString((String)(receiverEmail = this.getModuleSetup().get("license.bills.email.to", "")))) {
            ContractManager contractManager = new ContractManager(this.getConnection());
            Contract contract = contractManager.getContractById(contractId);
            contractManager.close();
            MailMsg message = new MailMsg((Preferences)this.getSetup());
            String text = "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + contract.getTitle() + " \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043b \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e.";
            message.sendMessage(receiverEmail, "\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438", text);
        }
        return licenseId;
    }

    public int createPackage(int contractId, int copyId, Set<String> confirmedOrderIds) throws BGException, BGMessageException, BGIllegalArgumentException {
        int[] ids = confirmedOrderIds.stream().mapToInt(a -> Utils.parseInt((String)a)).toArray();
        License license = new License();
        license.setCopyId(copyId);
        license.setUserId(this.userId);
        license.setCopyItemIds(ids);
        license.setData("");
        LicenseManager licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        Copy copy = licenseManager.getCopy(copyId);
        int packageId = licenseManager.createLicense(license);
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        List<ConfirmedOrder> licenseItems = licenseManager.getLicenseItems(license.getId(), true);
        String licText = LicenseUtils.getLicenseText(licenseItems, (LicenseManager)licenseManager, (int)contractId, (Preferences)moduleSetup, (Copy)copy);
        if (!Utils.notBlankString((String)licText)) {
            throw new BGIllegalAccessException("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0442\u0438\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438.");
        }
        license.setOriginalData(licText);
        String encryptedLicense = "";
        try {
            encryptedLicense = LicenseUtils.encryptLicenseText((String)licText, (Preferences)moduleSetup);
        }
        catch (IOException e) {
            throw new BGException("error while license encrypting", (Throwable)e);
        }
        if (Utils.isBlankString((String)encryptedLicense)) {
            throw new BGIllegalAccessException("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438.");
        }
        license.setData(encryptedLicense);
        licenseManager.updateLicenseData(license);
        return packageId;
    }

    public void prolongTestOrders(int contractId, Date dateTo, List<Integer> ids) throws BGException, BGMessageException, BGIllegalArgumentException {
        if (ids.size() == 0) {
            throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u044b \u0437\u0430\u043a\u0430\u0437\u044b");
        }
        LicenseManager licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        for (int condirmedOrderId : ids) {
            int orderId;
            Order order;
            if (condirmedOrderId <= 0 || (order = licenseManager.getOrder(orderId = licenseManager.getOrderIdFromConfirmedId(condirmedOrderId))) == null || order.getType() != OrderType.TEST) continue;
            Date createDate = order.getCreateDate();
            int term = TimeUtils.daysDelta((Date)createDate, (Date)dateTo);
            order.setTerm(term);
            licenseManager.updateCopyItemOrder(order, false);
            licenseManager.updateTestComponentDateTo(condirmedOrderId, dateTo);
        }
    }

    public Order orderGet(int orderId) throws BGException {
        if (orderId <= 0) {
            throw new BGIllegalArgumentException();
        }
        return this.getLicenseManager().getOrder(orderId);
    }

    public void orderUpdate(Order order) throws BGException {
        if (order.getType() == OrderType.BUY) {
            boolean deny = true;
            if (order.getId() > 0) {
                Order oldOrder = this.getLicenseManager().getOrder(order.getId());
                boolean bl = deny = oldOrder == null || !order.isRealyEquals(oldOrder);
            }
            if (deny && this.getLicenseManager().checkHaveNonSignAdditionalAgreement(order.getCopyId())) {
                throw new BGMessageException("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435/\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e. \u0415\u0441\u0442\u044c \u043d\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043d\u043e\u0435 \u0434\u043e\u043f.\u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435.");
            }
            order.setTerm(0);
        }
        order.setUserId(this.userId);
        if (this.illegalArguments(order)) {
            throw new BGIllegalArgumentException();
        }
        this.getLicenseManager().updateCopyItemOrder(order);
    }

    public void orderDelete(int orderId) throws BGException, BGMessageException {
        Order order = this.getLicenseManager().getOrder(orderId);
        if (order == null) {
            throw new BGIllegalArgumentException();
        }
        if (order.getType() == OrderType.BUY && this.getLicenseManager().checkHaveNonSignAdditionalAgreement(order.getCopyId())) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e. \u0415\u0441\u0442\u044c \u043d\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043d\u043e\u0435 \u0434\u043e\u043f. \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435.");
        }
        if (order.getStatus() != 0) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u044f\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043a\u0430\u0437\u044b \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u043d\u043e\u0432\u044b\u0439\".");
        }
        this.getLicenseManager().deleteOrder(orderId);
    }

    public List<StatData> doStatData(int productId) throws BGException {
        StatData statData;
        ArrayList<StatData> statDataList = new ArrayList<StatData>();
        LicenseManager licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        for (Component component : licenseManager.getComponentsForProduct(productId)) {
            statData = new StatData();
            statData.setComponent(component);
            statDataList.add(statData);
        }
        Map<Integer, int[]> componentCopyMap = licenseManager.getCopyCountForComponentByProductMap(productId);
        Iterator iterator = statDataList.iterator();
        while (iterator.hasNext()) {
            int[] counters = componentCopyMap.get((statData = (StatData)iterator.next()).getComponent().getId());
            statData.setCopyCount(counters == null ? 0 : counters[0]);
            statData.setUnlimCount(counters == null ? 0 : counters[1]);
            statData.setLicCount(counters == null ? 0 : counters[2]);
        }
        return statDataList;
    }

    public List<ContractData> doContractData(int productId, int componentId) throws BGException {
        LicenseManager licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        return licenseManager.doContractData(productId, componentId);
    }

    private boolean illegalArguments(Order order) {
        return order.getCopyId() <= 0 || order.getComponentId() <= 0 || order.getCount() < 0 || order.getType().getCode() < 0 || order.getStatus() < 0 || order.getTerm() < 0 || order.getTerm() == 0 && order.getType() == OrderType.TEST;
    }

    public String getProductLinks(int productId) throws BGException, BGMessageException {
        JSONArray links = new JSONArray();
        if (productId > 0) {
            LicenseManager licenseDAO = new LicenseManager(this.getConnection(), this.moduleId);
            List<Component> selectedProductItems = licenseDAO.getComponentsForProduct(productId);
            List<Component> allProductItems = licenseDAO.getComponentList();
            for (Component component : allProductItems) {
                JSONObject link = new JSONObject();
                link.put("id", component.getId());
                link.put("title", (Object)component.getTitle());
                link.put("select", this.isSelected(component, selectedProductItems));
                links.put((Object)link);
            }
        }
        return links.toString();
    }

    public String getProductItemLinks(int productItemId) throws BGException, BGMessageException {
        JSONArray links = new JSONArray();
        if (productItemId > 0) {
            LicenseManager licenseDAO = new LicenseManager(this.getConnection(), this.moduleId);
            List<Product> selectedProducts = licenseDAO.getProductsWithComponent(productItemId);
            List<Product> allProducts = licenseDAO.getProducts();
            for (Product product : allProducts) {
                JSONObject link = new JSONObject();
                link.put("id", product.getId());
                link.put("title", (Object)(product.getTitle() + " " + product.getVersion()));
                link.put("select", this.isSelected(product, selectedProducts));
                links.put((Object)link);
            }
        }
        return links.toString();
    }

    private boolean isSelected(Component productItem, List<Component> selectedProductItems) {
        for (Component selectedItem : selectedProductItems) {
            if (selectedItem.getId() != productItem.getId()) continue;
            return true;
        }
        return false;
    }

    private boolean isSelected(Product product, List<Product> selectedProducts) {
        for (Product selectedProduct : selectedProducts) {
            if (selectedProduct.getId() != product.getId()) continue;
            return true;
        }
        return false;
    }

    public List<Component> getProductItems() throws BGException, BGMessageException {
        return new LicenseManager(this.getConnection(), this.moduleId).getComponentList();
    }
}

