/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.security;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.bc.BcPGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;

public class GnuPG {
    protected final String publickeyFile;
    protected final String privatekeyFile;

    public GnuPG(String publickeyFile, String privatekeyFile) {
        this.publickeyFile = publickeyFile;
        this.privatekeyFile = privatekeyFile;
    }

    private static PGPSecretKey findPrivateGPGKey(InputStream inputStream, String secID) throws Exception {
        BcPGPSecretKeyRingCollection secretKeyRingCollection = new BcPGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)inputStream));
        Iterator keyRingIter = secretKeyRingCollection.getKeyRings();
        while (keyRingIter.hasNext()) {
            PGPSecretKeyRing secretKeyRing = (PGPSecretKeyRing)keyRingIter.next();
            PGPSecretKey tmpKey = secretKeyRing.getSecretKey();
            if (!tmpKey.isSigningKey() || !tmpKey.isMasterKey() || secID != null && !Long.toHexString(tmpKey.getKeyID()).toUpperCase().endsWith(secID.toUpperCase())) continue;
            return tmpKey;
        }
        throw new PGPException("No private key found!");
    }

    private static PGPPublicKey findPublicGPGKey(InputStream inputStream, String keyID) throws Exception {
        BcPGPPublicKeyRingCollection publicKeyRingCollection = new BcPGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)inputStream));
        Iterator keyRingIter = publicKeyRingCollection.getKeyRings();
        while (keyRingIter.hasNext()) {
            PGPPublicKeyRing publicKeyRing = (PGPPublicKeyRing)keyRingIter.next();
            Iterator keyIter = publicKeyRing.getPublicKeys();
            while (keyIter.hasNext()) {
                PGPPublicKey tmpKey = (PGPPublicKey)keyIter.next();
                if (!tmpKey.isEncryptionKey() || keyID != null && !Long.toHexString(tmpKey.getKeyID()).toUpperCase().endsWith(keyID.toUpperCase())) continue;
                return tmpKey;
            }
        }
        throw new PGPException("No public key found!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sign(byte[] utf8Bytes, String secID, String passPhrase) throws Exception {
        PGPSecretKey secretKey = GnuPG.findPrivateGPGKey(new FileInputStream(this.privatekeyFile), secID);
        PBESecretKeyDecryptor decryptorFactory = new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(passPhrase.toCharArray());
        PGPPrivateKey privateKey = secretKey.extractPrivateKey(decryptorFactory);
        BcPGPContentSignerBuilder contentSignerBuilder = new BcPGPContentSignerBuilder(secretKey.getPublicKey().getAlgorithm(), 2);
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)contentSignerBuilder);
        signatureGenerator.init(0, privateKey);
        Iterator userIds = secretKey.getPublicKey().getUserIDs();
        if (!userIds.hasNext()) {
            throw new Exception("Did not find userId");
        }
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
        subpacketGenerator.setSignerUserID(false, (String)userIds.next());
        signatureGenerator.setHashedSubpackets(subpacketGenerator.generate());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArmoredOutputStream armoredOut = new ArmoredOutputStream((OutputStream)byteArrayOutputStream);
        PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(2);
        BCPGOutputStream bcOutputStream = new BCPGOutputStream(compressedDataGenerator.open((OutputStream)armoredOut));
        signatureGenerator.generateOnePassVersion(false).encode((OutputStream)bcOutputStream);
        PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
        try {
            OutputStream literalDataOutput = literalDataGenerator.open((OutputStream)bcOutputStream, 'b', "fake", (long)utf8Bytes.length, new Date());
            literalDataOutput.write(utf8Bytes);
            signatureGenerator.update(utf8Bytes);
            literalDataGenerator.close();
            signatureGenerator.generate().encode((OutputStream)bcOutputStream);
            compressedDataGenerator.close();
        }
        finally {
            byteArrayOutputStream.close();
            armoredOut.close();
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encrypt(byte[] utf8Bytes, String keyID) throws Exception {
        PGPPublicKey publicKey = GnuPG.findPublicGPGKey(new FileInputStream(this.publickeyFile), keyID);
        ByteArrayOutputStream compressedOutput = new ByteArrayOutputStream();
        PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
        PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(1);
        try {
            OutputStream literalDataOutput = literalDataGenerator.open((OutputStream)compressedOutput, 'b', "fake", (long)utf8Bytes.length, new Date());
            literalDataOutput.write(utf8Bytes);
        }
        finally {
            compressedDataGenerator.close();
            compressedOutput.close();
        }
        byte[] compressedBytes = compressedOutput.toByteArray();
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new BcPGPDataEncryptorBuilder(3));
        encryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)new BcPublicKeyKeyEncryptionMethodGenerator(publicKey));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArmoredOutputStream armoredOut = new ArmoredOutputStream((OutputStream)byteArrayOutputStream);
        OutputStream encryptedOutput = null;
        try {
            encryptedOutput = encryptedDataGenerator.open((OutputStream)armoredOut, (long)compressedBytes.length);
            encryptedOutput.write(compressedBytes);
        }
        finally {
            encryptedOutput.close();
            armoredOut.close();
        }
        String encrypted = new String(byteArrayOutputStream.toByteArray());
        return encrypted;
    }

    public String signAndEncrypt(byte[] inStr, String secID, String keyID, String passPhrase) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clearSign(byte[] inStr, String secID, String passPhrase) throws Exception {
        PGPSecretKey secretKey = GnuPG.findPrivateGPGKey(new FileInputStream(this.privatekeyFile), secID);
        PBESecretKeyDecryptor decryptorFactory = new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(passPhrase.toCharArray());
        PGPPrivateKey privateKey = secretKey.extractPrivateKey(decryptorFactory);
        BcPGPContentSignerBuilder contentSignerBuilder = new BcPGPContentSignerBuilder(secretKey.getPublicKey().getAlgorithm(), 8);
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)contentSignerBuilder);
        signatureGenerator.init(1, privateKey);
        Iterator userIds = secretKey.getPublicKey().getUserIDs();
        if (!userIds.hasNext()) {
            throw new Exception("Did not find userId");
        }
        PGPSignatureSubpacketGenerator subpacketGenerator = new PGPSignatureSubpacketGenerator();
        subpacketGenerator.setSignerUserID(false, (String)userIds.next());
        signatureGenerator.setHashedSubpackets(subpacketGenerator.generate());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArmoredOutputStream armoredOut = new ArmoredOutputStream((OutputStream)byteArrayOutputStream);
        BCPGOutputStream bcOutputStream = new BCPGOutputStream((OutputStream)armoredOut);
        try {
            signatureGenerator.update(inStr);
            armoredOut.beginClearText(8);
            armoredOut.write(inStr);
            armoredOut.write(System.getProperty("line.separator").getBytes());
            armoredOut.endClearText();
            signatureGenerator.generate().encode((OutputStream)bcOutputStream);
        }
        finally {
            byteArrayOutputStream.close();
            armoredOut.close();
            bcOutputStream.close();
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    public boolean verifySignature(String inStr, String keyID) throws Exception {
        return false;
    }
}

