/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.jmx;

import java.lang.management.ManagementFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.jmx.MBeanOperation;

public class AnnotatedMBean
implements DynamicMBean {
    private static final Logger logger = LogManager.getLogger();
    private final Object bean;
    private final SortedMap<String, MBeanAttributeEntry> attributeMap;
    private final SortedMap<String, MBeanOperationEntry> operationMap;

    public AnnotatedMBean(Object bean, SortedMap<String, MBeanAttributeEntry> attributeMap, SortedMap<String, MBeanOperationEntry> operationMap) {
        this.bean = bean;
        this.attributeMap = attributeMap;
        this.operationMap = operationMap;
    }

    public static AnnotatedMBean newInstance(Object o) {
        MBeanAttributeEntry attribute;
        Object name;
        boolean setter;
        boolean getter;
        Class<?> clazz = o.getClass();
        TreeMap<String, MBeanAttributeEntry> attributeMap = new TreeMap<String, MBeanAttributeEntry>();
        TreeMap<String, MBeanOperationEntry> operationMap = new TreeMap<String, MBeanOperationEntry>();
        Set<Method> methodList = Collections.newSetFromMap(new LinkedHashMap());
        for (Class<?> clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
            for (GenericDeclaration genericDeclaration : clazz2.getInterfaces()) {
                methodList.addAll(Arrays.asList(((Class)genericDeclaration).getMethods()));
            }
            methodList.addAll(Arrays.asList(clazz2.getMethods()));
        }
        for (Method m : methodList) {
            MBeanOperation mBeanOperation = m.getAnnotation(MBeanOperation.class);
            if (mBeanOperation != null) {
                MBeanOperationEntry mBeanOperationEntry = new MBeanOperationEntry();
                mBeanOperationEntry.method = m;
                mBeanOperationEntry.description = mBeanOperation.description();
                operationMap.put(m.getName(), mBeanOperationEntry);
                continue;
            }
            MBeanAttribute mBeanAttribute = m.getAnnotation(MBeanAttribute.class);
            if (mBeanAttribute == null) continue;
            getter = false;
            setter = false;
            name = m.getName();
            if (((String)name).startsWith("get") && ((String)name).length() > 3 && Character.isUpperCase(((String)name).codePointAt(3)) && m.getParameterTypes().length == 0) {
                name = ((String)name).substring(3, 4).toLowerCase() + ((String)name).substring(4);
                getter = true;
            } else if (((String)name).startsWith("is") && Character.isUpperCase(((String)name).codePointAt(2)) && m.getParameterTypes().length == 0) {
                name = ((String)name).substring(2, 3).toLowerCase() + ((String)name).substring(3);
                getter = true;
            } else if (m.getReturnType() != Void.class && m.getParameterTypes().length == 0) {
                getter = true;
            } else if (((String)name).startsWith("set") && ((String)name).length() > 3 && Character.isUpperCase(((String)name).codePointAt(3))) {
                name = ((String)name).substring(3, 4).toLowerCase() + ((String)name).substring(4);
                setter = true;
            } else if (m.getReturnType() == Void.class && m.getParameterTypes().length == 1) {
                setter = true;
            }
            if (!getter && !setter) continue;
            attribute = (MBeanAttributeEntry)attributeMap.get(name);
            if (attribute == null) {
                attribute = new MBeanAttributeEntry();
                attribute.name = name;
                attributeMap.put((String)name, attribute);
            }
            if (getter) {
                attribute.getter = m;
            } else {
                attribute.setter = m;
            }
            if (!Utils.isBlankString(attribute.description)) continue;
            attribute.description = mBeanAttribute.description();
        }
        for (GenericDeclaration genericDeclaration : clazz.getMethods()) {
            getter = false;
            setter = false;
            name = ((Method)genericDeclaration).getName();
            if (((String)name).startsWith("get") && ((String)name).length() > 3 && Character.isUpperCase(((String)name).codePointAt(3))) {
                name = ((String)name).substring(3, 4).toLowerCase() + ((String)name).substring(4);
                getter = true;
            } else if (((String)name).startsWith("is") && ((String)name).length() > 2 && Character.isUpperCase(((String)name).codePointAt(2))) {
                name = ((String)name).substring(2, 3).toLowerCase() + ((String)name).substring(3);
                getter = true;
            } else if (((Method)genericDeclaration).getReturnType() != Void.class && ((Method)genericDeclaration).getParameterTypes().length == 0) {
                getter = true;
            } else if (((String)name).startsWith("set") && ((String)name).length() > 3 && Character.isUpperCase(((String)name).codePointAt(3))) {
                name = ((String)name).substring(3, 4).toLowerCase() + ((String)name).substring(4);
                setter = true;
            } else if (((Method)genericDeclaration).getReturnType() == Void.class && ((Method)genericDeclaration).getParameterTypes().length == 1) {
                setter = true;
            }
            if (!getter && !setter || (attribute = (MBeanAttributeEntry)attributeMap.get(name)) == null) continue;
            if (getter) {
                attribute.getter = genericDeclaration;
                continue;
            }
            attribute.setter = genericDeclaration;
        }
        for (AnnotatedElement annotatedElement : clazz.getFields()) {
            MBeanAttribute mBeanAttribute = ((Field)annotatedElement).getAnnotation(MBeanAttribute.class);
            if (mBeanAttribute == null) continue;
            MBeanAttributeEntry attribute2 = (MBeanAttributeEntry)attributeMap.get(((Field)annotatedElement).getName());
            if (attribute2 == null) {
                attribute2 = new MBeanAttributeEntry();
                attribute2.name = ((Field)annotatedElement).getName();
            }
            attribute2.field = annotatedElement;
            if (!Utils.isBlankString(attribute2.description)) continue;
            attribute2.description = mBeanAttribute.toString();
        }
        return new AnnotatedMBean(o, attributeMap, operationMap);
    }

    public static ObjectName register(Object annotatedBean) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        return AnnotatedMBean.register(mbs, annotatedBean);
    }

    public static ObjectName register(Object annotatedBean, String suffix) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        return AnnotatedMBean.register(mbs, annotatedBean, suffix, false);
    }

    public static ObjectName register(MBeanServer mbs, Object annotatedBean) {
        return AnnotatedMBean.register(mbs, annotatedBean, null, true);
    }

    private static ObjectName register(MBeanServer mbs, Object annotatedBean, String name, boolean autoSuffix) {
        try {
            AnnotatedMBean annotatedMBean = AnnotatedMBean.newInstance(annotatedBean);
            if (annotatedMBean.attributeMap.size() == 0 && annotatedMBean.operationMap.size() == 0) {
                return null;
            }
            Class<?> clazz = annotatedBean.getClass();
            Object type = clazz.getPackage().getName();
            type = Utils.isBlankString(clazz.getSimpleName()) ? (String)type + ":type=" + clazz.getName().substring(clazz.getPackage().getName().length() + 1) : (String)type + ":type=" + clazz.getSimpleName();
            if (Utils.notBlankString(name)) {
                type = (String)type + "," + name;
            }
            if (!autoSuffix) {
                ObjectName objectName = new ObjectName((String)type);
                logger.info("Register MBean " + (String)type);
                mbs.registerMBean(annotatedMBean, objectName);
                return objectName;
            }
            for (int i = 0; i < 100; ++i) {
                try {
                    ObjectName objectName = new ObjectName((String)type + (String)(i > 0 ? "-" + i : ""));
                    mbs.registerMBean(annotatedMBean, objectName);
                    logger.info("Register MBean " + (String)type);
                    return objectName;
                }
                catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                    continue;
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        MBeanAttributeEntry a = (MBeanAttributeEntry)this.attributeMap.get(attribute);
        if (a == null) {
            throw new AttributeNotFoundException(attribute);
        }
        if (a.getter != null) {
            try {
                return a.getter.invoke(this.bean, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionException(e);
            }
        }
        if (a.field != null) {
            try {
                return a.field.get(this.bean);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException(e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
        }
        throw new AttributeNotFoundException(attribute);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        MBeanAttributeEntry a = (MBeanAttributeEntry)this.attributeMap.get(attribute.getName());
        if (a == null) {
            throw new AttributeNotFoundException(attribute.getName());
        }
        a.set(this.bean, attribute.getValue());
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList();
        for (Map.Entry<String, MBeanAttributeEntry> e : this.attributeMap.entrySet()) {
            try {
                result.add(new Attribute(e.getKey(), e.getValue().get(this.bean)));
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        for (Attribute attribute : attributes.asList()) {
            try {
                MBeanAttributeEntry a = (MBeanAttributeEntry)this.attributeMap.get(attribute.getName());
                if (a == null) {
                    throw new AttributeNotFoundException(attribute.getName());
                }
                a.set(this.bean, attribute.getValue());
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return attributes;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        MBeanOperationEntry operation = (MBeanOperationEntry)this.operationMap.get(actionName);
        if (operation == null) {
            throw new ReflectionException(new NoSuchMethodException(actionName));
        }
        try {
            return operation.method.invoke(this.bean, params);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        for (Map.Entry<String, MBeanAttributeEntry> entry : this.attributeMap.entrySet()) {
            try {
                attributes.add(entry.getValue().toInfo());
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        for (Map.Entry<String, Object> entry : this.operationMap.entrySet()) {
            try {
                operations.add(((MBeanOperationEntry)entry.getValue()).toInfo());
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        MBeanInfo result = new MBeanInfo(this.bean.getClass().getName(), "description", attributes.toArray(new MBeanAttributeInfo[attributes.size()]), new MBeanConstructorInfo[0], operations.toArray(new MBeanOperationInfo[operations.size()]), new MBeanNotificationInfo[0]);
        return result;
    }

    public static String mbeanGet(String objectName, String attribute) throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            return String.valueOf(mbs.getAttribute(new ObjectName(objectName), attribute));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static String mbeanSet(String objectName, String attribute, String value) throws Exception {
        logger.info("mbeanSet " + objectName + " " + attribute + " to " + value);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            String type = "";
            for (MBeanAttributeInfo i : mbs.getMBeanInfo(new ObjectName(objectName)).getAttributes()) {
                if (!attribute.equals(i.getName())) continue;
                type = i.getType();
                break;
            }
            Object v = value;
            if (type.contains("java.lang.Double") || type.contains("double")) {
                v = Utils.parseDouble(value, 0.0);
            } else if (type.contains("java.lang.Float") || type.contains("float")) {
                v = Float.valueOf(Utils.parseFloat(value, 0.0f));
            } else if (type.contains("java.lang.Boolean") || type.contains("boolean")) {
                v = Utils.parseBoolean(value, false);
            } else if (type.contains("java.lang.Integer") || type.contains("int")) {
                v = Utils.parseInt(value);
            } else if (type.contains("java.lang.Long") || type.contains("long")) {
                v = Utils.parseLong(value);
            }
            logger.info("Setting " + objectName + " " + attribute + " to " + v + " (" + v.getClass().getName() + ")");
            mbs.setAttribute(new ObjectName(objectName), new Attribute(attribute, v));
            return AnnotatedMBean.mbeanGet(objectName, attribute);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static String mbeanInvoke(String objectName, String operationName) throws Exception {
        logger.info("mbeanInvoke " + objectName + " " + operationName);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = new ObjectName(objectName);
        return String.valueOf(mbs.invoke(name, operationName, new Object[0], new String[0]));
    }

    public static String mbeanInfo(String objectNameString) throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = new ObjectName(objectNameString);
        StringBuilder sb = new StringBuilder();
        AnnotatedMBean.mbeanInfo(mbs, objectName, sb);
        return sb.toString();
    }

    private static void mbeanInfo(MBeanServer mbs, ObjectName objectName, StringBuilder sb) throws Exception {
        MBeanInfo info = mbs.getMBeanInfo(objectName);
        sb.append("MBean ").append(objectName).append('\n');
        sb.append("Attributes:\n");
        for (MBeanAttributeInfo mBeanAttributeInfo : info.getAttributes()) {
            sb.append("  ").append(mBeanAttributeInfo.getName()).append("\t\t").append(mBeanAttributeInfo.getType()).append('\t');
            if (mBeanAttributeInfo.isReadable()) {
                try {
                    sb.append(mbs.getAttribute(objectName, mBeanAttributeInfo.getName())).append('\t');
                }
                catch (Exception ex) {
                    sb.append("notSupported").append('\t');
                }
            } else {
                sb.append("notReadable").append('\t');
            }
            if (mBeanAttributeInfo.isWritable()) {
                sb.append("writable, ");
            } else {
                sb.append("notWritable, ");
            }
            sb.append(mBeanAttributeInfo.getDescription()).append('\n');
        }
        sb.append("Operations:\n");
        for (MBeanFeatureInfo mBeanFeatureInfo : info.getOperations()) {
            sb.append("  ").append(mBeanFeatureInfo.getName()).append("\t\t").append(((MBeanOperationInfo)mBeanFeatureInfo).getReturnType()).append('\t').append(mBeanFeatureInfo.getDescription()).append('\n');
        }
        sb.setLength(sb.length() - 1);
    }

    public static String mbeanQuery(String objectNameString) throws Exception {
        StringBuilder sb = new StringBuilder();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = null;
        objectName = Utils.notBlankString(objectNameString) ? new ObjectName(objectNameString) : new ObjectName("ru.*:*");
        for (ObjectName name : mbs.queryNames(objectName, null)) {
            AnnotatedMBean.mbeanInfo(mbs, name, sb);
            sb.append("\n\n");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(AnnotatedMBean.mbeanQuery("*:*"));
    }

    static class MBeanOperationEntry {
        Method method;
        String description;

        MBeanOperationEntry() {
        }

        public MBeanOperationInfo toInfo() {
            return new MBeanOperationInfo(this.description, this.method);
        }
    }

    static class MBeanAttributeEntry {
        String name;
        Method getter;
        Method setter;
        Field field;
        String description;

        MBeanAttributeEntry() {
        }

        public void set(Object bean, Object value) throws ReflectionException, AttributeNotFoundException {
            if (this.setter != null) {
                try {
                    this.setter.invoke(bean, value);
                    return;
                }
                catch (IllegalArgumentException e) {
                    throw new ReflectionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectionException(e);
                }
            }
            if (this.field != null) {
                try {
                    this.field.set(bean, value);
                    return;
                }
                catch (IllegalArgumentException e) {
                    throw new ReflectionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException(e);
                }
            }
            throw new AttributeNotFoundException("Set attribute not supported for " + this.name);
        }

        public Object get(Object bean) throws AttributeNotFoundException, ReflectionException {
            if (this.getter != null) {
                try {
                    return this.getter.invoke(bean, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new ReflectionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ReflectionException(e);
                }
            }
            if (this.field != null) {
                try {
                    return this.field.get(bean);
                }
                catch (IllegalArgumentException e) {
                    throw new ReflectionException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ReflectionException(e);
                }
            }
            throw new AttributeNotFoundException(this.name);
        }

        public MBeanAttributeInfo toInfo() {
            Class<?> type = this.getter != null ? this.getter.getReturnType() : this.field.getType();
            boolean isWritable = this.setter != null || this.field != null && (this.field.getModifiers() & 0x10) == 0;
            return new MBeanAttributeInfo(this.name, type.getName(), Utils.notEmptyString(this.description) ? this.description : this.name, true, isWritable, this.getter != null && this.getter.getName().startsWith("is"));
        }
    }
}

