/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class MultiSelectEditor<T extends IdTitle>
extends JPanel {
    private DefaultListModel<T> selectModel;
    private DefaultListModel<T> availableModel;
    private JList<T> selectList;
    private JList<T> availableList;
    private List<T> items;

    public MultiSelectEditor(List<T> items) {
        super(new GridBagLayout());
        this.items = items;
        this.selectModel = new DefaultListModel();
        this.availableModel = new DefaultListModel();
        this.selectList = new JList<T>(this.selectModel);
        this.availableList = new JList<T>(this.availableModel);
        for (IdTitle idTitle : items) {
            this.availableModel.addElement(idTitle);
        }
        this.availableList.setModel(this.availableModel);
        Dimension dimension = new Dimension(300, 200);
        JScrollPane selectScrollPane = new JScrollPane(this.selectList);
        selectScrollPane.setMinimumSize(dimension);
        selectScrollPane.setPreferredSize(dimension);
        JScrollPane availableScrollPane = new JScrollPane(this.availableList);
        availableScrollPane.setMinimumSize(dimension);
        availableScrollPane.setPreferredSize(dimension);
        this.add((Component)new JLabel("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)selectScrollPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getAddDeletePanel(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)availableScrollPane, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getAddDeletePanel() {
        JButton addButton = new JButton(ClientUtils.getIcon("arrow_left"));
        addButton.addActionListener(e -> this.moveIdTitle(this.availableModel, this.selectModel, this.availableList.getSelectedValuesList()));
        JButton deleteButton = new JButton(ClientUtils.getIcon("arrow_right"));
        deleteButton.addActionListener(e -> this.moveIdTitle(this.selectModel, this.availableModel, this.selectList.getSelectedValuesList()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)deleteButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private void moveIdTitle(DefaultListModel<T> fromModel, DefaultListModel<T> toModel, List<T> selectList) {
        for (IdTitle idTitle : selectList) {
            boolean add = false;
            for (int index = 0; index < toModel.getSize(); ++index) {
                IdTitle toIdTitle = (IdTitle)toModel.getElementAt(index);
                if (toIdTitle.getTitle().compareTo(idTitle.getTitle()) <= 0) continue;
                toModel.add(index, idTitle);
                add = true;
                break;
            }
            if (!add) {
                toModel.addElement(idTitle);
            }
            fromModel.removeElement(idTitle);
        }
    }

    public void setSelect(String zone) {
        this.selectModel.removeAllElements();
        List<Integer> zones = Utils.toIntegerList(zone);
        for (IdTitle idTitle : this.items) {
            if (!zones.contains(idTitle.getId())) continue;
            this.selectModel.addElement(idTitle);
            this.availableModel.removeElement(idTitle);
        }
    }

    public String getSelect() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Enumeration<T> enumeration = this.selectModel.elements();
        while (enumeration.hasMoreElements()) {
            ids.add(((IdTitle)enumeration.nextElement()).getId());
        }
        return Utils.toString(ids);
    }
}

