/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.bean;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.script.common.bean.GlobalScriptLog;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class GlobalScriptLogDao
extends AbstractDao<GlobalScriptLog> {
    public static final String prefixNameTable = "log_gscript_process";

    public GlobalScriptLogDao(Connection con, String tableName) {
        super(con, -1, tableName);
    }

    public List<String> getScriptLogTitleList(Period period) throws BGException {
        ArrayList<String> result = new ArrayList<String>();
        if (ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
            String query = "SELECT DISTINCT title FROM " + this.tableName + " WHERE TO_DAYS(time)>=TO_DAYS('" + TimeUtils.formatSQLDate(period.getDateFrom());
            query = query + (String)(period.getDateTo() != null ? "') AND TO_DAYS(time)<=TO_DAYS('" + TimeUtils.formatSQLDate(period.getDateTo()) : "");
            query = query + "') ORDER BY time ";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new BGException(e.getMessage(), e);
            }
        }
        return result;
    }

    public List<GlobalScriptLog> getScriptLogList(Period period, String title, Page page) throws BGException {
        ArrayList<GlobalScriptLog> result;
        block15: {
            result = new ArrayList<GlobalScriptLog>();
            if (period == null || period.getDateFrom() == null) {
                return result;
            }
            try {
                if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) break block15;
                String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE TO_DAYS(time)>=TO_DAYS('" + TimeUtils.formatSQLDate(period.getDateFrom()) + "')";
                if (period.getDateTo() != null) {
                    query = query + " AND TO_DAYS(time)<=TO_DAYS('" + TimeUtils.formatSQLDate(period.getDateTo()) + "')";
                }
                if (title != null) {
                    query = query + " AND title=?";
                }
                query = query + " ORDER BY time DESC ";
                if (page != null && page.getPageSize() > 0) {
                    query = query + page.sqlLimit();
                }
                try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                    if (title != null) {
                        ps.setString(1, title);
                    }
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        result.add(this.getFromRS(rs));
                    }
                }
                if (page != null && page.getPageSize() > 0) {
                    page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
                }
            }
            catch (Exception e) {
                throw new BGException(e.getMessage(), e);
            }
        }
        return result;
    }

    public String writeLog(String functionName, String out, String err, String ex, Calendar finishTime) throws BGException {
        this.checkTable(this.tableName);
        GregorianCalendar now = new GregorianCalendar();
        StringBuilder report = new StringBuilder(out.length() + err.length() + ex.length() + 200);
        report.append("GENERATE_TIME: " + TimeUtils.format(finishTime, "dd.MM.yy HH:mm:ss"));
        report.append("\nEXECUTION_STOP_TIME: " + TimeUtils.format((Calendar)now, "dd.MM.yy HH:mm:ss"));
        report.append("\nPROCESS_TIME: " + (now.getTimeInMillis() - finishTime.getTimeInMillis()));
        report.append("\n\nOUT:\n" + out);
        if (Utils.notBlankString(err)) {
            report.append("\n\nERROR:\n" + err);
        }
        if (Utils.notBlankString(ex)) {
            report.append("\n\nEXCEPTIONS:\n" + ex);
        }
        if (Utils.notBlankString(ex) || Utils.notBlankString(err)) {
            String key = "bgbs.global.script.error";
            long time = System.currentTimeMillis();
            AlarmErrorMessage message = new AlarmErrorMessage("bgbs.global.script.error", "\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0433\u043e BGBS \u0441\u043a\u0440\u0438\u043f\u0442\u0430", report.toString());
            if (AlarmSender.needAlarmSend((String)"bgbs.global.script.error", (long)time, (long)0L)) {
                AlarmSender.sendAlarm((AlarmErrorMessage)message, (long)time);
            }
        }
        try {
            if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
                String query = "CREATE TABLE " + this.tableName + "( `id` int(11) NOT NULL AUTO_INCREMENT, time DATETIME NOT NULL,  title VARCHAR(250) NOT NULL,  data LONGTEXT NOT NULL, PRIMARY KEY (`id`) )";
                Setup.getSetup().checkAndCreatePeriodicTableName(this.con, this.tableName, query);
            }
            try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (time, title, data) VALUES (?, ?, ?)");){
                ps.setTimestamp(1, TimeUtils.convertCalendarToTimestamp(now));
                ps.setString(2, functionName);
                ps.setString(3, report.toString());
                ps.executeUpdate();
            }
        }
        catch (Exception e) {
            throw new BGException(e.getMessage(), e);
        }
        return report.toString();
    }

    @Override
    protected GlobalScriptLog getFromRS(ResultSet rs) throws SQLException, BGException {
        GlobalScriptLog result = new GlobalScriptLog();
        result.setDate(TimeUtils.convertTimestampToDate(rs.getTimestamp("time")));
        result.setTitle(rs.getString("title"));
        result.setData(rs.getString("data"));
        return result;
    }

    private void checkTable(String nt) throws BGException {
        if (nt.indexOf(prefixNameTable) == -1) {
            throw new BGException("\u041d\u0435 \u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b!");
        }
    }

    @Override
    protected void updateImpl(GlobalScriptLog b) throws BGException, SQLException {
    }
}

