/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.directory.address;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.CalendarDialog;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;

public class AddressEditorPanelBase
extends BGPanel {
    private static final int FONT_SIZE = 14;
    private static final String PARAM_TYPE_INT = "int";
    private static final String PARAM_TYPE_DATE = "date";
    private static final String KEY_ID = "id";
    private static final String KEY_TYPE = "type";
    private static final String KEY_TITLE = "title";
    private static final String KEY_VALUE = "value";
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private JTextField title = new JTextField();
    private JLabel countryJLabel = new JLabel();
    private JLabel cityLabel = new JLabel();
    private JLabel streetLabel = new JLabel();
    private int countryId = -1;
    private int cityId = -1;
    private int itemId = -1;
    private BGComboBox<ComboBoxItem> paramComboBox;
    private ParamTableModel paramTableModel = new ParamTableModel(ParamTableModel.class.getName());
    private BGUTable paramTable = new BGUTable(this.paramTableModel);

    public AddressEditorPanelBase() {
        this.jbInit();
        this.paramTable.setRowHeight(22);
        this.paramTable.setFont(new Font("Dialog", 0, 14));
        this.paramTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                AddressEditorPanelBase.this.saveParam();
            }
        });
        this.paramTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Element row;
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    return;
                }
                if (mouseEvent.getClickCount() == 2 && (row = (Element)AddressEditorPanelBase.this.paramTableModel.getSelectedRow()) != null && AddressEditorPanelBase.PARAM_TYPE_DATE.equals(row.getAttribute(AddressEditorPanelBase.KEY_TYPE))) {
                    AddressEditorPanelBase.this.openDateEditor(row);
                }
            }
        });
    }

    private void openDateEditor(Element row) {
        String dateStr = row.getAttribute(KEY_VALUE);
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        GregorianCalendar dt = new GregorianCalendar();
        try {
            dt.setTime(TimeUtils.parseDate(dateStr, format));
        }
        catch (Exception exception) {
            // empty catch block
        }
        CalendarDialog calendar = new CalendarDialog();
        calendar.setCalendar(dt);
        calendar.setModal(true);
        if (calendar.showDialog().equals("ok")) {
            Calendar time = calendar.getCalendar();
            row.setAttribute(KEY_VALUE, time == null ? "" : format.format(time.getTime()));
            this.saveParam();
        }
        calendar.dispose();
    }

    private void jbInit() {
        JPanel labelPanel = new JPanel(new GridBagLayout());
        labelPanel.add((Component)this.countryJLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        labelPanel.add((Component)this.cityLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        labelPanel.add((Component)this.streetLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel titlePanel = new JPanel(new GridBagLayout());
        titlePanel.add((Component)labelPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        titlePanel.add((Component)new JLabel(this.getTitleLabelText()), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        titlePanel.add((Component)this.title, new GridBagConstraints(1, 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.paramComboBox = new BGComboBox();
        JButton addParamButton = new JButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c");
        JButton delParamButton = new JButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        addParamButton.addActionListener(e -> this.addParameter());
        delParamButton.addActionListener(e -> this.deleteParam());
        this.title.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                AddressEditorPanelBase.this.titleKeyReleased(event);
            }
        });
        this.paramTable.setSelectionMode(0);
        JPanel editor = new JPanel(new GridBagLayout());
        editor.add((Component)titlePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel extPanel = this.getExtraPanel();
        if (extPanel != null) {
            editor.add((Component)extPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        } else {
            editor.add(Box.createGlue(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        JPanel addParamPanel = new JPanel(new GridBagLayout());
        addParamPanel.add(this.paramComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        addParamPanel.add((Component)addParamButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        addParamPanel.add((Component)delParamButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        JPanel params = new JPanel(new GridBagLayout());
        params.add((Component)addParamPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        params.add((Component)new JScrollPane(this.paramTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JTabbedPane tabbedPanel = new JTabbedPane();
        tabbedPanel.add((Component)editor, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440");
        tabbedPanel.add((Component)params, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        this.setLayout(new GridBagLayout());
        this.add((Component)tabbedPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction(this.getLoadAction());
        request.setAttribute(KEY_ID, this.id);
        if (!this.getLoadAction().equals("HouseEditor")) {
            this.setExtraParams(request);
        } else {
            request.setAttribute("addressType", "house");
        }
        Document doc = this.getDocument(request);
        Element el = XMLUtils.selectElement(doc, "//data/param");
        this.title.setText(el.getAttribute(KEY_TITLE));
        this.getExtraParams(doc);
        Element params = XMLUtils.selectElement(doc, "//data/params");
        ClientUtils.buildComboBox(this.paramComboBox, params, null);
        this.setTableData(doc);
    }

    private void deleteParam() {
        Element element = (Element)this.paramTableModel.getSelectedRow();
        if (element == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
            return;
        }
        if (ClientUtils.confirmDelete(element.getAttribute(KEY_TITLE))) {
            String paramId = element.getAttribute(KEY_ID);
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("DeleteAddressExtraParams");
            request.setAttribute("key", paramId);
            request.setAttribute("recordId", this.id);
            this.setExtraParams(request);
            Document doc = this.getDocument(request);
            ClientUtils.checkStatus(doc);
            this.setTableData(doc);
        }
    }

    private void addParameter() {
        ComboBoxItem item = this.paramComboBox.getSelectedItem();
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("UpdateAddressExtraParams");
        request.setAttribute("key", item.getObject());
        request.setAttribute("recordId", this.id);
        request.setAttribute("flag", "new");
        this.setExtraParams(request);
        Document doc = this.getDocument(request);
        ClientUtils.checkStatus(doc);
        this.setTableData(doc);
    }

    private void setTableData(Document doc) {
        ArrayList<Element> data = new ArrayList<Element>();
        for (Element element : XMLUtils.selectElements(doc, "//table/data/row")) {
            data.add(element);
        }
        this.paramTableModel.setData(data);
    }

    private void saveParam() {
        Element element = (Element)this.paramTableModel.getSelectedRow();
        if (element != null) {
            String key = element.getAttribute(KEY_ID);
            String type = element.getAttribute(KEY_TYPE);
            String value = element.getAttribute(KEY_VALUE);
            if (PARAM_TYPE_INT.equals(type) && Utils.notEmptyString(value) && !Pattern.matches("\\d+", value)) {
                ClientUtils.showErrorMessageDialog("\u0426\u0435\u043b\u043e\u0447\u0438\u0441\u043b\u0435\u043d\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("UpdateAddressExtraParams");
            request.setAttribute("key", key);
            request.setAttribute("recordId", this.id);
            request.setAttribute("flag", "save");
            request.setAttribute(KEY_VALUE, value);
            this.setExtraParams(request);
            ClientUtils.checkStatus(this.getDocument(request));
        }
    }

    public boolean stopEdit() {
        if (this.title.getText().trim().length() == 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
            return false;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction(this.getSaveAction());
        request.setAttribute("flag", "new");
        if (this.id != null) {
            request.setAttribute(KEY_ID, this.id);
        } else {
            request.setAttribute(KEY_ID, "new");
        }
        request.setAttribute(KEY_TITLE, this.title.getText());
        if (this.countryId != -1) {
            request.setAttribute("countryId", this.countryId);
        }
        if (this.cityId != -1) {
            request.setAttribute("cityid", this.cityId);
        }
        if (this.itemId != -1) {
            request.setAttribute("streetid", this.itemId);
        }
        this.setExtraParams(request);
        Document doc = this.getDocument(request);
        return ClientUtils.checkStatus(doc);
    }

    protected JPanel getExtraPanel() {
        return null;
    }

    protected String getLoadAction() {
        return "";
    }

    protected void titleKeyReleased(KeyEvent event) {
    }

    protected void getExtraParams(Document doc) {
    }

    protected void setExtraParams(Request req) {
    }

    protected String getSaveAction() {
        return "";
    }

    protected String getTitleLabelText() {
        return "\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435:";
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public String getTitle() {
        return this.title.getText().trim();
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setCountryLable(String str) {
        this.countryJLabel.setText(str);
    }

    public void setCityLable(String str) {
        this.cityLabel.setText(str);
    }

    public void setStreetLable(String str) {
        this.streetLabel.setText(str);
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public void setCountryId(int countryId) {
        this.countryId = countryId;
    }

    public void setCityId(int cityId) {
        this.cityId = cityId;
    }

    public int getCityId() {
        return this.cityId;
    }

    class ParamTableModel
    extends BGTableModel<Element> {
        public ParamTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("ID", 100, 150, 200, AddressEditorPanelBase.KEY_ID, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f", 80, 80, 80, AddressEditorPanelBase.KEY_TYPE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 100, 200, 300, AddressEditorPanelBase.KEY_TITLE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 0, -1, -1, AddressEditorPanelBase.KEY_VALUE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            boolean result = super.isCellEditable(rowIndex, columnIndex);
            String identifier = this.getIdentifier(columnIndex);
            if (AddressEditorPanelBase.KEY_VALUE.equals(identifier)) {
                Element rowValue = (Element)this.getRows().get(this.table.getRowSorter().convertRowIndexToModel(rowIndex));
                return rowValue == null || !AddressEditorPanelBase.PARAM_TYPE_DATE.equals(rowValue.getAttribute(AddressEditorPanelBase.KEY_TYPE));
            }
            return result;
        }
    }
}

