/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.BGUTableColumnVisibility;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.treetable.AbstractBGUTreeTable;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.model.TreeNode;

public class BGUTreeTable
extends AbstractBGUTreeTable<ClientContext> {
    public <N extends TreeNode<N>> BGUTreeTable(BGTreeTableModel<N> model) {
        super(model);
    }

    @Override
    protected void initHeaderMenu() {
        JPopupMenu popupMenu = this.tableHeaderButton.getComponentPopupMenu();
        if (popupMenu == null) {
            popupMenu = new JPopupMenu();
            this.tableHeaderButton.setComponentPopupMenu(popupMenu);
        }
        final JCheckBoxMenuItem resizeMenu = new JCheckBoxMenuItem(new BGUAction("table.columns.resize", "\u0420\u0430\u0441\u0442\u044f\u0433\u0438\u0432\u0430\u0442\u044c"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BGUTreeTable.this.getAutoResizeMode() == 0) {
                    BGUTreeTable.this.setAutoResizeMode(3);
                } else {
                    BGUTreeTable.this.setAutoResizeMode(0);
                }
            }
        });
        resizeMenu.setSelected(this.getAutoResizeMode() != 0);
        this.tableHeaderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                resizeMenu.setSelected(BGUTreeTable.this.getAutoResizeMode() != 0);
                BGUTreeTable.this.tableHeaderButton.getComponentPopupMenu().show(BGUTreeTable.this.tableHeaderButton, 0, BGUTreeTable.this.tableHeaderButton.getHeight());
            }
        });
        popupMenu.add(resizeMenu);
        popupMenu.add(new JMenuItem(new BGUAction("table.columns.reset", "\u0417\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGUTable.saveColumnProperties(BGUTreeTable.this, false);
            }
        }));
        popupMenu.add(new JMenuItem(new BGUAction("table.columns.reset", "\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u0441\u0442\u043e\u043b\u0431\u0446\u043e\u0432..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new BGUTableColumnVisibility(BGUTreeTable.this, (Window)SwingUtilities.getRoot(BGUTreeTable.this));
            }
        }));
        popupMenu.add(new JMenuItem(new BGUAction("table.columns.reset", "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGUTable.resetColumnProperties(BGUTreeTable.this);
            }
        }));
        popupMenu.add(new JMenuItem(new BGUAction("table.columns.reset", "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGUTable.saveColumnProperties(BGUTreeTable.this, true);
            }
        }));
    }

    @Override
    protected final ClientContext innerGetContext(Container parent) {
        if (parent instanceof BGPanel) {
            return ((BGPanel)parent).getContext();
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        BGUTable.loadColumnProperties(this);
    }

    private <D extends TreeNode<D>> int count(D root, int max) {
        int count = 0;
        List<D> children = root.getChildren();
        if (children != null) {
            int size = children.size();
            if ((count += size) >= max) {
                return count;
            }
            for (int i = 0; i < size; ++i) {
                count += this.count((TreeNode)children.get(i), max);
            }
        }
        return count;
    }

    public void expandAfterUpdate() {
        BGTreeTableModel model = (BGTreeTableModel)this.getModel();
        int count = this.count((TreeNode)model.getRoot(), 25);
        if (count <= 25) {
            this.expand();
        } else {
            int moduleId = ((ClientContext)this.getContext()).getModuleId();
            ClientSetup clientSetup = ClientSetup.getInstance();
            boolean isNeedExpand = (moduleId > 0 ? clientSetup.getModuleParameterPreferences(moduleId) : clientSetup).getBoolean("client.gui.expand.device.tree", false);
            if (isNeedExpand) {
                int depth = (moduleId > 0 ? clientSetup.getModuleParameterPreferences(moduleId) : clientSetup).getInt("client.gui.expand.device.tree.depth", 2);
                this.expand(depth);
            }
        }
    }
}

