/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGSplitPane;
import ru.bitel.bgbilling.client.common.BGToolBar;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUAction;

public class BGFilterPane
extends JPanel {
    private BGToolBar toolBar = new BGToolBar(true, true);
    private CardLayout cardLayout;
    private JPanel cardPanel;
    private BGSplitPane splitPane;
    private JComponent filterComponent;
    private JComponent dataComponent;

    public BGFilterPane(boolean cardLayout) {
        super(new BorderLayout());
        this.toolBar.setOrientation(0);
        this.toolBar.add(new BGUAction("showFilter", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440", (Icon)ClientUtils.getIcon("fugue/funnel--arrow")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGFilterPane.this.toggle();
            }
        });
        this.toolBar.setBorder(cardLayout ? BorderFactory.createEmptyBorder(0, 0, 0, 3) : BorderFactory.createEmptyBorder(3, 3, 0, 0));
        this.add((Component)this.toolBar, "North");
        if (cardLayout) {
            this.cardLayout = new CardLayout();
            this.cardPanel = new JPanel(this.cardLayout);
            this.add((Component)this.cardPanel, "Center");
        } else {
            this.splitPane = new BGSplitPane();
        }
    }

    private void toggle() {
        if (this.cardLayout != null) {
            if (!this.filterComponent.isShowing()) {
                this.cardLayout.show(this.cardPanel, "filter");
            } else {
                this.cardLayout.show(this.cardPanel, "data");
            }
        } else if (!this.filterComponent.isShowing()) {
            this.remove(this.dataComponent);
            this.splitPane.setRightComponent(this.dataComponent);
            this.add((Component)this.splitPane, "Center");
            this.validate();
        } else {
            this.remove(this.splitPane);
            this.splitPane.remove(this.dataComponent);
            BGSwingUtilites.wrapEmptyBorder(this.dataComponent, false);
            this.add((Component)this.dataComponent, "Center");
            this.validate();
        }
    }

    public void setFilterComponent(JComponent filter) {
        if (filter instanceof BGUPanel) {
            BGUPanel panel = (BGUPanel)filter;
            panel.build();
            Action find = panel.getActionMap().get("find");
            Action clear = panel.getActionMap().get("clear");
            BGButton findButton = new BGButton(find);
            if (this.cardLayout != null) {
                findButton.addActionListener(e -> this.toggle());
            }
            JPanel leftBottomPanel = new JPanel(new GridBagLayout());
            leftBottomPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
            leftBottomPanel.add((Component)findButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            leftBottomPanel.add((Component)new BGButton(clear), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            JPanel filterPanel = new JPanel(new BorderLayout());
            filterPanel.add((Component)filter, "Center");
            filterPanel.add((Component)leftBottomPanel, "South");
            filter = filterPanel;
        }
        this.filterComponent = filter;
        if (this.cardLayout != null) {
            this.cardPanel.add((Component)filter, "filter");
            this.cardLayout.show(this.cardPanel, "data");
        } else {
            this.filterComponent = BGSwingUtilites.wrapEmptyBorder(this.filterComponent);
            this.splitPane.setLeftComponent(this.filterComponent);
        }
    }

    public void setDataComponent(JComponent data) {
        if (this.cardLayout != null) {
            this.cardPanel.add((Component)data, "data");
            this.cardLayout.show(this.cardPanel, "data");
        } else {
            data = BGSwingUtilites.wrapEmptyBorder(data, false);
            this.add((Component)data, "Center");
        }
        this.dataComponent = data;
    }
}

