/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import java.awt.Toolkit;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntPlainDocument
extends PlainDocument {
    private long value = 0L;
    private long minValue = 0L;
    private long maxValue = 922372036854775807L;
    private int radix = 10;

    public IntPlainDocument() {
    }

    public IntPlainDocument(long minValue, long maxValue, int radix) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.radix = radix;
    }

    public void setMinValue(long value) {
        this.minValue = value;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    public void setMaxValue(long value) {
        this.maxValue = value;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setRadix(int radix) {
        this.radix = radix;
    }

    public int getRadix() {
        return this.radix;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        StringBuffer oldValue = new StringBuffer(this.getText(0, this.getLength()));
        String newValue = oldValue.insert(offset, str).toString();
        if ("-".equals(newValue) && this.minValue < 0L) {
            super.insertString(offset, str, a);
        } else {
            try {
                long l = Long.parseLong(newValue, this.radix);
                if (l >= this.minValue && l <= this.maxValue) {
                    super.insertString(offset, str, a);
                    this.value = l;
                }
            }
            catch (NumberFormatException ex) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        int offset = chng.getOffset();
        int length = chng.getLength();
        StringBuffer oldValue = null;
        try {
            oldValue = new StringBuffer(this.getText(0, this.getLength()));
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        String newValue = oldValue.delete(offset, offset + length).toString();
        this.value = 0L;
        try {
            this.value = Long.parseLong(newValue, this.radix);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.removeUpdate(chng);
    }
}

