/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.clusterdb;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.admin.clusterdb.DBEditor;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class DBManager
extends BGPanel {
    private String clusterdbID;
    private BGTable table = new BGTable();
    private DBEditor editor = new DBEditor();

    public DBManager() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "clusterdb");
        this.editor.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.editor.setBorder(new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DBManager.this.editItem();
                }
            }
        });
        this.editor.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                DBManager.this.setData();
            }
        });
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ClusterDBList");
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.table.updateData(XMLUtils.getNode(doc, "table"));
        }
    }

    @Override
    public void newItem() {
        this.clusterdbID = "0";
        this.startEdit();
    }

    @Override
    public void editItem() {
        this.clusterdbID = ClientUtils.getRowId(this.table, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 <\u043e\u0431\u044a\u0435\u043a\u0442> \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", null);
        if (this.clusterdbID == null) {
            return;
        }
        this.startEdit();
    }

    @Override
    public void deleteItem() {
        String id = ClientUtils.getRowId(this.table, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 <\u043e\u0431\u044a\u0435\u043a\u0442> \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", null);
        if (id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c <\u043e\u0431\u044a\u0435\u043a\u0442>?", "\u0423\u0434\u0430\u0435\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ClusterDBDelete");
            request.setAttribute("id", id);
            if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                this.setData();
            }
        }
    }

    private void startEdit() {
        this.editor.setId(this.clusterdbID);
        this.editor.setData();
        this.editor.setVisible(true);
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.editor.init(module, mid);
    }
}

