/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttr;

public class EntitySpecAttrDao
extends AbstractIdDao<EntitySpecAttr>
implements Directory<EntitySpecAttr> {
    public EntitySpecAttrDao(Connection con) {
        super(con, 0, "entity_spec_attr");
    }

    protected EntitySpecAttr getFromRS(ResultSet rs) throws SQLException {
        EntitySpecAttr result = new EntitySpecAttr();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setType(rs.getInt("type"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    protected void updateImpl(EntitySpecAttr s) throws BGException, SQLException {
        PreparedStatement ps;
        if (Utils.isBlankString((String)s.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        if (s.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title, comment, type) VALUES (?,?,?)", 1);
            ps.setInt(3, s.getType());
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=?, comment=? WHERE id=?");
            ps.setInt(3, s.getId());
        }
        ps.setString(1, s.getTitle());
        ps.setString(2, s.getComment());
        ps.executeUpdate();
        if (s.getId() <= 0) {
            s.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    @Override
    public List<EntitySpecAttr> list() throws BGException {
        return super.list(null, null, new Object[0]);
    }

    public Map<Integer, List<EntitySpecAttr>> map() throws BGException {
        HashMap<Integer, List<EntitySpecAttr>> result = new HashMap<Integer, List<EntitySpecAttr>>();
        for (EntitySpecAttr sa : this.list()) {
            ArrayList<EntitySpecAttr> list = (ArrayList<EntitySpecAttr>)result.get(sa.getType());
            if (list == null) {
                list = new ArrayList<EntitySpecAttr>();
                result.put(sa.getType(), list);
            }
            list.add(sa);
        }
        return result;
    }

    public List<EntitySpecAttr> listByType(int type) throws BGException {
        return super.list("type=?", null, new Object[]{type});
    }

    public List<EntitySpecAttr> listByEntitySpec(int id) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT attr.* FROM entity_spec_attr_link as link  LEFT JOIN " + this.tableName + " as attr ON link.entitySpecAttrId=attr.id WHERE link.entitySpecId=? ORDER BY link.pos");
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            return this.getListFromRS(rs);
        }
        catch (SQLException e) {
            this.processException(e);
            return Collections.emptyList();
        }
    }

    @Override
    void update(EntitySpec s) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM entity_spec_attr_link WHERE entitySpecId=?");
            ps.setInt(1, s.getId());
            ps.executeUpdate();
            ps.close();
            ps = this.con.prepareStatement("INSERT INTO entity_spec_attr_link (entitySpecId, entitySpecAttrId, pos) VALUES (?, ?, ?)");
            int pos = 0;
            if (s.getAttributeList() != null) {
                for (EntitySpecAttr a : s.getAttributeList()) {
                    ps.setInt(1, s.getId());
                    ps.setInt(2, a.getId());
                    ps.setInt(3, pos++);
                    ps.addBatch();
                }
            }
            ps.executeBatch();
            ps.close();
        }
        catch (SQLException e) {
            this.processException(e);
        }
    }

    @Override
    public EntitySpecAttr get(String title) throws BGException {
        return (EntitySpecAttr)this.get("title=?", new Object[]{title});
    }
}

