/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.db;

import bitel.billing.server.util.db.ColumnValue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class TableCopier {
    private static final Logger log = LogManager.getLogger();
    private Connection con;

    public TableCopier(Connection con) {
        this.con = con;
    }

    public int copyRecord(String tableName, String where, Map<String, ColumnValue> valuesPairs) throws SQLException {
        int result = 0;
        StringBuilder insertQuery = new StringBuilder(200);
        try {
            insertQuery.append("INSERT INTO ");
            insertQuery.append(tableName);
            insertQuery.append(" ( ");
            StringBuilder insertColumns = new StringBuilder(100);
            StringBuilder selectColumns = new StringBuilder(100);
            String query = "SELECT * FROM " + tableName + " LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            int size = meta.getColumnCount();
            for (int i = 1; i <= size; ++i) {
                ColumnValue value;
                String name = meta.getColumnName(i);
                if (name.equals("id") && !valuesPairs.containsKey("id")) continue;
                if (insertColumns.length() != 0) {
                    insertColumns.append(",");
                }
                insertColumns.append(name);
                if (selectColumns.length() != 0) {
                    selectColumns.append(",");
                }
                if ((value = valuesPairs.get(name)) != null) {
                    selectColumns.append(value.getInsertString());
                    continue;
                }
                selectColumns.append(name);
            }
            ps.close();
            insertQuery.append((CharSequence)insertColumns);
            insertQuery.append(" ) SELECT ");
            insertQuery.append((CharSequence)selectColumns);
            insertQuery.append(" FROM ");
            insertQuery.append(tableName);
            insertQuery.append(" WHERE ");
            insertQuery.append(where);
            PreparedStatement psInsert = this.con.prepareStatement(insertQuery.toString(), 1);
            psInsert.executeUpdate();
            result = ServerUtils.lastInsertId(psInsert);
            psInsert.close();
        }
        catch (SQLException e) {
            log.error(e.getMessage() + " [" + insertQuery.toString() + "]");
            throw e;
        }
        return result;
    }

    public void updateColumn(String table, String column, String value, String where) throws SQLException {
        StringBuilder query = new StringBuilder(100);
        query.append("UPDATE ");
        query.append(table);
        query.append(" SET ");
        query.append(column);
        query.append("='");
        query.append(value);
        query.append("' WHERE ");
        query.append(where);
        PreparedStatement psUpdate = this.con.prepareStatement(query.toString());
        psUpdate.executeUpdate();
        psUpdate.close();
    }

    public void updateColumns(String table, Map<String, ColumnValue> valuesPairs, String where) throws SQLException {
        StringBuilder query = new StringBuilder(100);
        query.append("UPDATE ");
        query.append(table);
        query.append(" SET ");
        for (Map.Entry<String, ColumnValue> e : valuesPairs.entrySet()) {
            query.append(e.getKey());
            query.append("=");
            query.append(e.getValue().getInsertString());
            query.append(',');
        }
        if (valuesPairs.size() > 0) {
            query.setLength(query.length() - 1);
        }
        query.append(" WHERE ");
        query.append(where);
        PreparedStatement psUpdate = this.con.prepareStatement(query.toString());
        psUpdate.executeUpdate();
        psUpdate.close();
    }
}

