/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

public final class WebRequestCounter {
    private static final String TABLE_NAME = "web_request_count";
    public static final int LIMIT_BY_CONFIG = -1;
    public static final int LIMIT_UNLIMIT = 0;
    private Setup setup;
    private int maxRequestCount = 0;

    public WebRequestCounter(Setup setup) {
        this.setup = setup;
        this.maxRequestCount = setup.getInt("web.max.day.request.count", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRequestCount(int cid) {
        boolean result = true;
        WebRequestCounter webRequestCounter = this;
        synchronized (webRequestCounter) {
            Connection con = this.setup.getDBConnectionFromPool();
            try {
                int requestCount;
                PreparedStatement getWebRequestLimitPS = con.prepareStatement("SELECT lim FROM web_request_limit WHERE cid=?");
                PreparedStatement getRequestCountPS = con.prepareStatement("SELECT date, count FROM web_request_count WHERE cid=?");
                PreparedStatement updateRequestCountPS = con.prepareStatement("UPDATE web_request_count SET date=?, count=? WHERE cid=?");
                PreparedStatement insertRequestCountPS = con.prepareStatement("INSERT INTO web_request_count (date, count, cid) VALUES (?, ?, ?)", 2);
                getWebRequestLimitPS.setInt(1, cid);
                ResultSet rs = getWebRequestLimitPS.executeQuery();
                if (rs.next()) {
                    requestCount = rs.getInt(1);
                    if (requestCount < 0) {
                        requestCount = this.maxRequestCount;
                    }
                } else {
                    requestCount = this.maxRequestCount;
                }
                rs.close();
                if (requestCount == 0) {
                    result = true;
                } else {
                    int count;
                    boolean recordIs;
                    GregorianCalendar date = new GregorianCalendar();
                    getRequestCountPS.setInt(1, cid);
                    rs = getRequestCountPS.executeQuery();
                    if (rs.next()) {
                        recordIs = true;
                        Calendar lastDate = TimeUtils.convertDateToCalendar((Date)rs.getDate(1));
                        int lastCount = rs.getInt(2);
                        count = TimeUtils.dateEqual((Calendar)date, (Calendar)lastDate) ? lastCount + 1 : 1;
                    } else {
                        recordIs = false;
                        count = 0;
                    }
                    rs.close();
                    boolean bl = result = count <= requestCount;
                    if (result) {
                        PreparedStatement ps = recordIs ? updateRequestCountPS : insertRequestCountPS;
                        ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)date));
                        ps.setInt(2, count);
                        ps.setInt(3, cid);
                        ps.executeUpdate();
                    }
                }
                getWebRequestLimitPS.close();
                getRequestCountPS.close();
                updateRequestCountPS.close();
                insertRequestCountPS.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ServerUtils.closeConnection(con);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRequestCount2(int cid) {
        boolean result = true;
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            int requestCount;
            PreparedStatement ps = con.prepareStatement("SELECT lim FROM web_request_limit WHERE cid=?");
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                requestCount = rs.getInt(1);
                if (requestCount < 0) {
                    requestCount = this.maxRequestCount;
                }
            } else {
                requestCount = this.maxRequestCount;
            }
            rs.close();
            ps.close();
            if (requestCount == 0) {
                result = true;
            } else {
                int count;
                boolean recordIs;
                GregorianCalendar date = new GregorianCalendar();
                ps = con.prepareStatement("SELECT date, count FROM web_request_count WHERE cid=?");
                ps.setInt(1, cid);
                rs = ps.executeQuery();
                if (rs.next()) {
                    recordIs = true;
                    Calendar lastDate = TimeUtils.convertDateToCalendar((Date)rs.getDate(1));
                    int lastCount = rs.getInt(2);
                    count = TimeUtils.dateEqual((Calendar)date, (Calendar)lastDate) ? lastCount + 1 : 1;
                } else {
                    recordIs = false;
                    count = 0;
                }
                rs.close();
                ps.close();
                boolean bl = result = count <= requestCount;
                if (result) {
                    ps = recordIs ? con.prepareStatement("UPDATE web_request_count SET date=?, count=? WHERE cid=?") : con.prepareStatement("INSERT INTO web_request_count (date, count, cid) VALUES (?, ?, ?)", 2);
                    ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)date));
                    ps.setInt(2, count);
                    ps.setInt(3, cid);
                    ps.executeUpdate();
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestLimit(int cid) {
        int result = -1;
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            PreparedStatement ps = con.prepareStatement("SELECT lim FROM web_request_limit WHERE cid=?");
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRequestCount(int cid, int count) {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            PreparedStatement ps = con.prepareStatement("UPDATE web_request_limit SET lim=? WHERE cid=?");
            ps.setInt(1, count);
            ps.setInt(2, cid);
            if (ps.executeUpdate() <= 0) {
                ps.close();
                ps = con.prepareStatement("INSERT INTO web_request_limit ( cid, lim ) VALUES (?,?)");
                ps.setInt(1, cid);
                ps.setInt(2, count);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock(int cid) {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            PreparedStatement ps = con.prepareStatement("UPDATE web_request_count SET count=0 WHERE cid=?");
            ps.setInt(1, cid);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestCount(int cid) {
        int count = 0;
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            PreparedStatement ps = con.prepareStatement("SELECT date, count FROM web_request_count WHERE cid=?");
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                Calendar lastDate = TimeUtils.convertDateToCalendar((Date)rs.getDate(1));
                int lastCount = rs.getInt(2);
                if (TimeUtils.dateEqual((Calendar)new GregorianCalendar(), (Calendar)lastDate)) {
                    count = lastCount;
                }
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        return count;
    }

    public int getRequestLimit() {
        return this.maxRequestCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zeroRuestCount(int cid) {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            PreparedStatement getRequestCountPS = con.prepareStatement("SELECT date, count FROM web_request_count WHERE cid=?");
            PreparedStatement updateRequestCountPS = con.prepareStatement("UPDATE web_request_count SET date=?, count=? WHERE cid=?");
            PreparedStatement insertRequestCountPS = con.prepareStatement("INSERT INTO web_request_count (date, count, cid) VALUES (?, ?, ?)", 2);
            PreparedStatement ps = getRequestCountPS;
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            ps = rs.next() ? updateRequestCountPS : insertRequestCountPS;
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)new GregorianCalendar()));
            ps.setInt(2, 0);
            ps.setInt(3, cid);
            ps.executeUpdate();
            getRequestCountPS.close();
            updateRequestCountPS.close();
            insertRequestCountPS.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }
}

