/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.admin.resource.IPResourceSelectPanel;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.AdressPanel;
import ru.bitel.bgbilling.modules.ipn.client.RangeIfacePanel;
import ru.bitel.bgbilling.modules.ipn.client.ServiceLinkEditor;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGControlPanelTextArea;

public class AddressEditor
extends ServicePanel {
    private String module = "ipn";
    protected String[] oldValue = new String[4];
    protected String sid;
    protected String direct;
    private BGComboBox<ComboBoxItem> object_CB = new BGComboBox();
    private JCheckBox showAllObj = new JCheckBox("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0441\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b");
    private BGControlPanelTextArea comment = new BGControlPanelTextArea();
    private BGControlPanelPeriod periodPanel = new BGControlPanelPeriod();
    private IntTextField port1 = new IntTextField();
    private IntTextField port2 = new IntTextField();
    private RangeIfacePanel ifacePanel = new RangeIfacePanel();
    private BGComboBox<ComboBoxItem> serviceLinkPlanCb = new BGComboBox();
    private BGTable serviceLinkTable = new BGTable();
    private ServiceLinkEditor serviceLinkEditor = new ServiceLinkEditor();
    private int currentEditRow = 0;
    protected IPResourceSelectPanel resourceSelectPanel = new IPResourceSelectPanel();
    private CardLayout editResourceLayout = null;
    private JPanel editResourcePanel = null;
    private AdressPanel addressPanel = new AdressPanel();

    public AddressEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.comment.getJTextArea().setRows(3);
        this.serviceLinkTable.setHeader(this.rb_name, this.moduleDoc, "service_link");
        this.serviceLinkTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AddressEditor.this.editItem();
                }
            }
        });
        this.serviceLinkEditor.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                AddressEditor.this.stopLinkEdit();
            }
        });
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.serviceLinkEditor.setVisible(false);
        this.resourceSelectPanel.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.equals("ok")) {
                    AddressEditor.this.periodPanel.setDateCalendar1(AddressEditor.this.resourceSelectPanel.getDate());
                    AddressEditor.this.setIPFromResource();
                }
                AddressEditor.this.editResourceLayout.show(AddressEditor.this.editResourcePanel, "edit");
            }
        });
        JTabbedPane mainTab = new JTabbedPane();
        this.add(mainTab, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        JPanel serviceLinkPanel = new JPanel(new GridBagLayout());
        this.editResourceLayout = new CardLayout();
        this.editResourcePanel = new JPanel(this.editResourceLayout);
        this.editResourcePanel.add((Component)optionsPanel, "edit");
        this.editResourcePanel.add((Component)this.resourceSelectPanel, "resource_select");
        this.editResourceLayout.show(this.editResourcePanel, "edit");
        mainTab.addTab("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", this.editResourcePanel);
        mainTab.addTab("\u041f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433", serviceLinkPanel);
        serviceLinkPanel.add((Component)new JLabel("\u041f\u043b\u0430\u043d \u043f\u0440\u0438\u0432\u044f\u0437\u043e\u043a:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        serviceLinkPanel.add((Component)this.serviceLinkPlanCb, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        serviceLinkPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        JPanel tablePanel = new JPanel(new GridBagLayout());
        serviceLinkPanel.add((Component)tablePanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        tablePanel.add((Component)new JScrollPane((Component)this.serviceLinkTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setOrientation(1);
        toolBar.setFloatable(false);
        toolBar.setDefaultButtons(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressEditor.this.actionPerformed(e);
            }
        });
        toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        tablePanel.add((Component)toolBar, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        serviceLinkPanel.add((Component)((Object)this.serviceLinkEditor), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel objectPanel = new JPanel(new GridBagLayout());
        objectPanel.setBorder((Border)new BGTitleBorder(" \u041e\u0431\u044a\u0435\u043a\u0442 "));
        objectPanel.add((Component)this.object_CB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        GridBagConstraints gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0);
        objectPanel.add((Component)this.showAllObj, gbc);
        this.showAllObj.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressEditor.this.buildObjectCombo(AddressEditor.this.object_CB, AddressEditor.this.showAllObj.isSelected(), "0");
            }
        });
        JPanel portsPanel = new JPanel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        portsPanel.setLayout(new GridBagLayout());
        portsPanel.setBorder((Border)new BGTitleBorder(" \u041f\u043e\u0440\u0442(\u044b) "));
        jLabel6.setText("\u0441");
        jLabel7.setText(" \u043f\u043e ");
        JButton defaultPortValues = new JButton();
        defaultPortValues.setMaximumSize(new Dimension(21, 21));
        defaultPortValues.setMinimumSize(new Dimension(21, 21));
        defaultPortValues.setPreferredSize(new Dimension(21, 21));
        defaultPortValues.setToolTipText("\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        defaultPortValues.setMargin(new Insets(2, 2, 2, 2));
        defaultPortValues.setText(" ... ");
        defaultPortValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressEditor.this.defaultPortValues_actionPerformed(e);
            }
        });
        this.comment.setTitle(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 ");
        this.port1.setMinimumSize(new Dimension(55, 24));
        this.port1.setPreferredSize(new Dimension(55, 24));
        this.port1.setText("0");
        this.port2.setMinimumSize(new Dimension(55, 24));
        this.port2.setPreferredSize(new Dimension(55, 24));
        this.port2.setText("65535");
        portsPanel.add((Component)jLabel6, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 5, 0), 0, 0));
        portsPanel.add((Component)jLabel7, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        portsPanel.add((Component)defaultPortValues, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 10), 0, 0));
        portsPanel.add((Component)this.port1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        portsPanel.add((Component)this.port2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        optionsPanel.add((Component)portsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        optionsPanel.add((Component)this.getAddressPanel(), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        optionsPanel.add((Component)this.periodPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        optionsPanel.add((Component)this.comment, new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        optionsPanel.add((Component)objectPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.ifacePanel.setBorder((Border)new BGTitleBorder(" \u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0438/\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u044b "));
        optionsPanel.add((Component)((Object)this.ifacePanel), new GridBagConstraints(2, 1, 1, 4, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JButton takeNumber = new JButton("<<<");
        takeNumber.setToolTipText("\u0412\u0437\u044f\u0442\u044c \u0438\u0437 \u043f\u0443\u043b\u0430 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432");
        takeNumber.setMargin(new Insets(0, 0, 0, 0));
        takeNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressEditor.this.editResourceLayout.show(AddressEditor.this.editResourcePanel, "resource_select");
            }
        });
        this.getAddressPanel().add((Component)takeNumber, new GridBagConstraints(10, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
    }

    protected void setIPFromResource() {
        String[] ips = this.resourceSelectPanel.getIPs();
        this.getAddressPanel().setIPValue1(IPUtils.convertStringIPtoLong((String)ips[0], (long)0L));
        this.getAddressPanel().setIPValue2(IPUtils.convertStringIPtoLong((String)ips[1], (long)0L));
    }

    public void init(int cid, int mid, int objectId) {
        super.init(cid, mid, objectId);
        this.ifacePanel.init(this.module, mid);
        this.serviceLinkEditor.init(this.module, mid);
        this.resourceSelectPanel.init(this.module, mid);
    }

    private void init() {
        this.ifacePanel.setData();
        this.serviceLinkPlanCb.removeAllItems();
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ServiceLinkPlanList");
        request.setModuleId(this.getModuleId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildComboBox(this.serviceLinkPlanCb, (Node)XMLUtils.selectElement((Node)doc, (String)"//list"), (String)"");
        }
        this.serviceLinkPlanCb.insertItemAt((Object)new ComboBoxItem((Object)"0", "\u041f\u043b\u0430\u043d \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"), 0);
    }

    public void setData() {
        if (!this.init) {
            this.init = true;
            this.init();
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetContractAddress");
        request.setAttribute("id", this.id);
        request.setModuleId(this.getModuleId());
        this.setDocument(this.getDocument(request));
    }

    public void setDocument(Document doc) {
        if (!ClientUtils.checkStatus((Document)doc)) {
            this.buildObjectCombo((JComboBox)this.object_CB, this.showAllObj.isSelected(), "0");
            return;
        }
        Element address = XMLUtils.selectElement((Node)doc, (String)"//address");
        this.getAddressPanel().setIpEnabled(!address.getAttribute("resource_only").equals("true"));
        this.buildObjectCombo((JComboBox)this.object_CB, this.showAllObj.isSelected(), address.getAttribute("object_id"));
        this.setIpData(address);
        this.port1.setText("0");
        this.port1.setText(XMLUtils.getAttribute((Element)address, (String)"port1", (String)"0"));
        this.port2.setText("65535");
        this.port2.setText(XMLUtils.getAttribute((Element)address, (String)"port2", (String)"65535"));
        this.periodPanel.setDateCalendar1((Calendar)new GregorianCalendar());
        String date = XMLUtils.getAttribute((Element)address, (String)"date1", null);
        if (date != null) {
            this.periodPanel.setDateString1(date);
        }
        this.periodPanel.setDateString2(XMLUtils.getAttribute((Element)address, (String)"date2", (String)""));
        ClientUtils.setComboBoxSelection(this.object_CB, (Object)address.getAttribute("object_id"));
        this.serviceLinkPlanCb.setSelectedIndex(0);
        ClientUtils.setComboBoxSelection(this.serviceLinkPlanCb, (Object)address.getAttribute("plan"));
        this.ifacePanel.setIfaces(address.getAttribute("ifaces"));
        this.comment.setText(XMLUtils.getAttribute((Element)address, (String)"comment", (String)""));
        Element serviceLink = XMLUtils.selectElement((Node)address, (String)"//service_link");
        this.serviceLinkTable.updateData((Node)serviceLink);
    }

    protected void setIpData(Element address) {
        this.getAddressPanel().setIPValue1(Utils.parseLong((String)address.getAttribute("addr1"), (long)0L));
        this.getAddressPanel().setIPValue2(Utils.parseLong((String)address.getAttribute("addr2"), (long)0L));
    }

    private void defaultPortValues_actionPerformed(ActionEvent e) {
        this.port1.setText("0");
        this.port2.setText("65535");
    }

    public Document buttonOkClick() {
        boolean port_flag = false;
        int port_1 = 0;
        int port_2 = 65535;
        try {
            port_1 = Integer.parseInt(this.port1.getText().trim());
            port_2 = Integer.parseInt(this.port2.getText().trim());
            if (port_1 < 0) {
                port_flag = true;
            }
            if (port_2 > 65535) {
                port_flag = true;
            }
            if (port_1 > port_2) {
                port_flag = true;
            }
        }
        catch (Exception ex) {
            port_flag = true;
        }
        if (port_flag) {
            ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u043f\u043e\u0440\u0442\u043e\u0432");
            return null;
        }
        if ("".equals(this.periodPanel.getDateString1())) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430");
            return null;
        }
        String ifaces = this.ifacePanel.getIfaces();
        if (Utils.isBlankString((String)ifaces)) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441(\u044b)");
            return null;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("UpdateContractAddress");
        request.setAttribute("id", this.id);
        request.setModuleId(this.getModuleId());
        request.setContractId(this.getContractId());
        if (this.direct != null) {
            request.setAttribute("direct", this.direct);
        }
        request.setAttribute("ifaces", ifaces);
        if (this.sid != null) {
            request.setAttribute("sid", this.sid);
        }
        if (!this.setAddressInfo(request)) {
            return null;
        }
        request.setAttribute("port1", this.port1.getText().trim());
        request.setAttribute("port2", this.port2.getText().trim());
        request.setAttribute("date1", this.periodPanel.getDateString1());
        request.setAttribute("date2", this.periodPanel.getDateString2());
        request.setAttribute("comment", this.comment.getText());
        if (this.objectId > 0) {
            request.setAttribute("object_id", this.objectId);
        } else {
            request.setAttribute("object_id", ClientUtils.getIdFromComboBox(this.object_CB));
        }
        request.setAttribute("plan", ClientUtils.getIdFromComboBox(this.serviceLinkPlanCb));
        StringBuilder serviceLink = new StringBuilder();
        int rowCount = this.serviceLinkTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String data = this.serviceLinkTable.getColumnValueString(i, "data");
            if (serviceLink.length() > 0) {
                serviceLink.append(";");
            }
            serviceLink.append(data);
        }
        request.setAttribute("service_link", serviceLink.toString());
        return this.getDocument(request);
    }

    protected boolean setAddressInfo(Request request) {
        long addr1 = this.getAddressPanel().getIPValue1();
        long addr2 = this.getAddressPanel().getIPValue2();
        if (addr2 == 0L) {
            addr2 = addr1;
        }
        if (addr1 > addr2) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432");
            return false;
        }
        request.setAttribute("addr1", "" + addr1);
        request.setAttribute("addr2", "" + addr2);
        return true;
    }

    public void deleteItem() {
        this.currentEditRow = this.serviceLinkTable.getSelectedRow();
        if (this.currentEditRow < 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("CheckServiceLink");
        String data = ClientUtils.getRowId((BGTable)this.serviceLinkTable, null, (String)"data");
        if (data != null) {
            Map pairs = Utils.stringToPairsHash((String)data);
            request.setAttribute("date1", Utils.maskNull((String)((String)pairs.get("date1"))));
            request.setAttribute("date2", Utils.maskNull((String)((String)pairs.get("date2"))));
            request.setAttribute("id", Utils.parseInt((String)((String)pairs.get("id")), (int)-1));
            request.setAttribute("delete", 1);
        }
        request.setModuleId(this.getModuleId());
        Document doc = this.getDocument(request);
        Element checkEl = XMLUtils.selectElement((Node)doc, (String)"//check");
        String check = checkEl.getAttribute("check");
        if (!Utils.isEmptyString((String)check)) {
            ClientUtils.showErrorMessageDialog((String)check);
            return;
        }
        this.serviceLinkTable.removeRow(this.currentEditRow);
    }

    public void editItem() {
        this.currentEditRow = this.serviceLinkTable.getSelectedRow();
        if (this.currentEditRow < 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            return;
        }
        this.startLinkEdit();
    }

    public void newItem() {
        this.currentEditRow = -1;
        this.startLinkEdit();
    }

    private void startLinkEdit() {
        if (this.currentEditRow < 0) {
            this.serviceLinkEditor.setData(null);
        } else {
            String data = ClientUtils.getRowId((BGTable)this.serviceLinkTable, null, (String)"data");
            this.serviceLinkEditor.setData(data);
        }
        this.serviceLinkEditor.setVisible(true);
    }

    private void stopLinkEdit() {
        String data = this.serviceLinkEditor.getData();
        if (data != null) {
            if (this.currentEditRow < 0) {
                this.serviceLinkTable.addRow(new Vector(10));
                this.currentEditRow = this.serviceLinkTable.getRowCount() - 1;
            }
            this.serviceLinkTable.setColumnValue(this.currentEditRow, "data", (Object)data);
            Map values = Utils.stringToPairsHash((String)data);
            this.serviceLinkTable.setColumnValue(this.currentEditRow, "pos", values.get("pos"));
            this.serviceLinkTable.setColumnValue(this.currentEditRow, "period", values.get("period"));
            this.serviceLinkTable.setColumnValue(this.currentEditRow, "service", values.get("service_title"));
            this.serviceLinkTable.setColumnValue(this.currentEditRow, "comment", values.get("comment"));
        }
    }

    protected AdressPanel getAddressPanel() {
        return this.addressPanel;
    }
}

