/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import java.sql.SQLException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.ipn.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateTypeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.PPPoERule;
import ru.bitel.bgbilling.modules.ipn.server.bean.PPPoEUtils;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleTypeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRule;
import ru.bitel.bgbilling.modules.ipn.server.bean.UserGateRuleManager;
import ru.bitel.common.Utils;

public class ActionRadiusPPPoEGetContractRule
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        int gateTypeId = this.getIntParameter("gtid", -1);
        if (id <= 0 || gateTypeId <= 0 || this.mid == -1) {
            throw new BGIllegalArgumentException();
        }
        UserGateRule userGateRule = new UserGateRuleManager(this.con, this.mid).getUserGateRule(id);
        RuleTypeManager man = new RuleTypeManager(this.con, this.mid);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        if (userGateRule != null) {
            PPPoEUtils.PPPoELogin login = PPPoEUtils.parseRule(userGateRule.getRuleText());
            table.setAttribute("login", login.login);
            table.setAttribute("pswd", login.pswd);
            for (PPPoERule rule : login.ruleList) {
                Element row = this.createElement(data, "row");
                row.setAttribute("ID", String.valueOf(rule.getRuleTypeId()));
                row.setAttribute("realm", man.getType(rule.getRuleTypeId()).getTitle());
                row.setAttribute("address", rule.getIp());
                GateType gateType = new GateTypeManager(this.con, this.mid).getType(gateTypeId);
                row.setAttribute("vrfID", String.valueOf(rule.getVrfId()));
                row.setAttribute("vrf", gateType.getConfigOption("vrf." + rule.getVrfId()));
                StringBuilder sb = new StringBuilder();
                if (rule.getNets().trim().length() > 0) {
                    for (String _net : Utils.toList((String)rule.getNets())) {
                        sb.append(_net);
                        sb.append(", ");
                    }
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 2);
                }
                row.setAttribute("net_list", sb.toString());
            }
        }
    }
}

