/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.ipn.common.IpListService;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeManager;
import ru.bitel.common.TimeUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.ipn.common.IpListService")
public class IpListServiceImpl
extends AbstractService
implements IpListService {
    public List<AddressRange> getRanges(int cid, Integer rangeId) throws BGException {
        ArrayList<AddressRange> result = new ArrayList<AddressRange>();
        try {
            result = new ArrayList();
            AddressRangeManager man = new AddressRangeManager(this.getConnection(), this.moduleId);
            ContractManager contractManager = new ContractManager(this.getConnection());
            ArrayList<Integer> cids = new ArrayList<Integer>();
            cids.add(cid);
            List subContracts = contractManager.getSubContracts(cid);
            for (Contract contract : subContracts) {
                cids.add(contract.getId());
            }
            Date current = new Date();
            Iterator iterator = cids.iterator();
            while (iterator.hasNext()) {
                int contractId = (Integer)iterator.next();
                List<AddressRange> ranges = man.getContractAddressRange(contractId);
                for (AddressRange range : ranges) {
                    if ((rangeId == null || range.getId() != rangeId.intValue()) && !TimeUtils.checkDateIntervalsIntersection((Date)current, null, (Date)TimeUtils.convertCalendarToDate((Calendar)range.getDate1()), (Date)TimeUtils.convertCalendarToDate((Calendar)range.getDate2()))) continue;
                    result.add(range);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430", (Throwable)e);
        }
        return result;
    }

    public boolean checkRange(int cid, Integer rangeId, Date date1, Date date2) throws BGException {
        boolean result = false;
        AddressRangeManager man = new AddressRangeManager(this.getConnection(), this.moduleId);
        AddressRange range = man.getAddressRange(rangeId);
        Date current = new Date();
        if (date1 == null || TimeUtils.dateBefore((Date)date1, (Date)current)) {
            date1 = current;
        }
        if (range.getDate1() == null || TimeUtils.dateBefore((Calendar)range.getDate1(), (Calendar)TimeUtils.convertDateToCalendar((Date)current))) {
            range.setDate1(TimeUtils.convertDateToCalendar((Date)current));
        }
        if (range != null && TimeUtils.periodInRange((Date)date1, (Date)date2, (Date)TimeUtils.convertCalendarToDate((Calendar)range.getDate1()), (Date)TimeUtils.convertCalendarToDate((Calendar)range.getDate2()))) {
            result = true;
        }
        return result;
    }
}

