/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.dhcp;

import java.beans.ConstructorProperties;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionManager;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.application.server.ExtendedLifecycle;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpListenerWorker;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpOption;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetAbstractDhcpProcessor;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDevice;
import ru.bitel.bgbilling.modules.inet.server.dhcp.InetDhcpDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusProcessor;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;

public class InetDhcpHelperProcessor
extends InetAbstractDhcpProcessor
implements ExtendedLifecycle {
    private static final Logger log = LogManager.getLogger();
    private ConcurrentMap<String, InetAbstractDhcpProcessor.Entry> connectionMap = new ConcurrentHashMap<String, InetAbstractDhcpProcessor.Entry>();
    private static final Pattern macClearPattern = Pattern.compile("[\\s\\.:\\-\\\\\\$]+");
    private static final Pattern macrosPattern = Pattern.compile("\\$\\w+");
    private static final byte ZERO_BYTE = 0;

    private void put(String key, InetAbstractDhcpProcessor.Entry entry) {
        InetAbstractDhcpProcessor.Entry oldEntry = this.connectionMap.put(key, entry);
        if (oldEntry != null && oldEntry.address > 0) {
            this.addressMap.remove(oldEntry.address, oldEntry);
        }
        if (entry.address != 0) {
            this.addressMap.add(entry.address, entry);
        }
    }

    private boolean remove(String key, InetAbstractDhcpProcessor.Entry entry) {
        boolean result = this.connectionMap.remove(key, entry);
        if (entry.address != 0) {
            this.addressMap.remove(entry.address, entry);
        }
        return result;
    }

    private String getKey2(InetDhcpDevice inetDhcpDevice, StringBuffer sb, int servSearchMode, int deviceId, int agentDeviceId, Object circuitId, InetServ inetServ, String mac) {
        InetServRuntime servRuntime = this.access.getInetServRuntimeMap().get(inetServ.getId());
        InetServ parentInetServ = servRuntime.getParentInetServ(this.access);
        switch (servSearchMode) {
            case 1: 
            case 3: 
            case 12: {
                int interfaceId = parentInetServ.getInterfaceId();
                if (interfaceId == -1 && circuitId != null) {
                    int n = interfaceId = circuitId instanceof Number ? ((Number)circuitId).intValue() : Utils.parseInt((String)circuitId.toString(), (int)-1);
                }
                if (interfaceId != -1) {
                    return this.getKey2(inetDhcpDevice, sb, deviceId, agentDeviceId, interfaceId, mac);
                }
                log.info("interfaceId not set");
                return null;
            }
            case 2: 
            case 4: 
            case 11: {
                int vlanId = parentInetServ.getVlan();
                if (vlanId == -1) {
                    int n = vlanId = circuitId instanceof Number ? ((Number)circuitId).intValue() : Utils.parseInt((String)circuitId.toString(), (int)-1);
                }
                if (vlanId != -1) {
                    return this.getKey2(inetDhcpDevice, sb, deviceId, agentDeviceId, vlanId, mac);
                }
                log.info("vlanId not set");
                return null;
            }
            case 5: 
            case 6: 
            case 10: {
                return this.getKey2(inetDhcpDevice, sb, deviceId, agentDeviceId, -1, mac);
            }
        }
        return null;
    }

    private String getKey2(InetDhcpDevice inetDhcpDevice, StringBuffer sb, int servSearchMode, int deviceId, int agentDeviceId, InetDeviceRuntime device, DhcpPacket request, String mac) {
        switch (servSearchMode) {
            case 1: 
            case 3: 
            case 12: {
                int interfaceId = device.getOption82InterfaceId(request);
                return this.getKey2(inetDhcpDevice, sb, deviceId, agentDeviceId, interfaceId, mac);
            }
            case 2: 
            case 4: 
            case 11: {
                int vlanId = device.getOption82VlanId(request);
                return this.getKey2(inetDhcpDevice, sb, deviceId, agentDeviceId, vlanId, mac);
            }
            case 5: 
            case 6: 
            case 10: {
                return this.getKey2(inetDhcpDevice, sb, deviceId, agentDeviceId, -1, mac);
            }
        }
        return null;
    }

    private String getKey2(InetDhcpDevice device, StringBuffer sb, int deviceId, int agentDeviceId, int circuitId, String mac) {
        String dhcpKeyPattern = device != null ? device.dhcpKeyPattern : "$deviceId:$remoteId:$circuitId:$mac";
        Matcher m = macrosPattern.matcher(dhcpKeyPattern);
        while (m.find()) {
            String param = m.group();
            if ("$deviceId".equals(param)) {
                m.appendReplacement(sb, String.valueOf(deviceId));
                continue;
            }
            if ("$remoteId".equals(param)) {
                m.appendReplacement(sb, String.valueOf(agentDeviceId));
                continue;
            }
            if ("$circuitId".equals(param)) {
                m.appendReplacement(sb, String.valueOf(circuitId));
                continue;
            }
            if ("$mac".equals(param)) {
                mac = macClearPattern.matcher(mac).replaceAll("").toUpperCase();
                m.appendReplacement(sb, mac);
                continue;
            }
            log.error("Unknown parameter in pattern: " + dhcpKeyPattern);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @ConstructorProperties(value={"setup", "access"})
    public InetDhcpHelperProcessor(Setup setup, Access access) throws BGException {
        super(access, setup, "inet", SetupParam.getModuleId((ParameterMap)setup));
    }

    public void init() throws Exception {
        this.deviceMap = new InetDhcpDeviceMap(this.access);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<InetRadiusProcessor.AuthAcceptEvent>(){

            public void notify(InetRadiusProcessor.AuthAcceptEvent e, EventListenerContext ctx) throws BGException {
                int deviceId = e.getDeviceId();
                RadiusPacket request = e.getRequest();
                RadiusPacket response = e.getResponse();
                int framedIp = response.getIntAttribute(-1, 8, Integer.valueOf(0));
                String userName = request.getStringAttribute(-1, 1, null);
                String callingStationId = request.getStringAttribute(-1, 31, null);
                InetDhcpDevice dhcpDevice = InetDhcpHelperProcessor.this.deviceMap.get(deviceId);
                if (dhcpDevice != null && dhcpDevice.radiusServSearchModes[0][0] != 0) {
                    String key = InetDhcpHelperProcessor.this.getKey2(dhcpDevice, new StringBuffer(48), dhcpDevice.radiusServSearchModes[0][0], deviceId, e.getAgentDeviceId(), e.getCircuitId(), e.getInetServ(), callingStationId);
                    if (key != null) {
                        if (log.isInfoEnabled()) {
                            log.info("Put auth accept " + key + " " + IPUtils.convertIpToString((int)framedIp));
                        }
                        InetDhcpHelperProcessor.this.put(key, new InetAbstractDhcpProcessor.Entry(e.getIpResourceId(), framedIp, e.getInetServ().getId(), 0L));
                    }
                } else if (Utils.notBlankString((String)userName) && Utils.notBlankString((String)callingStationId) && framedIp != 0) {
                    String key = InetDhcpHelperProcessor.this.getKey(deviceId, userName, callingStationId);
                    if (key != null) {
                        if (log.isInfoEnabled()) {
                            log.info("Put auth accept " + key + " " + IPUtils.convertIpToString((int)framedIp));
                        }
                        InetDhcpHelperProcessor.this.put(key, new InetAbstractDhcpProcessor.Entry(e.getIpResourceId(), framedIp, e.getInetServ().getId(), 0L));
                    }
                } else {
                    log.info("Skip userName: " + userName);
                }
            }
        }, InetRadiusProcessor.AuthAcceptEvent.class);
        this.addAccountingListeners();
        log.info("Restore connections on DhcpHelper");
        InetServRuntimeMap inetServRuntimeMap = this.access.getInetServRuntimeMap();
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<Integer, ConcurrentMap<Long, InetConnectionRuntime>> me : this.access.connectionManager.deviceConnectionEntrySet()) {
            try {
                Integer deviceId = me.getKey();
                ConcurrentMap<Long, InetConnectionRuntime> map = me.getValue();
                InetDhcpDevice dhcpDevice = this.deviceMap.get(deviceId);
                for (InetConnectionRuntime connectionRuntime : map.values()) {
                    try {
                        String key;
                        InetConnection connection = connectionRuntime.connection;
                        if (connection.getParentConnectionId() > 0L) {
                            log.debug("Skip service connection");
                            continue;
                        }
                        Integer inetServId = connection.getServId();
                        InetServRuntime inetServRuntime = inetServRuntimeMap.get(inetServId);
                        if (dhcpDevice != null && dhcpDevice.radiusServSearchModes[0][0] != 0) {
                            sb.setLength(0);
                            key = this.getKey2(dhcpDevice, sb, dhcpDevice.radiusServSearchModes[0][0], (int)deviceId, connection.getAgentDeviceId(), connection.getCircuitId(), inetServRuntime.getInetServ(), connection.getCallingStationId());
                        } else {
                            key = this.getKey(connection);
                        }
                        if (key == null) continue;
                        if (log.isInfoEnabled()) {
                            log.info("Restored connection add " + key + " " + IpAddress.toString((byte[])connection.getInetAddressBytes()));
                        }
                        this.put(key, new InetAbstractDhcpProcessor.Entry(connection.getIpResourceId(), Utils.convertBytesToInt((byte[])connection.getInetAddressBytes()), connection.getServId(), connection.getId()));
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        InetDeviceRuntime rootDeviceRuntime = this.access.deviceMap.get(this.access.rootDeviceId);
        boolean processRenew = rootDeviceRuntime != null ? rootDeviceRuntime.config.getInt("dhcp.renew", 0) > 0 : this.access.setup.getModuleSetup(Integer.valueOf(this.access.moduleId)).getInt("dhcp.renew", 0) > 0;
        this.processRenew = processRenew;
    }

    @Override
    protected void onAccountingStart(InetConnectionManager.ConnectionAddEvent e, EventListenerContext ctx, int deviceId, InetDhcpDevice dhcpDevice, InetConnection con) {
        if (dhcpDevice != null && dhcpDevice.radiusServSearchModes[0][0] != 0) {
            String key;
            InetServRuntime servRuntime = this.access.inetServRuntimeMap.get(con.getServId());
            if (servRuntime != null && (key = this.getKey2(dhcpDevice, new StringBuffer(48), dhcpDevice.radiusServSearchModes[0][0], deviceId, con.getAgentDeviceId(), con.getCircuitId(), servRuntime.getInetServ(), con.getCallingStationId())) != null) {
                if (con.getInetAddressBytes() != null) {
                    if (log.isInfoEnabled()) {
                        log.info("Put connection add " + key + " " + IpAddress.toString((byte[])con.getInetAddressBytes()));
                    }
                    this.put(key, new InetAbstractDhcpProcessor.Entry(con.getIpResourceId(), Utils.convertBytesToInt((byte[])con.getInetAddressBytes()), con.getServId(), con.getId()));
                } else {
                    log.info("IP is null " + key);
                }
            }
        } else {
            String key = this.getKey(con);
            if (key != null) {
                if (con.getInetAddressBytes() != null) {
                    if (log.isInfoEnabled()) {
                        log.info("Put connection add " + key + " " + IpAddress.toString((byte[])con.getInetAddressBytes()));
                    }
                    this.put(key, new InetAbstractDhcpProcessor.Entry(con.getIpResourceId(), Utils.convertBytesToInt((byte[])con.getInetAddressBytes()), con.getServId(), con.getId()));
                } else {
                    log.info("IP is null " + key);
                }
            }
        }
    }

    @Override
    protected void onAccountingUpdate(InetConnectionManager.ConnectionUpdateEvent e, EventListenerContext ctx, int deviceId, InetDhcpDevice dhcpDevice, InetConnection con) {
        if (dhcpDevice != null && dhcpDevice.radiusServSearchModes[0][0] != 0) {
            String key;
            InetServRuntime servRuntime = this.access.inetServRuntimeMap.get(con.getServId());
            if (servRuntime != null && (key = this.getKey2(dhcpDevice, new StringBuffer(48), dhcpDevice.radiusServSearchModes[0][0], deviceId, con.getAgentDeviceId(), con.getCircuitId(), servRuntime.getInetServ(), con.getCallingStationId())) != null) {
                if (con.getInetAddressBytes() != null) {
                    if (log.isInfoEnabled()) {
                        log.info("Put connection update " + key + " " + IpAddress.toString((byte[])con.getInetAddressBytes()));
                    }
                    this.put(key, new InetAbstractDhcpProcessor.Entry(con.getIpResourceId(), Utils.convertBytesToInt((byte[])con.getInetAddressBytes()), con.getServId(), con.getId()));
                } else {
                    log.info("IP is null " + key);
                }
            }
        } else {
            String key = this.getKey(con);
            if (key != null) {
                if (con.getInetAddressBytes() != null) {
                    if (log.isInfoEnabled()) {
                        log.info("Put connection update " + key + " " + IpAddress.toString((byte[])con.getInetAddressBytes()));
                    }
                    this.put(key, new InetAbstractDhcpProcessor.Entry(con.getIpResourceId(), Utils.convertBytesToInt((byte[])con.getInetAddressBytes()), con.getServId(), con.getId()));
                } else {
                    log.info("IP is null " + key);
                }
            }
        }
    }

    @Override
    protected void onAccountingStop(InetConnectionManager.ConnectionRemoveEvent e, EventListenerContext ctx, int deviceId, InetDhcpDevice dhcpDevice, InetConnection con) {
        if (dhcpDevice != null && dhcpDevice.radiusServSearchModes[0][0] != 0) {
            String key;
            InetServRuntime servRuntime = this.access.inetServRuntimeMap.get(con.getServId());
            if (servRuntime != null && (key = this.getKey2(dhcpDevice, new StringBuffer(48), dhcpDevice.radiusServSearchModes[0][0], deviceId, con.getAgentDeviceId(), con.getCircuitId(), servRuntime.getInetServ(), con.getCallingStationId())) != null) {
                boolean result = false;
                InetAbstractDhcpProcessor.Entry entry = (InetAbstractDhcpProcessor.Entry)this.connectionMap.get(key);
                if (entry != null && entry.connectionId == con.getId()) {
                    result = this.remove(key, entry);
                }
                if (log.isInfoEnabled()) {
                    log.info("Remove connection for key=" + key + " " + IpAddress.toString((byte[])con.getInetAddressBytes()) + ": " + result);
                }
            }
        } else {
            String key = this.getKey(con);
            if (key != null) {
                boolean result = false;
                InetAbstractDhcpProcessor.Entry entry = (InetAbstractDhcpProcessor.Entry)this.connectionMap.get(key);
                if (entry != null && entry.connectionId == con.getId()) {
                    result = this.remove(key, entry);
                }
                if (log.isInfoEnabled()) {
                    log.info("Remove connection remove " + key + " " + IpAddress.toString((byte[])con.getInetAddressBytes()) + ": " + result);
                }
            }
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public void destroy() throws Exception {
    }

    private String getKey(InetConnection con) {
        int deviceId = con.getDeviceId();
        String userName = Utils.maskBlank((String)con.getUsername(), (String)"").toUpperCase();
        String callingStationId = con.getCallingStationId();
        return this.getKey(deviceId, userName, callingStationId);
    }

    private String getKey(int deviceId, String userName, String callingStationId) {
        String[] remote_circuit = userName.toUpperCase().replaceAll("[#_\\-\\|]", ":").split(":");
        if (remote_circuit.length != 2) {
            log.error("Incorrect userName: " + userName);
            return null;
        }
        String mac = Utils.maskBlank((String)callingStationId, (String)"").toUpperCase().replaceAll("\\.", "");
        return this.getKey(deviceId, remote_circuit[0], remote_circuit[1], mac);
    }

    private String getKey(int deviceId, String remoteId, String circuitId, String mac) {
        InetDhcpDevice device = this.deviceMap.get(deviceId);
        String dhcpKeyPattern = device != null ? device.dhcpKeyPattern : "$deviceId:$remoteId:$circuitId:$mac";
        StringBuffer sb = new StringBuffer(48);
        Matcher m = macrosPattern.matcher(dhcpKeyPattern);
        while (m.find()) {
            String param = m.group();
            if ("$deviceId".equals(param)) {
                m.appendReplacement(sb, String.valueOf(deviceId));
                continue;
            }
            if ("$remoteId".equals(param)) {
                m.appendReplacement(sb, remoteId);
                continue;
            }
            if ("$circuitId".equals(param)) {
                m.appendReplacement(sb, circuitId);
                continue;
            }
            if ("$mac".equals(param)) {
                m.appendReplacement(sb, mac);
                continue;
            }
            log.error("Unknown parameter in pattern: " + dhcpKeyPattern);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static final boolean isNil(byte[] b) {
        int size = b.length;
        for (int i = 0; i < size; ++i) {
            if (b[i] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected DhcpPacket processOption82RequestImpl(DhcpListenerWorker<InetDhcpDevice> req, SocketAddress clientAddress, InetDhcpDevice device, DhcpPacket request, boolean renew) throws BGException {
        InetConnection connection;
        String key;
        int agentDeviceId;
        String macString;
        byte[] giaddr = request.giaddr;
        if (log.isDebugEnabled()) {
            log.debug("request.giaddr = " + IPUtils.convertIpToString((int)Utils.convertBytesToInt((byte[])giaddr)));
        }
        if (device.radiusServSearchModes[0][0] == 0) {
            String circuitId = Utils.bytesToHexString((byte[])request.getSubOption((byte)1).value);
            String remoteId = Utils.bytesToHexString((byte[])request.getSubOption((byte)2).value);
            macString = Utils.bytesToHexString((byte[])request.chaddr);
            agentDeviceId = device.getId();
            key = this.getKey(device.getId(), remoteId, circuitId, macString);
        } else {
            int agentSvlan;
            InetDeviceRuntime agentDeviceRuntime = device.deviceRuntime;
            Object agentRemoteId = agentDeviceRuntime.getOption82AgentRemoteId(request);
            if (agentRemoteId != null && !"".equals(agentRemoteId)) {
                InetDeviceRuntime subDeviceRuntime = this.access.deviceMap.getByIdentifier(agentDeviceRuntime, agentRemoteId);
                if (subDeviceRuntime != null) {
                    log.debug("Found subDevice by identifier id=" + subDeviceRuntime.inetDeviceId);
                    agentDeviceRuntime = subDeviceRuntime;
                } else {
                    log.info("Agent device not found by identifier=" + agentRemoteId);
                }
            }
            if ((agentSvlan = agentDeviceRuntime.getOption82AgentSvlanId(request)) >= 0) {
                InetDeviceRuntime subDeviceRuntime = this.access.deviceMap.getBySvlan(agentDeviceRuntime, agentSvlan);
                if (subDeviceRuntime != null) {
                    log.debug("Found subDevice by SVLAN id=" + subDeviceRuntime.inetDeviceId);
                    agentDeviceRuntime = subDeviceRuntime;
                } else {
                    log.info("Agent device not found by SVLAN=" + agentSvlan);
                }
            }
            agentDeviceId = agentDeviceRuntime.inetDeviceId;
            macString = Utils.bytesToString((byte[])request.chaddr, (boolean)true, null);
            key = this.getKey2(device, new StringBuffer(48), device.radiusServSearchModes[0][0], req.relayDeviceId, agentDeviceId, agentDeviceRuntime, request, macString);
        }
        DhcpPacket response = request.createResponse();
        InetAbstractDhcpProcessor.Entry entry = (InetAbstractDhcpProcessor.Entry)this.connectionMap.get(key);
        if (entry == null) {
            log.error("Not found params for request: " + key + " (pattern: " + device.dhcpKeyPattern + ", servSearchMode: " + device.radiusServSearchModes[0][0] + ", deviceId: " + device.getId() + ", agentDeviceId: " + agentDeviceId + ", mac: " + macString + ")");
            response.messageType = (byte)6;
            return response;
        }
        if (request.messageType == 3) {
            DhcpOption requestedIp = request.getOption((byte)50);
            if (requestedIp != null) {
                if (Utils.convertBytesToInt((byte[])requestedIp.value) != entry.address) {
                    log.info("RequestedIP " + IpAddress.toString((byte[])requestedIp.value) + " not " + IPUtils.convertIpToString((int)entry.address));
                    response.messageType = (byte)6;
                    return response;
                }
            } else if (!InetDhcpHelperProcessor.isNil(request.ciaddr) && Utils.convertBytesToInt((byte[])request.ciaddr) != entry.address) {
                log.info("ClientIP " + IpAddress.toString((byte[])request.ciaddr) + " not " + IPUtils.convertIpToString((int)entry.address));
                response.messageType = (byte)6;
                return response;
            }
        }
        Set inetOptionIds = (connection = this.getConnection(entry, null)) != null && connection.getDeviceState() == 1 ? connection.getDeviceOptions() : null;
        return this.buildResponse(req, clientAddress, device, request, response, entry, inetOptionIds, renew);
    }
}

