/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.detail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import ru.bitel.bgbilling.apps.inet.accounting.detail.FlowDetailMaker;
import ru.bitel.bgbilling.apps.inet.accounting.detail.PeriodValue;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLogUtils;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowAnalyzer;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.modules.inet.common.event.accounting.InetDetailCreateEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.localize.Localizer;
import ru.bitel.common.reports.Charts;
import ru.bitel.common.sql.ConnectionSet;

public class AnalyzedFlowDetailMaker
extends FlowDetailMaker {
    @Override
    protected void sendDetailImpl(DefaultServerSetup setup, ConnectionSet connectionSet, InetDetailCreateEvent task, List<FlowDetailMaker.FlowDetailEntry> entries, StringBuilder messageBody, String subject) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(524288);
        ZipOutputStream zos = new ZipOutputStream(bos);
        zos.setLevel(setup.getInt("accounting.detail.compression.level", -1));
        zos.putNextEntry(new ZipEntry("detail.csv"));
        PrintStream csvReport = new PrintStream((OutputStream)zos, false, "UTF-8");
        csvReport.append("\u0412\u0440\u0435\u043c\u044f;\u0421 \u0430\u0434\u0440\u0435\u0441\u0430;\u0421 \u043f\u043e\u0440\u0442\u0430;\u041d\u0430 \u0430\u0434\u0440\u0435\u0441;\u041d\u0430 \u043f\u043e\u0440\u0442;\u0411\u0430\u0439\u0442;\u0421 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430;\u041d\u0430 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441;\u041f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\n");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        FlowAnalyzer analyzer = new FlowAnalyzer();
        TreeMap<Long, PeriodValue> periodValues = new TreeMap<Long, PeriodValue>();
        long currentPeriod = -1L;
        PeriodValue currentPeriodValue = null;
        long periodDivider = TimeUnit.MINUTES.toMillis(1L);
        boolean analyze = true;
        for (FlowDetailMaker.FlowDetailEntry entry : entries) {
            for (FlowArray<IPDataLogUtils.FlowDetail> f : entry.newFlowDetailIterable()) {
                int size = f.size;
                for (int i = 0; i < size; ++i) {
                    IPDataLogUtils.FlowDetail detail = ((IPDataLogUtils.FlowDetail[])f.array)[i];
                    long period = detail.milliseconds / periodDivider;
                    if (period != currentPeriod) {
                        currentPeriodValue = (PeriodValue)periodValues.get(period);
                        if (currentPeriodValue == null) {
                            currentPeriodValue = new PeriodValue();
                            periodValues.put(period, currentPeriodValue);
                        }
                        currentPeriod = period;
                    }
                    if (analyze) {
                        if (detail.direction == 1) {
                            currentPeriodValue.input += detail.octets;
                            analyzer.input(detail.srcAddress, (Data)detail);
                        } else {
                            currentPeriodValue.output += detail.octets;
                            analyzer.output(detail.dstAddress, (Data)detail);
                        }
                        if (analyzer.size() > 10000) {
                            analyze = false;
                            analyzer.clear();
                        }
                    } else if (detail.direction == 1) {
                        currentPeriodValue.input += detail.octets;
                    } else {
                        currentPeriodValue.output += detail.octets;
                    }
                    this.printToCsv(csvReport, (Data)detail, dateFormat);
                }
            }
        }
        csvReport.flush();
        zos.closeEntry();
        zos.putNextEntry(new ZipEntry("detail.png"));
        this.writeChart(periodValues, zos, TimeUnit.MINUTES);
        periodValues.clear();
        zos.closeEntry();
        zos.putNextEntry(new ZipEntry("detail.html"));
        this.writeHTML(zos, analyzer, task, (ParameterMap)setup, analyze);
        analyzer.clear();
        zos.closeEntry();
        zos.flush();
        zos.close();
        zos = null;
        final byte[] data = bos.toByteArray();
        bos = null;
        String fileName = "detail.zip";
        MimeMultipart m = new MimeMultipart();
        MimeBodyPart attach = new MimeBodyPart();
        m.addBodyPart((BodyPart)attach);
        DataSource ds = new DataSource(){

            public String getContentType() {
                return "application/zip";
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(data);
            }

            public String getName() {
                return "detail.zip";
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        };
        attach.setDataHandler(new DataHandler(ds));
        attach.setFileName("detail.zip");
        this.sendDetailMail(setup, task, subject, messageBody, attach);
    }

    protected void writeChart(SortedMap<Long, PeriodValue> periodValues, OutputStream outputStream, TimeUnit timeUnit) throws IOException {
        TimeSeries outputSeries;
        TimeSeries inputSeries;
        long period = timeUnit.toMillis(1L);
        long lastPeriod = -1L;
        switch (timeUnit) {
            case MINUTES: {
                inputSeries = new TimeSeries((Comparable)((Object)"\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0442\u0440\u0430\u0444\u0438\u043a (\u041a\u0411/\u043c\u0438\u043d)"));
                outputSeries = new TimeSeries((Comparable)((Object)"\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0442\u0440\u0430\u0444\u0438\u043a (\u041a\u0411/\u043c\u0438\u043d)"));
                for (Map.Entry<Long, PeriodValue> e : periodValues.entrySet()) {
                    long lastPeriodNext;
                    long millis = timeUnit.toMillis(e.getKey());
                    PeriodValue periodValue = e.getValue();
                    if (lastPeriod != -1L && (lastPeriodNext = lastPeriod + period) != millis) {
                        long currentPrev = millis - period;
                        Minute timePeriod = new Minute(new Date(lastPeriodNext));
                        inputSeries.add((RegularTimePeriod)timePeriod, 0.0);
                        outputSeries.add((RegularTimePeriod)timePeriod, 0.0);
                        if (lastPeriodNext != currentPrev) {
                            timePeriod = new Minute(new Date(currentPrev));
                            inputSeries.add((RegularTimePeriod)timePeriod, 0.0);
                            outputSeries.add((RegularTimePeriod)timePeriod, 0.0);
                        }
                    }
                    lastPeriod = millis;
                    Minute timePeriod = new Minute(new Date(millis));
                    inputSeries.add((RegularTimePeriod)timePeriod, (double)periodValue.input / 1024.0);
                    outputSeries.add((RegularTimePeriod)timePeriod, (double)periodValue.output / 1024.0);
                }
                break;
            }
            default: {
                inputSeries = new TimeSeries((Comparable)((Object)"\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0442\u0440\u0430\u0444\u0438\u043a (\u041a\u0411/\u043c\u0438\u043d)"));
                outputSeries = new TimeSeries((Comparable)((Object)"\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0442\u0440\u0430\u0444\u0438\u043a (\u041a\u0411/\u043c\u0438\u043d)"));
                for (Map.Entry<Long, PeriodValue> e : periodValues.entrySet()) {
                    long lastPeriodNext;
                    long millis = timeUnit.toMillis(e.getKey());
                    PeriodValue periodValue = e.getValue();
                    if (lastPeriod != -1L && (lastPeriodNext = lastPeriod + period) != millis) {
                        long currentPrev = millis - period;
                        Minute timePeriod = new Minute(new Date(lastPeriodNext));
                        inputSeries.add((RegularTimePeriod)timePeriod, 0.0);
                        outputSeries.add((RegularTimePeriod)timePeriod, 0.0);
                        if (lastPeriodNext != currentPrev) {
                            timePeriod = new Minute(new Date(currentPrev));
                            inputSeries.add((RegularTimePeriod)timePeriod, 0.0);
                            outputSeries.add((RegularTimePeriod)timePeriod, 0.0);
                        }
                    }
                    Day timePeriod = new Day(new Date(millis));
                    inputSeries.add((RegularTimePeriod)timePeriod, (double)periodValue.input / 1024.0);
                    outputSeries.add((RegularTimePeriod)timePeriod, (double)periodValue.output / 1024.0);
                }
            }
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(inputSeries);
        dataset.addSeries(outputSeries);
        ChartUtils.writeChartAsPNG((OutputStream)outputStream, (JFreeChart)Charts.createTimeSeriesChart((XYItemRenderer)new XYStepRenderer(), (XYDataset)dataset), (int)832, (int)275, (ChartRenderingInfo)new ChartRenderingInfo(), (boolean)true, (int)0);
        inputSeries.clear();
        outputSeries.clear();
    }

    protected void writeHTML(OutputStream out, FlowAnalyzer analyzer, InetDetailCreateEvent task, ParameterMap params, boolean analyze) {
        try {
            String title = this.getMessageBody(task).toString();
            String XHTML_NS = "http://www.w3.org/1999/xhtml";
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter w = factory.createXMLStreamWriter(out, "UTF-8");
            w.writeStartDocument("UTF-8", "1.0");
            w.writeCharacters("\n");
            w.writeDTD("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            w.writeStartElement("html");
            w.writeDefaultNamespace("http://www.w3.org/1999/xhtml");
            w.writeStartElement("head");
            this.writeHTMLHead(w, title);
            this.writeHTMLStyle(w);
            w.writeEndElement();
            w.writeCharacters("\n");
            w.writeStartElement("body");
            w.writeStartElement("div");
            w.writeAttribute("class", "body");
            w.writeStartElement("div");
            w.writeAttribute("class", "title");
            w.writeAttribute("id", "title");
            w.writeCharacters(title);
            w.writeEndElement();
            w.writeStartElement("div");
            w.writeAttribute("class", "title");
            w.writeAttribute("id", "plot_title");
            w.writeCharacters("\u0422\u0440\u0430\u0444\u0438\u043a \u0432 \u043c\u0438\u043d\u0443\u0442\u0443 (\u041a\u0411)");
            w.writeEndElement();
            w.writeStartElement("div");
            w.writeAttribute("class", "plot");
            w.writeStartElement("img");
            w.writeAttribute("src", "detail.png");
            w.writeAttribute("alt", "\u0422\u0440\u0430\u0444\u0438\u043a \u0432 \u043c\u0438\u043d\u0443\u0442\u0443 (\u041a\u0411)");
            w.writeEndElement();
            w.writeEndElement();
            w.writeStartElement("div");
            w.writeAttribute("class", "title");
            w.writeAttribute("id", "data_title");
            w.writeCharacters("\u0410\u043d\u0430\u043b\u0438\u0437");
            w.writeEndElement();
            this.writeInfo(w, analyzer, task, params, analyze);
            if (analyze) {
                this.writeTable(w, analyzer, task, params);
            }
            w.writeEndElement();
            w.writeEndElement();
            w.writeEndElement();
            w.writeEndDocument();
            w.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void writeInfo(XMLStreamWriter w, FlowAnalyzer analyzer, InetDetailCreateEvent task, ParameterMap params, boolean analyze) throws Exception {
        w.writeStartElement("div");
        w.writeAttribute("class", "info");
        if (analyze) {
            w.writeCharacters("\u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0442\u0440\u0430\u0444\u0438\u043a\u0430 \u043f\u043e IP-\u0430\u0434\u0440\u0435\u0441\u0430\u043c, \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430\u043c \u0438 \u043f\u043e\u0440\u0442\u0430\u043c, \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u044b \u0432 \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442\u0430\u0445.");
            w.writeEmptyElement("br");
            w.writeCharacters("HTTP - \u0442\u0440\u0430\u0444\u0438\u043a \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u043d\u044b\u0439 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 www \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c\u0438");
            w.writeEmptyElement("br");
            w.writeCharacters("SMTP - \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043f\u043e\u0447\u0442\u044b");
            w.writeEmptyElement("br");
            w.writeCharacters("POP3/IMAP - \u043f\u0440\u0438\u0435\u043c \u043f\u043e\u0447\u0442\u044b");
            w.writeEmptyElement("br");
            w.writeCharacters("FTP - \u0442\u0440\u0430\u0444\u0438\u043a \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u043d\u044b\u0439 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 ftp \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c\u0438");
            w.writeEmptyElement("br");
            w.writeCharacters("UDP named - \u0442\u0440\u0430\u0444\u0438\u043a \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u043c\u044b\u0439 \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0439 \u0438\u043c\u0435\u043d \u0445\u043e\u0441\u0442\u043e\u0432 \u0432 ip \u0430\u0434\u0440\u0435\u0441 \u0438\u043b\u0438 \u043e\u0431\u0440\u0430\u0442\u043d\u043e, \u043e\u0447\u0435\u043d\u044c \u0431\u043e\u043b\u044c\u0448\u043e\u0439 \u0442\u0440\u0430\u0444\u0438\u043a \u043f\u043e \u044d\u0442\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0438\u0441\u0443 \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0435\u043d \u043f\u0440\u0438 \u0437\u0430\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u0432\u0438\u0440\u0443\u0441\u0430\u043c\u0438 \u043c\u0430\u0448\u0438\u043d \u0432 \u043b\u043e\u043aa\u043b\u044c\u043d\u043e\u0439 \u0441\u0435\u0442\u0438");
            w.writeEmptyElement("br");
            w.writeCharacters("\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u044b \u0432 \u043e\u0442\u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u043c \u043f\u043e \u0443\u043c\u0435\u043d\u044c\u0448\u0435\u043d\u0438\u044e \u043f\u043e\u0440\u044f\u0434\u043a\u0435");
        } else {
            w.writeCharacters("\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e IP-\u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0434\u043b\u044f \u0430\u043d\u0430\u043b\u0438\u0437\u0430 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043f\u043e IP-\u0430\u0434\u0440\u0435\u0441\u0430\u043c, \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430\u043c \u0438 \u043f\u043e\u0440\u0442\u0430\u043c.");
        }
        w.writeEndElement();
    }

    protected void writeTable(XMLStreamWriter w, FlowAnalyzer analyzer, InetDetailCreateEvent task, ParameterMap params) throws Exception {
        w.writeStartElement("table");
        w.writeAttribute("width", "100%");
        w.writeAttribute("cellpadding", "0");
        w.writeAttribute("cellspacing", "0");
        w.writeAttribute("border", "0");
        w.writeAttribute("class", "data");
        w.writeStartElement("thead");
        w.writeStartElement("tr");
        AnalyzedFlowDetailMaker.writeTDWithClass(w, "IP", "2", "1", "line");
        AnalyzedFlowDetailMaker.writeTDWithClass(w, "\u0412\u0441\u0435\u0433\u043e", "1", "2", "line");
        AnalyzedFlowDetailMaker.writeTDWithClass(w, "TCP/UDP/ICMP/\u0414\u0440\u0443\u0433\u043e\u0435", "1", "2", "line");
        AnalyzedFlowDetailMaker.writeTDWithClass(w, "TCP: HTTP", "1", "2", "line");
        AnalyzedFlowDetailMaker.writeTDWithClass(w, "TCP: SMTP/POP3/IMAP/FTP", "1", "2", "line");
        AnalyzedFlowDetailMaker.writeTDWithClass(w, "UDP named", "1", "2", "line");
        w.writeEndElement();
        w.writeStartElement("tr");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        AnalyzedFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        w.writeEndElement();
        w.writeEndElement();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(Localizer.getDecimalFormatSymbols().getDecimalSeparator());
        DecimalFormat df = new DecimalFormat("########0.00", dfs);
        double divisor = 1024.0;
        int count = 0;
        int maxResolve = params.getInt("ipn.collector.detail.hostresolve", 5);
        w.writeStartElement("tbody");
        for (FlowAnalyzer.FlowAnalizerEntry f : analyzer.get()) {
            w.writeStartElement("tr");
            if (count++ < maxResolve) {
                String host = InetAddress.getByAddress(f.ip.address).getHostName();
                String ip = f.ip.toString();
                if (!ip.equals(host)) {
                    w.writeStartElement("td");
                    w.writeAttribute("rowspan", "4");
                    w.writeAttribute("class", "line");
                    w.writeCharacters(ip);
                    w.writeEmptyElement("br");
                    w.writeCharacters(host);
                    w.writeEndElement();
                } else {
                    AnalyzedFlowDetailMaker.writeTDWithClass(w, f.ip.toString(), "4", "line");
                }
            } else {
                AnalyzedFlowDetailMaker.writeTDWithClass(w, f.ip.toString(), "4", "line");
            }
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctets() / 1024.0), "4", "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctets() / 1024.0), "4", "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctetsTcp() / 1024.0), "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctetsTcp() / 1024.0), "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctetsTcpHttp() / 1024.0), "4", "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctetsTcpHttp() / 1024.0), "4", "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctetsTcpSmtp() / 1024.0), "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctetsTcpSmtp() / 1024.0), "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctetsUdpNamed() / 1024.0), "4", "line");
            AnalyzedFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctetsUdpNamed() / 1024.0), "4", "line");
            w.writeEndElement();
            w.writeStartElement("tr");
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsUdp() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsUdp() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsTcpPop3() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsTcpPop3() / 1024.0));
            w.writeEndElement();
            w.writeStartElement("tr");
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsIcmp() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsIcmp() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsTcpImap() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsTcpImap() / 1024.0));
            w.writeEndElement();
            w.writeStartElement("tr");
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)(f.input.getOctets() - f.input.getOctetsIcmp() - f.input.getOctetsTcp() - f.input.getOctetsUdp()) / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)(f.output.getOctets() - f.output.getOctetsIcmp() - f.output.getOctetsTcp() - f.output.getOctetsUdp()) / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsTcpFtp() / 1024.0));
            AnalyzedFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsTcpFtp() / 1024.0));
            w.writeEndElement();
        }
        w.writeEndElement();
        w.writeEndElement();
    }

    protected void writeHTMLHead(XMLStreamWriter w, String title) throws XMLStreamException {
        w.writeStartElement("title");
        w.writeCharacters(title);
        w.writeEndElement();
        w.writeStartElement("meta");
        w.writeAttribute("http-equiv", "Content-Type");
        w.writeAttribute("content", "text/html; charset=UTF-8");
        w.writeEndElement();
    }

    protected void writeHTMLStyle(XMLStreamWriter w) throws XMLStreamException {
        w.writeStartElement("style");
        w.writeCharacters("tbody td.line {border-top-style: solid; border-top-width: 1px; border-top-color: #000000;}\n");
        w.writeCharacters("table.data td {font-family: sansserif; font-size: 8.0px;}\n");
        w.writeCharacters("table.data thead td {font-weight: bold; padding: 1px;}\n");
        w.writeCharacters("div.plot {text-align: center;}\n");
        w.writeCharacters("div.body {margin:0 auto; width: 842px;}\n");
        w.writeCharacters("div.title {text-align: center; font-family: sansserif; font-size: 12.0px; font-weight: bold; margin-top: 20px;}\n");
        w.writeCharacters("div#plot_title, div#data_title {font-size: 11.0px}\n");
        w.writeCharacters("div.info {font-size: 8.0px}\n");
        w.writeCharacters("table.data {margin-top: 10px; border-bottom: solid 1px;}\n");
        w.writeEndElement();
    }

    private static final void writeTD(XMLStreamWriter w, String data) throws XMLStreamException {
        w.writeStartElement("td");
        w.writeCharacters(data);
        w.writeEndElement();
    }

    private static final void writeTDWithClass(XMLStreamWriter w, String data, String rowspan, String clazz) throws XMLStreamException {
        w.writeStartElement("td");
        w.writeAttribute("rowspan", rowspan);
        w.writeAttribute("class", clazz);
        w.writeCharacters(data);
        w.writeEndElement();
    }

    private static final void writeTDWithClass(XMLStreamWriter w, String data, String rowspan, String colspan, String clazz) throws XMLStreamException {
        w.writeStartElement("td");
        w.writeAttribute("rowspan", rowspan);
        w.writeAttribute("colspan", colspan);
        w.writeAttribute("class", clazz);
        w.writeCharacters(data);
        w.writeEndElement();
    }

    private static final void writeTDWithClass(XMLStreamWriter w, String data, String clazz) throws XMLStreamException {
        w.writeStartElement("td");
        w.writeAttribute("class", clazz);
        w.writeCharacters(data);
        w.writeEndElement();
    }
}

