/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.ConnectionLog;
import ru.bitel.bgbilling.apps.inet.accounting.IpRangeRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAccountDelta;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAmountDelta;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAmountKey;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.DefaultContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.network.radius.AccountingSession;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEntry;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSession;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetConnectionDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetSessionDao;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxEntry;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.inet.IpRange;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.AbstractPeriodItemSet;
import ru.bitel.common.worker.ThreadContext;

public abstract class InetConnectionRuntime
implements AccountingSession {
    private static final Logger logger = LogManager.getLogger();
    public final int contractId;
    public final int superContractId;
    public final Integer inetServId;
    public final int calculateType = 0;
    public final InetServRuntime inetServRuntime;
    public final AtomicReference<InetDeviceRuntime> inetDeviceRuntimeRef;
    public IpRangeRuntime[] rangeSets;
    public volatile InetConnection connection;
    public long sessionId;
    public Date sessionStart;
    public volatile Date sessionStop;
    public volatile int sessionDeviceState;
    public final boolean call;
    public boolean kill;
    public long killMillis;
    public int accountingPeriodId = -1;
    public long accountingPeriodMillisFrom;
    public long accountingPeriodMillisTo;
    public long connectionStartTime;
    public long sessionStartTime;
    public long nextMonthTime;
    public long nextDayTime;
    public Long lastDayHour;
    public int currentDay;
    public long nextTariffOptionTime;
    protected Set<Integer> inetOptions = Collections.emptySet();
    public volatile long lastFlowTime;
    public volatile long lastAccountTime;
    public final Map<Integer, AccountingTrafficAmount> counterTraffics;
    public SortedMap<Long, Map<TrafficAmountKey, TrafficAmountDelta>> trafficsDelta;
    public long trafficsDeltaCurrentHour = Long.MIN_VALUE;
    public Map<TrafficAmountKey, TrafficAmountDelta> trafficsDeltaCurrent;
    public volatile long trafficDeltaCalculateAmount = 0L;
    public volatile long trafficDeltaFlushAmount = 0L;
    public final Map<Integer, TrafficAccountDelta> accountDelta = new HashMap<Integer, TrafficAccountDelta>();
    public volatile BigDecimal sessionCostDelta = BigDecimal.ZERO;
    public TrafficRangeEntry rangedTraffic;
    public TrafficMaxEntry maxTraffic;
    private static final AtomicReference<InetDeviceRuntime> NULL_REF = new AtomicReference<Object>(null);
    private Long trafficTimeHour;
    private long trafficTimeCountdown;

    public long lastActiveTime() {
        return Math.max(this.lastFlowTime, this.lastAccountTime);
    }

    private void updateTimeFields(Calendar calendar, InetSession session) {
        Date sessionStart = session.getSessionStart();
        calendar.setTime(sessionStart);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
        this.currentDay = calendar.get(5);
        calendar.add(5, 1);
        this.nextDayTime = calendar.getTimeInMillis();
        calendar.add(11, -1);
        this.lastDayHour = calendar.getTimeInMillis();
        calendar.set(5, 1);
        calendar.add(2, 1);
        this.nextMonthTime = calendar.getTimeInMillis();
    }

    protected InetConnectionRuntime(Accounting accounting, boolean call, InetServRuntime inetServRuntime, InetConnection connection, InetSession session) throws BGException {
        AtomicReference<InetDeviceRuntime> inetDeviceRuntimeRef;
        this.call = call;
        InetServ inetServ = inetServRuntime.getInetServ();
        this.contractId = inetServ.getContractId();
        this.superContractId = inetServRuntime.contractRuntime.getSuperContractId();
        assert (inetServRuntime.inetServId != null);
        this.inetServId = inetServRuntime.inetServId;
        this.inetServRuntime = inetServRuntime;
        this.counterTraffics = new HashMap<Integer, AccountingTrafficAmount>(8);
        this.trafficsDelta = new TreeMap<Long, Map<TrafficAmountKey, TrafficAmountDelta>>();
        if (call) {
            if (connection != null) {
                inetDeviceRuntimeRef = accounting.deviceMap.getRef(connection.getDeviceId());
            } else {
                assert (false);
                inetDeviceRuntimeRef = null;
            }
        } else {
            inetDeviceRuntimeRef = accounting.deviceMap.getRef(inetServ.getDeviceId());
        }
        this.inetDeviceRuntimeRef = inetDeviceRuntimeRef != null ? inetDeviceRuntimeRef : NULL_REF;
        this.setConnection(connection);
        this.setSession(accounting, session, true, false);
        if (call) {
            List routeNets = connection.getRouteList();
            if (routeNets == null || routeNets.size() == 0) {
                this.rangeSets = null;
            } else {
                this.rangeSets = new IpRangeRuntime[routeNets.size()];
                int size = routeNets.size();
                for (int i = 0; i < size; ++i) {
                    IpRange range = IpRange.newInstance((IpNet)((IpNet)routeNets.get(i)));
                    this.rangeSets[i] = new IpRangeRuntime(range.getAddressFrom(), range.getAddressTo(), this);
                }
            }
        } else {
            this.rangeSets = new IpRangeRuntime[]{new IpRangeRuntime(inetServ.getAddressFrom(), inetServ.getAddressTo(), this)};
        }
        this.nextTariffOptionTime = InetUtils.roundToSeconds(this.inetServRuntime.contractRuntime.getTariffOptions(accounting.initialDate).nextActivateTime(this.sessionStartTime));
        this.inetServRuntime.addSession(this);
    }

    public boolean isCall() {
        return this.call;
    }

    protected void setConnection(InetConnection connection) {
        assert (!this.call || this.connection == null);
        this.connection = connection;
        if (connection != null) {
            this.connectionStartTime = connection.getConnectionStart().getTime();
            String username = connection.getUsername();
            String login = this.inetServRuntime.getInetServ().getLogin();
            if (username != null && username.equals(login)) {
                connection.setUsername(login);
            }
        } else {
            this.connectionStartTime = -1L;
        }
    }

    public void setSession(Accounting accounting, InetSession session) throws BGException {
        this.setSession(accounting, session, false, false);
    }

    private void setSession(Accounting accounting, InetSession session, boolean constructor, boolean split) throws BGException {
        assert (constructor || this.inetServRuntime.isHeldByCurrentThread());
        this.kill = false;
        if (session != null) {
            this.sessionId = session.getId();
            this.sessionStart = session.getSessionStart();
            this.sessionStop = session.getSessionStop();
            this.sessionDeviceState = session.getDeviceState();
            this.sessionStartTime = session.getSessionStart().getTime();
            this.trafficTimeHour = InetUtils.getHour(this.sessionStartTime);
            this.trafficTimeCountdown = 3600L - (this.sessionStartTime - this.trafficTimeHour) / 1000L;
            GregorianCalendar calendar = new GregorianCalendar();
            if (split) {
                if (this.lastAccountTime <= 0L && this.lastFlowTime <= 0L) {
                    this.lastAccountTime = this.lastFlowTime = calendar.getTimeInMillis() / 1000L;
                }
            } else {
                this.lastAccountTime = this.lastFlowTime = calendar.getTimeInMillis() / 1000L;
            }
            this.updateTimeFields(calendar, session);
            if (!constructor) {
                if (!this.isCall()) {
                    this.counterTraffics.clear();
                }
                this.trafficsDelta.clear();
                this.trafficsDeltaCurrentHour = 0L;
                this.trafficsDeltaCurrent = null;
                this.trafficDeltaCalculateAmount = 0L;
                this.trafficDeltaFlushAmount = 0L;
                this.accountDelta.clear();
                this.sessionCostDelta = BigDecimal.ZERO;
                this.nextTariffOptionTime = InetUtils.roundToSeconds(this.inetServRuntime.contractRuntime.getTariffOptions(accounting.initialDate).nextActivateTime(this.sessionStartTime + 1000L));
            }
        } else {
            if (constructor) {
                this.sessionStartTime = -1L;
                this.nextMonthTime = -1L;
                this.nextDayTime = -1L;
            }
            this.sessionId = -1L;
            this.sessionStart = null;
            this.sessionStop = null;
            this.sessionDeviceState = -1;
            this.connection = null;
            this.lastFlowTime = -1L;
            this.lastAccountTime = -1L;
            this.trafficTimeHour = -1L;
            this.trafficTimeCountdown = 0L;
            this.trafficDeltaCalculateAmount = 0L;
            this.trafficDeltaFlushAmount = 0L;
            this.sessionCostDelta = BigDecimal.ZERO;
        }
    }

    public String getUserName() {
        return this.connection.getUsername();
    }

    private final Map<TrafficAmountKey, TrafficAmountDelta> getDeltaTraffics(Long hour) {
        HashMap deltaTraffics;
        if (hour > this.lastDayHour) {
            hour = this.lastDayHour;
        }
        if (this.trafficsDeltaCurrentHour == hour) {
            deltaTraffics = this.trafficsDeltaCurrent;
        } else {
            deltaTraffics = (HashMap)this.trafficsDelta.get(hour);
            if (deltaTraffics == null) {
                deltaTraffics = new HashMap(8);
                this.trafficsDelta.put(hour, deltaTraffics);
            }
            this.trafficsDeltaCurrentHour = hour;
            this.trafficsDeltaCurrent = deltaTraffics;
        }
        return deltaTraffics;
    }

    public void addTraffic(int agentDeviceId, Long hour, Integer trafficTypeId, long amount) {
        boolean addToCalculate = this.sessionDeviceState == 1;
        this.addTraffic(agentDeviceId, hour, trafficTypeId, amount, addToCalculate);
    }

    protected void addTraffic(int agentDeviceId, Long hour, Integer trafficTypeId, long amount, boolean addToCalculate) {
        TrafficAmountKey key;
        assert (this.inetServRuntime.isHeldByCurrentThread());
        Map<TrafficAmountKey, TrafficAmountDelta> deltaTraffics = this.getDeltaTraffics(hour);
        TrafficAmountDelta t = deltaTraffics.get(key = new TrafficAmountKey(trafficTypeId, TrafficType.TIME_ID.equals(trafficTypeId) ? 0 : agentDeviceId));
        if (t == null) {
            if (addToCalculate) {
                t = new TrafficAmountDelta(amount, amount);
                deltaTraffics.put(key, t);
            } else {
                t = new TrafficAmountDelta(amount, 0L);
                deltaTraffics.put(key, t);
            }
        } else {
            t.flushAmountDelta += amount;
            if (addToCalculate) {
                t.calculateAmountDelta += amount;
            }
        }
        if (ConnectionLog.isTraceEnabled()) {
            ConnectionLog.log(this, Level.TRACE, "Add traffic " + trafficTypeId + "=" + amount);
        }
        this.trafficDeltaFlushAmount += amount;
        if (addToCalculate) {
            this.trafficDeltaCalculateAmount += amount;
        }
    }

    public void addTraffics(int agentDeviceId, Long hour, Map<Integer, AccountingTrafficAmount> traffics) {
        boolean addToCalculate = this.sessionDeviceState == 1;
        this.addTraffics(agentDeviceId, hour, traffics, addToCalculate);
    }

    public void addTraffics(int agentDeviceId, Long hour, Map<Integer, AccountingTrafficAmount> traffics, boolean addToCalculate) {
        assert (this.inetServRuntime.isHeldByCurrentThread());
        Map<TrafficAmountKey, TrafficAmountDelta> deltaTraffics = this.getDeltaTraffics(hour);
        for (Map.Entry<Integer, AccountingTrafficAmount> e : traffics.entrySet()) {
            Integer trafficTypeId = e.getKey();
            long amount = e.getValue().amount;
            if (trafficTypeId == TrafficType.TIME_ID) {
                this.addTime(amount);
            } else {
                TrafficAmountKey key = new TrafficAmountKey(trafficTypeId, agentDeviceId);
                TrafficAmountDelta t = deltaTraffics.get(key);
                if (t == null) {
                    if (addToCalculate) {
                        t = new TrafficAmountDelta(amount, amount);
                        deltaTraffics.put(key, t);
                    } else {
                        t = new TrafficAmountDelta(amount, 0L);
                        deltaTraffics.put(key, t);
                    }
                } else {
                    t.flushAmountDelta += amount;
                    if (addToCalculate) {
                        t.calculateAmountDelta += amount;
                    }
                }
            }
            if (ConnectionLog.isTraceEnabled()) {
                ConnectionLog.log(this, Level.TRACE, "Add traffic " + trafficTypeId + "=" + amount);
            }
            this.trafficDeltaFlushAmount += amount;
            if (!addToCalculate) continue;
            this.trafficDeltaCalculateAmount += amount;
        }
    }

    public void destroy() {
        this.accountingPeriodId = -1;
        this.accountingPeriodMillisFrom = -1L;
        this.accountingPeriodMillisTo = -1L;
        this.inetServRuntime.removeSession(this);
    }

    public void initTime(long sessionStartTime, long amount) {
        long time = sessionStartTime + amount * 1000L;
        Long trafficTimeHour = InetUtils.getHour(time);
        long trafficTimeCountdown = 3600L - time / 1000L % 3600L;
        logger.info("Time amount=" + amount + ", hh=" + trafficTimeHour + ", cc=" + trafficTimeCountdown);
        this.trafficTimeHour = trafficTimeHour;
        this.trafficTimeCountdown = trafficTimeCountdown;
    }

    public void initCounterTraffic(int trafficTypeId, long amount) {
        this.counterTraffics.put(trafficTypeId, new AccountingTrafficAmount(amount));
        if (trafficTypeId == TrafficType.TIME_ID) {
            this.initTime(this.call ? this.connectionStartTime : this.sessionStartTime, amount);
        }
    }

    private void addTime(long seconds) {
        assert (this.inetServRuntime.isHeldByCurrentThread());
        if (ConnectionLog.isTraceEnabled()) {
            ConnectionLog.log(this, Level.TRACE, "Add time " + seconds);
        }
        Long trafficTimeHour = this.trafficTimeHour;
        long trafficTimeCountdown = this.trafficTimeCountdown;
        while (seconds != 0L) {
            if (seconds > 0L) {
                if (trafficTimeCountdown > seconds) {
                    trafficTimeCountdown -= seconds;
                    this.addTraffic(0, trafficTimeHour, TrafficType.TIME_ID, seconds);
                    break;
                }
                this.addTraffic(0, trafficTimeHour, TrafficType.TIME_ID, trafficTimeCountdown);
                seconds -= trafficTimeCountdown;
                trafficTimeCountdown = 3600L;
                trafficTimeHour = trafficTimeHour + 3600000L;
                continue;
            }
            long delta = trafficTimeCountdown - 3600L;
            if (delta < seconds) {
                trafficTimeCountdown -= seconds;
                this.addTraffic(0, trafficTimeHour, TrafficType.TIME_ID, seconds);
                break;
            }
            this.addTraffic(0, trafficTimeHour, TrafficType.TIME_ID, delta);
            seconds -= delta;
            trafficTimeCountdown = 0L;
            trafficTimeHour = trafficTimeHour - 3600000L;
        }
        this.trafficTimeHour = trafficTimeHour;
        this.trafficTimeCountdown = trafficTimeCountdown;
    }

    public void updateTime(long millis) {
        assert (this.inetServRuntime.isHeldByCurrentThread());
        if (ConnectionLog.isTraceEnabled()) {
            ConnectionLog.log(this, Level.TRACE, "Update time to " + millis);
        }
        long startTime = this.call ? this.connectionStartTime : this.sessionStartTime;
        long seconds = millis / 1000L - startTime / 1000L;
        AccountingTrafficAmount currentAmount = this.counterTraffics.get(TrafficType.TIME_ID);
        if (currentAmount == null) {
            if (seconds > 0L) {
                this.counterTraffics.put(TrafficType.TIME_ID, new AccountingTrafficAmount(seconds));
                this.addTime(seconds);
            }
        } else {
            long delta = seconds - currentAmount.amount;
            if (seconds > System.currentTimeMillis() / 1000L - startTime / 1000L) {
                ConnectionLog.log(this, Level.WARN, new Date(millis));
                ConnectionLog.log(this, Level.WARN, new Date(System.currentTimeMillis()));
                ConnectionLog.log(this, Level.WARN, "Time: " + seconds);
            }
            if (delta < 0L) {
                ConnectionLog.log(this, Level.WARN, "a " + new Date(millis));
                ConnectionLog.log(this, Level.WARN, "a " + new Date(System.currentTimeMillis()));
                ConnectionLog.log(this, Level.WARN, "a Time: " + delta);
            }
            if (delta != 0L) {
                currentAmount.amount = seconds;
                seconds = delta;
                this.addTime(seconds);
            }
        }
    }

    public boolean lockIfSessionActive(long millis, long lockTimeout) {
        try {
            this.inetServRuntime.tryLockEx(lockTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        try {
            Date sessionStart = this.sessionStart;
            if (sessionStart.getTime() <= millis) {
                if (this.connection.getConnectionStatus() == 1) {
                    return true;
                }
                Date sessionStop = this.sessionStop;
                if (sessionStop == null || sessionStop.getTime() >= millis) {
                    return true;
                }
                long connectionFinishTimoutMillis = this.getConnectionFinishTimeoutMillis();
                if (connectionFinishTimoutMillis != 0L && sessionStop.getTime() / 1000L * 1000L + 999L + connectionFinishTimoutMillis >= millis) {
                    return true;
                }
            }
        }
        catch (RuntimeException e) {
            this.inetServRuntime.unlock();
            throw e;
        }
        this.inetServRuntime.unlock();
        return false;
    }

    public final long getConnectionFinishTimeoutMillis() {
        InetDeviceRuntime inetDeviceRuntime = this.inetDeviceRuntimeRef.get();
        if (inetDeviceRuntime != null) {
            return inetDeviceRuntime.connectionFinishTimeout * 1000L;
        }
        return 5000L;
    }

    public String toString() {
        return String.valueOf(this.connection);
    }

    public abstract boolean tryFinish(Accounting var1, ConnectionSet var2, BalanceDao var3, long var4, long var6) throws BGException;

    public abstract void finish(Accounting var1, ConnectionSet var2, BalanceDao var3, boolean var4, long var5, boolean var7) throws BGException;

    public Set<Integer> getInetOptions() {
        return this.inetOptions;
    }

    public void setInetOptions(Set<Integer> inetOptionSet) {
        this.inetOptions = inetOptionSet;
    }

    public boolean trySplitSession(Accounting accounting, Long hour, long millis) throws BGException {
        short deviceState;
        assert (this.inetServRuntime.isHeldByCurrentThread());
        boolean result = false;
        if (this.connection.getConnectionStatus() >= 3) {
            if (logger.isDebugEnabled()) {
                logger.info("Session " + this.sessionId + " is closed. Halt split.");
            }
            return false;
        }
        if (millis >= this.nextDayTime) {
            if (this.accountingPeriodMillisTo > 0L && millis > this.accountingPeriodMillisTo) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Splitting session by accounting period" + TimeUtils.format((Date)new Date(this.accountingPeriodMillisTo + 1L), (String)"dd.MM.yyyy HH:mm:ss.S"));
                }
                result = true;
                if (!this.splitSession(accounting, hour, this.accountingPeriodMillisTo + 1L, true)) {
                    logger.info("New accounting period not activated. Session split halted");
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Splitting session by new day start " + TimeUtils.format((Date)new Date(this.nextDayTime), (String)"dd.MM.yyyy HH:mm:ss.S"));
                }
                result = true;
                this.splitSession(accounting, hour, this.nextDayTime, true);
            }
        } else if (this.accountingPeriodId >= 0 && this.accountingPeriodId != this.inetServRuntime.accountingPeriodId) {
            if (logger.isDebugEnabled()) {
                logger.debug("Splitting session by accounting period modified.");
            }
            result = true;
            if (!this.splitSession(accounting, hour, (long)((double)millis / 1000.0) * 1000L, true)) {
                logger.info("New accounting period not activated. Session split halted");
            }
        } else {
            long nextTariffOptionTime = this.nextTariffOptionTime;
            if (nextTariffOptionTime != 0L && millis >= nextTariffOptionTime && nextTariffOptionTime > this.sessionStartTime) {
                InetDeviceRuntime deviceRuntime = accounting.deviceMap.get(this.connection.getDeviceId());
                if (deviceRuntime == null || deviceRuntime.sessionSplitOnTariffOption) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Splitting session by tariff option " + TimeUtils.format((Date)new Date(nextTariffOptionTime), (String)"dd.MM.yyyy HH:mm:ss.S"));
                    }
                    result = true;
                    this.splitSession(accounting, hour, (long)((double)nextTariffOptionTime / 1000.0) * 1000L, false);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("No need split session by tariff option " + TimeUtils.format((Date)new Date(nextTariffOptionTime), (String)"dd.MM.yyyy HH:mm:ss.S"));
                    }
                    this.nextTariffOptionTime = InetUtils.roundToSeconds(this.inetServRuntime.contractRuntime.getTariffOptions(accounting.initialDate).nextActivateTime(millis + 1000L));
                }
            }
        }
        short s = deviceState = this.isCall() ? this.connection.getDeviceState() : this.inetServRuntime.getParentInetServ(accounting).getDeviceState();
        if (this.sessionDeviceState != deviceState) {
            InetDeviceRuntime deviceRuntime = accounting.deviceMap.get(this.connection.getDeviceId());
            if (deviceRuntime == null || deviceRuntime.sessionSplitOnDeviceState) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Splitting session by deviceState. Old state=" + this.sessionDeviceState + ", new state=" + deviceState);
                }
                result = true;
                this.splitSession(accounting, hour, (long)((double)millis / 1000.0) * 1000L, false);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("No need split session by deviceState. Old state=" + this.sessionDeviceState + ", new state=" + deviceState);
                }
                this.sessionDeviceState = deviceState;
            }
            this.kill = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Try to split session " + this.sessionId + ". result = " + result);
        }
        return result;
    }

    public boolean splitSession(Accounting accounting, Long hour, long millis, boolean setAccountingPeriod) throws BGException {
        ConnectionSet connectionSet = ((DefaultContext)ThreadContext.get(DefaultContext.class)).getConnectionSet();
        try {
            Connection con = connectionSet.getConnection();
            InetSessionDao inetSessionDao = new InetSessionDao(con, accounting.moduleId);
            this.splitSessionImpl(accounting, connectionSet, con, inetSessionDao, hour, millis, setAccountingPeriod, 0L);
            if (setAccountingPeriod) {
                this.setAccountingPeriod(accounting, connectionSet, millis, true);
                if (this.accountingPeriodId > 0 || this.sessionDeviceState == 1) {
                    // empty if block
                }
            }
            connectionSet.commit();
            return true;
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected void splitSessionImpl(Accounting accounting, ConnectionSet connectionSet, Connection con, InetSessionDao inetSessionDao, Long hour, long millis, boolean setAccountingPeriod, long parentSessionId) throws BGException, SQLException {
        boolean result = inetSessionDao.closeSession(this.connection.getId(), this.sessionId, new Date(millis - 1L));
        if (!result) {
            logger.debug("Session already splitted");
            List<InetSession> inetSessionList = inetSessionDao.list(this.connection.getId(), 1);
            if (inetSessionList.size() > 0) {
                logger.debug("Set new splitted session from DB");
                InetSession newSession = inetSessionList.get(inetSessionList.size() - 1);
                this.setSession(accounting, newSession, false, true);
            } else {
                logger.error("Splitted session was closed but new not found. Finishing...");
                BalanceDao balanceDao = new BalanceDao(con);
                if (this.connection.getConnectionStatus() < 3) {
                    this.connection.setConnectionStatus(3);
                }
                this.forceFinish(accounting, connectionSet, balanceDao, false, millis);
                balanceDao.recycle();
            }
        } else {
            InetConnection connection = this.connection;
            InetSession newSession = new InetSession(connection);
            newSession.setId(0L);
            newSession.setParentId(parentSessionId);
            newSession.setSplittedId(this.sessionId);
            newSession.setSessionStart(new Date(millis));
            newSession.setLastActive(newSession.getSessionStart());
            newSession.setSessionStop(null);
            newSession.setSessionTime(0L);
            newSession.setSessionCost(BigDecimal.ZERO);
            if (!this.isCall()) {
                connection.setDeviceState(this.inetServRuntime.getParentInetServ(accounting).getDeviceState());
            }
            newSession.setDeviceState(this.connection.getDeviceState());
            newSession.setStatus(1);
            this.sessionStop = new Date(millis - 1L);
            BalanceDao balanceDao = new BalanceDao(con);
            boolean finishResult = accounting.sessionFinish(connectionSet, balanceDao, this, false, false, false);
            balanceDao.recycle();
            assert (finishResult);
            logger.info("Write new session to DB");
            new InetSessionDao(con, accounting.moduleId).insert(newSession);
            logger.info("New session's id=" + newSession.getId());
            InetConnection.setType((InetConnection)connection, (int)2, (boolean)true);
            new InetConnectionDao(con, accounting.moduleId).updateType(connection.getDeviceId(), connection.getId(), connection.getType());
            if (this.isCall()) {
                this.flushInitialTraffics(con, accounting.moduleId, newSession.getId());
                this.setSession(accounting, newSession, false, true);
            } else {
                this.setSession(accounting, newSession, false, true);
            }
        }
    }

    public void flushInitialTraffics(Connection con, int moduleId, long sessionId) throws BGException {
        try {
            if (this.counterTraffics.size() > 0) {
                PreparedStatement ps = con.prepareStatement("INSERT INTO inet_session_detail_" + moduleId + " (sessionId, day, hour, deviceId, trafficTypeId, amount) VALUES (?,?,?,0,?,?)");
                ps.setLong(1, sessionId);
                ps.setInt(2, 0);
                ps.setInt(3, 0);
                for (Map.Entry<Integer, AccountingTrafficAmount> e : this.counterTraffics.entrySet()) {
                    long amount = e.getValue().amount;
                    if (amount == 0L) continue;
                    ps.setInt(4, e.getKey());
                    ps.setLong(5, amount);
                    ps.executeUpdate();
                }
                ps.close();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public boolean processAccessCode(Accounting accounting, ConnectionSet connectionSet, int accessCode) throws BGException {
        return false;
    }

    public boolean processInetOptions(InetApplication application, Set<Integer> newOptions) throws BGException {
        return true;
    }

    public int checkAccountingPeriod(Accounting accounting, ConnectionSet connectionSet, boolean forceSet) throws BGException {
        if (ConnectionLog.isDebugEnabled()) {
            ConnectionLog.log(this, Level.DEBUG, "Checking accounting period");
        }
        if (this.accountingPeriodId == -1 || forceSet && this.accountingPeriodId == 0) {
            if (ConnectionLog.isDebugEnabled()) {
                ConnectionLog.log(this, Level.DEBUG, "Setting accounting period");
            }
            this.setAccountingPeriod(accounting, connectionSet, this.sessionStartTime, forceSet);
        }
        if (this.accountingPeriodId == 0) {
            return 4;
        }
        return 0;
    }

    public void connectionStop(Date sessionStop, long finishTimeout) {
        logger.info("Stopping connection with id=" + this.connection.getId());
        this.sessionStop = sessionStop;
        this.connection.setConnectionStatus(3);
        this.lastAccountTime = this.lastFlowTime = sessionStop.getTime() / 1000L + finishTimeout;
    }

    public boolean isServiceSession() {
        return false;
    }

    public void forceStop(Accounting accounting, ConnectionSet connectionSet, long millis, boolean force) throws BGException {
    }

    public void forceFinish(Accounting accounting, ConnectionSet connectionSet, BalanceDao balanceDao, boolean needStop, long currentTimeMillis) throws BGException {
        assert (this.inetServRuntime.isHeldByCurrentThread());
        this.finish(accounting, connectionSet, balanceDao, needStop, currentTimeMillis, true);
    }

    public void setAccountingPeriod(InetApplication application, ConnectionSet connectionSet, long millis, boolean activate) throws BGException {
        AbstractPeriodItemSet.PeriodItem accountingPeriodRuntime = this.inetServRuntime.accountingPeriodCheck(application, connectionSet, millis, false, this.sessionDeviceState == 1 || activate);
        if (ConnectionLog.isDebugEnabled()) {
            ConnectionLog.log(this, Level.DEBUG, "accounting period: " + accountingPeriodRuntime != null ? accountingPeriodRuntime : "null");
        }
        if (accountingPeriodRuntime != null) {
            this.accountingPeriodId = accountingPeriodRuntime.id;
            this.accountingPeriodMillisFrom = accountingPeriodRuntime.timeFrom;
            this.accountingPeriodMillisTo = accountingPeriodRuntime.timeTo;
        } else {
            this.accountingPeriodId = 0;
            this.accountingPeriodMillisFrom = -1L;
            this.accountingPeriodMillisTo = -1L;
        }
    }

    public String getRealm() {
        return null;
    }

    public String getAcctService() {
        return null;
    }

    public long getSuspendTimeout(InetDeviceRuntime deviceRuntime) {
        return deviceRuntime.connectionSuspendTimeout;
    }

    public long getCloseTimeout(InetDeviceRuntime deviceRuntime) {
        return deviceRuntime.connectionCloseTimeout;
    }
}

