/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.bean;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.LocalTime;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.json.JsonAdapters;
import ru.bitel.common.xml.XmlAdapters;

public class InetServRestrictionTimeCondition {
    private Logger logger = LogManager.getLogger();
    private LocalTime timeFrom;
    private LocalTime timeTo;
    private Set<Integer> daysOfWeek;
    private Set<Integer> months;
    private Set<Integer> daysOfMonth;
    private int mode;

    @XmlJavaTypeAdapter(value=XmlAdapters.LocalTimeAdapter.class)
    @JsonSerialize(using=JsonAdapters.LocalTimeSerializer.class)
    @JsonDeserialize(using=JsonAdapters.LocalTimeDeserializer.class)
    public LocalTime getTimeFrom() {
        return this.timeFrom;
    }

    public void setTimeFrom(LocalTime timeFrom) {
        this.timeFrom = timeFrom;
    }

    @XmlJavaTypeAdapter(value=XmlAdapters.LocalTimeAdapter.class)
    @JsonSerialize(using=JsonAdapters.LocalTimeSerializer.class)
    @JsonDeserialize(using=JsonAdapters.LocalTimeDeserializer.class)
    public LocalTime getTimeTo() {
        return this.timeTo;
    }

    public void setTimeTo(LocalTime timeTo) {
        this.timeTo = timeTo;
    }

    @XmlAttribute
    public Set<Integer> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public void setDaysOfWeek(Set<Integer> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    @XmlAttribute
    public Set<Integer> getMonths() {
        return this.months;
    }

    public void setMonths(Set<Integer> months) {
        this.months = months;
    }

    @XmlAttribute
    public Set<Integer> getDaysOfMonth() {
        return this.daysOfMonth;
    }

    public void setDaysOfMonth(Set<Integer> daysOfMonth) {
        this.daysOfMonth = daysOfMonth;
    }

    @XmlAttribute
    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mode == 0) {
            sb.append("\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e ");
        } else {
            sb.append("\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e ");
        }
        sb.append("\u0441 ").append(this.timeFrom).append(" \u0434\u043e ").append(this.timeTo);
        try {
            if (this.daysOfWeek != null && this.daysOfWeek.size() > 0) {
                sb.append(", ").append(this.daysOfWeek.stream().sorted().map(d -> TimeUtils.weekDayName[d - 1]).collect(Collectors.joining(",")));
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        try {
            if (this.daysOfMonth != null && this.daysOfMonth.size() > 0) {
                sb.append(", \u0434\u043d\u0438 \u043c\u0435\u0441\u044f\u0446\u0430: ").append(this.daysOfMonth.stream().sorted().map(String::valueOf).collect(Collectors.joining(",")));
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        try {
            if (this.months != null && this.months.size() > 0) {
                sb.append(", \u043c\u0435\u0441\u044f\u0446\u044b: ").append(this.months.stream().sorted().map(String::valueOf).collect(Collectors.joining(",")));
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        return sb.toString();
    }
}

